/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.peer.ScrollbarPeer;

public class Scrollbar
extends Component
implements Adjustable {
    static final int DEFAULTVALUE = 0;
    static final int DEFAULTVISIBLEAMOUNT = 10;
    static final int DEFAULTMINIMUM = 0;
    static final int DEFAULTMAXIMUM = 100;
    static final int DEFAULTUNITINCREMENT = 1;
    static final int DEFAULTBLOCKINCREMENT = 10;
    static final int DEFAULTORIENTATION = 1;
    private int scrollbarMinimum;
    private int scrollbarMaximum;
    private int scrollbarVisible;
    private int scrollbarOrientation;
    private int scrollbarValue;
    private int scrollbarBlockInc;
    private int scrollbarUnitInc;
    public transient AdjustmentListener multiListener;

    public Scrollbar() {
        this(1, 0, 10, 0, 100);
    }

    public Scrollbar(int orientation) {
        this(orientation, 0, 10, 0, 100);
    }

    public Scrollbar(int orientation, int value, int visible, int minimum, int maximum) {
        this.scrollbarOrientation = orientation;
        this.scrollbarValue = value;
        this.scrollbarVisible = visible;
        if (minimum < maximum) {
            this.scrollbarMinimum = minimum;
            this.scrollbarMaximum = maximum;
        } else {
            this.scrollbarMinimum = maximum;
            this.scrollbarMaximum = minimum;
        }
        this.multiListener = null;
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createScrollbar(this);
        }
        if (!this.notified) {
            super.addNotify();
        }
    }

    public void addAdjustmentListener(AdjustmentListener newlistener) {
        this.multiListener = AWTEventMulticaster.add(this.multiListener, newlistener);
    }

    public void removeAdjustmentListener(AdjustmentListener newlistener) {
        this.multiListener = AWTEventMulticaster.remove(this.multiListener, newlistener);
    }

    protected void processEvent(AWTEvent e) {
        if (e instanceof AdjustmentEvent) {
            this.scrollbarValue = ((AdjustmentEvent)e).getValue();
            if (this.multiListener != null) {
                this.multiListener.adjustmentValueChanged((AdjustmentEvent)e);
            }
        } else {
            super.processEvent(e);
        }
    }

    protected void processAdjustmentEvent(AdjustmentEvent e) {
        if (this.multiListener != null) {
            this.multiListener.adjustmentValueChanged(e);
        }
    }

    public int getOrientation() {
        return this.scrollbarOrientation;
    }

    public void setOrientation(int orientation) {
        this.scrollbarOrientation = orientation;
    }

    public int getMaximum() {
        return this.scrollbarMaximum;
    }

    public void setMaximum(int maximum) {
        this.scrollbarMaximum = maximum;
        this.setValues(this.scrollbarValue, this.scrollbarVisible, this.scrollbarMinimum, this.scrollbarMaximum);
    }

    public int getMinimum() {
        return this.scrollbarMinimum;
    }

    public void setMinimum(int minimum) {
        this.scrollbarMinimum = minimum;
        this.setValues(this.scrollbarValue, this.scrollbarVisible, this.scrollbarMinimum, this.scrollbarMaximum);
    }

    public int getValue() {
        return this.scrollbarValue;
    }

    public void setValue(int value) {
        this.scrollbarValue = value;
        this.setValues(this.scrollbarValue, this.scrollbarVisible, this.scrollbarMinimum, this.scrollbarMaximum);
    }

    public int getVisibleAmount() {
        return this.scrollbarVisible;
    }

    public int getVisible() {
        return this.getVisibleAmount();
    }

    public void setVisibleAmount(int visible) {
        this.scrollbarVisible = visible;
        this.setValues(this.scrollbarValue, this.scrollbarVisible, this.scrollbarMinimum, this.scrollbarMaximum);
    }

    public void setValues(int value, int visible, int minimum, int maximum) {
        ((ScrollbarPeer)this.peer).setValues(value, visible, minimum, maximum);
    }

    public int getUnitIncrement() {
        return this.scrollbarUnitInc;
    }

    public void setUnitIncrement(int increment) {
        this.scrollbarUnitInc = increment;
        ((ScrollbarPeer)this.peer).setLineIncrement(increment);
    }

    public int getBlockIncrement() {
        return this.scrollbarBlockInc;
    }

    public void setBlockIncrement(int increment) {
        this.scrollbarBlockInc = increment;
        ((ScrollbarPeer)this.peer).setPageIncrement(increment);
    }

    protected String paramString() {
        String param = "Scrollbar< orientation: " + this.getOrientation() + " min: " + this.scrollbarMinimum;
        param = param + "component <" + super.paramString() + ">";
        return param;
    }

    public String toString() {
        String param = this.scrollbarOrientation == 0 ? "Horizontal Scrollbar" : "Vertical Scrollbar";
        param = param + "Covering " + this.scrollbarMinimum + " to " + this.scrollbarMaximum;
        return param;
    }
}

