/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;

class ScrollPaneLayout
implements LayoutManager2 {
    public static final String HSB = "HSB";
    public static final String VSB = "VSB";
    public static final String VIEW = "VIEW";
    Component hsb;
    Component vsb;
    Component view;

    public Dimension preferredLayoutSize(Container container) {
        Dimension d;
        Insets insets = container.getInsets();
        int plw = 0;
        int plh = 0;
        if (this.vsb != null && this.vsb.isVisible()) {
            d = this.hsb.getPreferredSize();
            plw += d.width;
            plh = Math.max(plh, d.height);
        }
        if (this.view != null) {
            d = this.view.getSize();
            plw += d.width;
            plh = Math.max(plh, d.height);
        }
        if (this.hsb != null) {
            d = this.hsb.getPreferredSize();
            plw = Math.max(plw, d.width);
            plh += d.height;
        }
        plw = plw + insets.left + insets.right;
        plh = plh + insets.top + insets.bottom;
        return new Dimension(plw, plh);
    }

    public void addLayoutComponent(Component component, Object constraints) {
        if (constraints == null) {
            this.addLayoutComponent((String)null, component);
            throw new IllegalArgumentException("cannot add component to ScrollPaneLayout: constraint must be a string");
        }
        if (!(constraints instanceof String)) {
            throw new IllegalArgumentException("cannot add component to ScrollPaneLayout: constraint must be a string");
        }
        this.addLayoutComponent((String)constraints, component);
    }

    public void addLayoutComponent(String name, Component comp) {
        if (HSB.equals(name)) {
            this.hsb = comp;
        } else if (VSB.equals(name)) {
            this.vsb = comp;
        } else if (VIEW.equals(name)) {
            this.view = comp;
        } else {
            throw new IllegalArgumentException("cannot add component to ScrollPaneLayout: unknown constraint: " + name);
        }
    }

    public void removeLayoutComponent(Component comp) {
        if (comp == this.hsb) {
            this.hsb = null;
        } else if (comp == this.vsb) {
            this.vsb = null;
        } else if (comp == this.view) {
            this.view = null;
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension minimumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container parent) {
        return parent.getAlignmentX();
    }

    public float getLayoutAlignmentY(Container parent) {
        return parent.getAlignmentY();
    }

    public void invalidateLayout(Container container) {
    }

    public void layoutContainer(Container container) {
        Dimension d;
        Insets in = container.getInsets();
        int rn = in.top;
        int rw = in.left;
        int re = container.width - in.right;
        int rs = container.height - in.bottom;
        if (this.hsb != null && this.hsb.isVisible()) {
            d = this.hsb.getPreferredSize();
            this.hsb.setBounds(rw, rs - d.height, re - rw, d.height);
            rs -= d.height;
        }
        if (this.vsb != null && this.vsb.isVisible()) {
            d = this.vsb.getPreferredSize();
            this.vsb.setBounds(re - d.width, rn, d.width, rs - rn);
            re -= d.width;
        }
        if (this.view != null) {
            this.view.setBounds(rw, rn, re - rw, rs - rn);
        }
    }

    public String toString() {
        return this.getClass().getName();
    }
}

