/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.ScrollPaneLayout;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.peer.ScrollPanePeer;

public class ScrollPane
extends Container
implements AdjustmentListener,
ComponentListener {
    public static final int SCROLLBARS_AS_NEEDED = 0;
    public static final int SCROLLBARS_ALWAYS = 1;
    public static final int SCROLLBARS_NEVER = 2;
    private Scrollbar hsb;
    private Scrollbar vsb;
    private int vwidth;
    private int vheight;
    private int scrollbarDisplayPolicy;
    private Component comp = null;
    private Panel viewport = new Panel(null);
    private Panel componentPanel;
    private boolean loop = false;

    public ScrollPane() {
        this(0);
    }

    public ScrollPane(int policy) {
        if (policy < 0 || policy > 2) {
            throw new IllegalArgumentException("invalid policy specified : " + policy);
        }
        this.hsb = new Scrollbar(0, 0, 5, 0, 5);
        this.vsb = new Scrollbar(1, 0, 5, 0, 5);
        this.hsb.setVisible(false);
        this.vsb.setVisible(false);
        this.hsb.addAdjustmentListener(this);
        this.vsb.addAdjustmentListener(this);
        this.scrollbarDisplayPolicy = policy;
        this.setLayout(new ScrollPaneLayout());
        this.add((Component)this.hsb, "HSB");
        this.add((Component)this.vsb, "VSB");
        this.add((Component)this.viewport, "VIEW");
        this.invalidate();
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createScrollPane(this);
        }
        if (!this.notified) {
            super.addNotify();
        }
    }

    protected final void addImpl(Component component, Object constraints, int position) {
        component.addComponentListener(this);
        if (component != this.hsb && component != this.vsb && component != this.viewport) {
            if (this.comp != null) {
                if (this.comp instanceof Container) {
                    this.viewport.remove(this.comp);
                } else {
                    this.viewport.remove(this.componentPanel);
                }
            }
            this.comp = component;
            if (component instanceof Container) {
                this.viewport.add(this.comp);
            } else {
                this.componentPanel = new Panel();
                this.componentPanel.add(this.comp);
                this.viewport.add(this.componentPanel);
            }
            this.doLayout();
        } else {
            super.addImpl(component, constraints, position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLayout() {
        this.loop = true;
        super.doLayout();
        this.vwidth = this.getSize().width;
        this.vheight = this.getSize().height;
        if (this.comp != null) {
            Dimension ps = this.comp.getPreferredSize();
            if (ps == null) {
                ps = new Dimension(0, 0);
            }
            switch (this.scrollbarDisplayPolicy) {
                case 2: {
                    break;
                }
                case 1: {
                    this.hsb.setVisible(true);
                    this.vheight -= this.getHScrollbarHeight();
                    this.vsb.setVisible(true);
                    this.vwidth -= this.getVScrollbarWidth();
                    break;
                }
                case 0: {
                    if (ps.width > this.vwidth) {
                        this.hsb.setVisible(true);
                        this.vheight -= this.getHScrollbarHeight();
                    } else {
                        this.hsb.setVisible(false);
                    }
                    if (ps.getSize().height > this.vheight) {
                        this.vsb.setVisible(true);
                        this.vwidth -= this.getVScrollbarWidth();
                        break;
                    }
                    this.vsb.setVisible(false);
                }
            }
            this.hsb.setMaximum(Math.max(0, ps.width - this.vwidth) + this.vwidth);
            this.vsb.setMaximum(Math.max(0, ps.height - this.vheight) + this.vheight);
            this.hsb.setVisibleAmount(this.vwidth);
            this.vsb.setVisibleAmount(this.vheight);
            if (ps.width < this.vwidth) {
                ps.width = this.vwidth;
            }
            if (ps.height < this.vheight) {
                ps.height = this.vheight;
            }
            Object object = this.getTreeLock();
            synchronized (object) {
                this.viewport.setBounds(0, 0, this.vwidth, this.vheight);
                if (this.comp instanceof Container) {
                    this.comp.setBounds(0, 0, ps.width, ps.height);
                } else {
                    this.componentPanel.setBounds(0, 0, ps.width, ps.height);
                    this.comp.setBounds(0, 0, ps.width, ps.height);
                }
                ((ScrollPanePeer)this.peer).childResized(this.vwidth, this.vheight);
            }
        }
        this.loop = false;
    }

    public int getScrollbarDisplayPolicy() {
        return this.scrollbarDisplayPolicy;
    }

    public Adjustable getHAdjustable() {
        return this.hsb;
    }

    public Adjustable getVAdjustable() {
        return this.vsb;
    }

    public int getHScrollbarHeight() {
        return this.hsb.getHeight();
    }

    public Point getScrollPosition() {
        return new Point(this.hsb.getValue(), this.vsb.getValue());
    }

    public int getVScrollbarWidth() {
        return this.vsb.getWidth();
    }

    public Dimension getViewportSize() {
        return new Dimension(this.vwidth, this.vheight);
    }

    public void setScrollPosition(Point p) {
        this.setScrollPosition(p.x, p.y);
    }

    public void setScrollPosition(int x, int y) {
        if (x > this.comp.getSize().width - this.vwidth) {
            x = Math.max(0, this.comp.getSize().width - this.vwidth);
        }
        if (y > this.comp.getSize().height - this.vheight) {
            y = Math.max(0, this.comp.getSize().height - this.vheight);
        }
        this.hsb.setValue(x);
        this.vsb.setValue(y);
        ((ScrollPanePeer)this.peer).setScrollPosition(x, y);
    }

    public void adjustmentValueChanged(AdjustmentEvent event) {
        ((ScrollPanePeer)this.peer).setValue(event.getAdjustable(), event.getValue());
    }

    public String paramString() {
        return "";
    }

    public void printComponents(Graphics g) {
        System.out.println("[TODO] java.awt.ScrollPane.printComponents(Graphics g)");
    }

    public Component getComponent(int index) {
        if (this.comp != null && index == 0) {
            return this.comp;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public int getComponentCount() {
        if (this.comp != null) {
            return 1;
        }
        return 0;
    }

    public Component[] getComponents() {
        Component[] list = new Component[]{};
        if (this.comp != null) {
            list = new Component[]{this.comp};
        }
        return list;
    }

    public void componentHidden(ComponentEvent event) {
        if (!this.loop) {
            this.doLayout();
        }
    }

    public void componentMoved(ComponentEvent event) {
        if (!this.loop) {
            this.doLayout();
        }
    }

    public void componentResized(ComponentEvent event) {
        if (!this.loop) {
            this.doLayout();
        }
    }

    public void componentShown(ComponentEvent event) {
        if (!this.loop) {
            this.doLayout();
        }
    }
}

