/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Shape;
import java.io.Serializable;

public class Rectangle
implements Shape,
Serializable {
    private static final long serialVersionUID = -4345857070255674764L;
    public int x;
    public int y;
    public int width;
    public int height;

    public Rectangle() {
        this(0, 0, 0, 0);
    }

    public Rectangle(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Rectangle(Rectangle r) {
        this(r.x, r.y, r.width, r.height);
    }

    public Rectangle(int width, int height) {
        this(0, 0, width, height);
    }

    public Rectangle(Point p, Dimension d) {
        this(p.x, p.y, d.width, d.height);
    }

    public Rectangle(Point p) {
        this(p.x, p.y, 0, 0);
    }

    public Rectangle(Dimension d) {
        this(0, 0, d.width, d.height);
    }

    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public boolean equals(Object object) {
        if (object instanceof Rectangle) {
            Rectangle other = (Rectangle)object;
            return other.x == this.x && other.y == this.y && other.width == this.width && other.height == this.height;
        }
        return false;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void reshape(int x, int y, int width, int height) {
        this.setBounds(x, y, width, height);
    }

    public void grow(int h, int v) {
        this.x -= h;
        this.width += h + h;
        this.y -= v;
        this.height -= v + v;
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public void setLocation(Point p) {
        this.setLocation(p.x, p.y);
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void translate(int x, int y) {
        this.x += x;
        this.y += y;
    }

    public void move(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public void setSize(Dimension d) {
        this.resize(d.width, d.height);
    }

    public void setSize(int width, int height) {
        this.resize(width, height);
    }

    public void resize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    public boolean contains(int x, int y) {
        return x >= this.x && x < this.x + this.width && y >= this.y && y < this.y + this.height;
    }

    public boolean contains(Rectangle other) {
        int distance = other.x + other.width - this.x;
        if (distance < 0 || distance > this.width) {
            return false;
        }
        distance = other.y + other.height - this.y;
        if (distance < 0 || distance > this.height) {
            return false;
        }
        distance = other.x - this.x;
        if (distance < 0 || distance > this.width) {
            return false;
        }
        distance = other.y - this.y;
        return distance >= 0 && distance <= this.height;
    }

    public boolean contains(int other_x, int other_y, int other_width, int other_height) {
        int distance = other_x + other_width - this.x;
        if (distance < 0 || distance > this.width) {
            return false;
        }
        distance = other_y + other_height - this.y;
        if (distance < 0 || distance > this.height) {
            return false;
        }
        distance = other_x - this.x;
        if (distance < 0 || distance > this.width) {
            return false;
        }
        distance = other_y - this.y;
        return distance >= 0 && distance <= this.height;
    }

    public boolean inside(int x, int y) {
        return x >= this.x && x < this.x + this.width && y >= this.y && y < this.y + this.height;
    }

    public void add(int newx, int newy) {
        if (newx < this.x) {
            this.width = this.width + this.x - newx;
            this.x = newx;
        } else if (newx > this.x + this.width) {
            this.width = newx - this.x;
        }
        if (newy < this.y) {
            this.height = this.height + this.y - newy;
            this.y = newy;
        } else if (newy > this.y + this.height) {
            this.height = newy - this.y;
        }
    }

    public void add(Point pt) {
        if (pt.x < this.x) {
            this.width = this.width + this.x - pt.x;
            this.x = pt.x;
        } else if (pt.x > this.x + this.width) {
            this.width = pt.x - this.x;
        }
        if (pt.y < this.y) {
            this.height = this.height + this.y - pt.y;
            this.y = pt.y;
        } else if (pt.y > this.y + this.height) {
            this.height = pt.y - this.y;
        }
    }

    public void add(Rectangle other) {
        int newx0 = other.x < this.x ? other.x : this.x;
        int newx1 = other.x + other.width > this.x + this.width ? other.x + other.width : this.x + this.width;
        int newy0 = other.y < this.y ? other.y : this.y;
        int newy1 = other.y + other.height > this.y + this.height ? other.y + other.height : this.y + this.height;
        this.x = newx0;
        this.width = newx1 - newx0;
        this.y = newy0;
        this.height = newy1 - newy0;
    }

    public boolean intersects(Rectangle other) {
        if (other.x + other.width < this.x) {
            return false;
        }
        if (this.x + this.width < other.x) {
            return false;
        }
        if (other.y + other.height < this.y) {
            return false;
        }
        return this.y + this.height >= other.y;
    }

    public Rectangle intersection(Rectangle other) {
        int newy1;
        int newx1;
        int newx0 = other.x > this.x ? other.x : this.x;
        int n = newx1 = other.x + other.width < this.x + this.width ? other.x + other.width : this.x + this.width;
        if (newx0 > newx1) {
            return new Rectangle();
        }
        int newy0 = other.y > this.y ? other.y : this.y;
        int n2 = newy1 = other.y + other.height < this.y + this.height ? other.y + other.height : this.y + this.height;
        if (newy0 > newy1) {
            return new Rectangle();
        }
        return new Rectangle(newx0, newy0, newx1 - newx0, newy1 - newy0);
    }

    public Rectangle union(Rectangle other) {
        int newx0 = other.x < this.x ? other.x : this.x;
        int newx1 = other.x + other.width > this.x + this.width ? other.x + other.width : this.x + this.width;
        int newy0 = other.y < this.y ? other.y : this.y;
        int newy1 = other.y + other.height > this.y + this.height ? other.y + other.height : this.y + this.height;
        return new Rectangle(newx0, newy0, newx1 - newx0, newy1 - newy0);
    }

    public String toString() {
        return this.getClass().getName() + "[x = " + this.x + ", y = " + this.y + ", width = " + this.width + ", height = " + this.height + "]";
    }
}

