/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.peer.LabelPeer;

public class Label
extends Component {
    String text;
    int alignment = 0;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    private LabelPeer peer;

    public Label() {
        this("", 0);
    }

    public Label(String label) {
        this(label, 0);
    }

    public Label(String text, int alignment) {
        this.setText(text);
        switch (alignment) {
            case 0: 
            case 1: 
            case 2: {
                this.setAlignment(alignment);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid alignment: " + alignment);
            }
        }
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createLabel(this);
        }
        if (!this.notified) {
            super.addNotify();
        }
    }

    public int getAlignment() {
        return this.alignment;
    }

    public String getText() {
        return this.text;
    }

    public synchronized void setAlignment(int alignment) {
        switch (alignment) {
            case 0: 
            case 1: 
            case 2: {
                this.alignment = alignment;
                break;
            }
            default: {
                throw new IllegalArgumentException("improper alignment: " + alignment);
            }
        }
        this.valid = false;
        this.peer.setAlignment(alignment);
    }

    public synchronized void setText(String text) {
        this.text = text;
        this.invalidate();
        this.peer.setText(text);
    }

    public String toString() {
        return this.getClass().getName() + " - text: " + this.text + ", bounds: x = " + this.x + ", y = " + this.y + ", w = " + this.width + ", h = " + this.height;
    }

    protected String paramString() {
        return this.getClass().getName() + " text=[" + this.text + "] alignment=" + this.alignment + ", bounds:(" + this.x + ", " + this.y + ", " + this.width + ", " + this.height + ")";
    }
}

