/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class GridLayout
implements LayoutManager,
Serializable {
    private static final long serialVersionUID = -7411804673224730901L;
    int hgap;
    int vgap;
    int rows;
    int cols;

    public GridLayout() {
        this(1, 0, 0, 0);
    }

    public GridLayout(int rows, int cols) {
        this(rows, cols, 0, 0);
    }

    public GridLayout(int rows, int cols, int hgap, int vgap) {
        if (rows < 0 || cols < 0) {
            throw new IllegalArgumentException("invalid parameters");
        }
        if (hgap < 0) {
            hgap = 0;
        }
        if (vgap < 0) {
            vgap = 0;
        }
        if (rows == 0 && cols == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        this.rows = rows;
        this.cols = cols;
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        if (rows == 0 && this.cols == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        this.rows = rows;
    }

    public int getColumns() {
        return this.cols;
    }

    public void setColumns(int cols) {
        if (cols == 0 && this.rows == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        this.cols = cols;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void addLayoutComponent(Component comp, Object contstraints) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    private Dimension layoutSize(Container parent, boolean min) {
        Insets insets = parent.getInsets();
        int ncomponents = parent.getComponentCount();
        int nrows = this.rows;
        int ncols = this.cols;
        if (nrows > 0) {
            ncols = ncomponents % nrows == 0 ? ncomponents / nrows : ncomponents / nrows + 1;
        } else {
            nrows = ncomponents % ncols == 0 ? ncomponents / ncols : ncomponents / ncols + 1;
        }
        int w = 0;
        int h = 0;
        for (int i = 0; i < ncomponents; ++i) {
            Component comp = parent.getComponent(i);
            Dimension d = min ? comp.getMinimumSize() : comp.getPreferredSize();
            if (w < d.width) {
                w = d.width;
            }
            if (h >= d.height) continue;
            h = d.height;
        }
        return new Dimension(insets.left + insets.right + ncols * w + (ncols - 1) * this.hgap, insets.top + insets.bottom + nrows * h + (nrows - 1) * this.vgap);
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.layoutSize(parent, true);
    }

    public Dimension preferredLayoutSize(Container parent) {
        return this.layoutSize(parent, false);
    }

    public Dimension maximumLayoutSize(Container parent) {
        return this.layoutSize(parent, false);
    }

    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        int ncomponents = parent.getComponentCount();
        int nrows = this.rows;
        int ncols = this.cols;
        if (ncomponents == 0) {
            return;
        }
        if (nrows > 0) {
            ncols = ncomponents % nrows == 0 ? ncomponents / nrows : ncomponents / nrows + 1;
        } else {
            nrows = ncomponents % ncols == 0 ? ncomponents / ncols : ncomponents / ncols + 1;
        }
        int w = parent.width - (insets.left + insets.right);
        int h = parent.height - (insets.top + insets.bottom);
        w = (w - (ncols - 1) * this.hgap) / ncols;
        h = (h - (nrows - 1) * this.vgap) / nrows;
        int c = 0;
        int x = insets.left;
        while (c < ncols) {
            int r = 0;
            int y = insets.top;
            while (r < nrows) {
                int i = r * ncols + c;
                if (i < ncomponents) {
                    parent.getComponent(i).setBounds(x, y, w, h);
                }
                ++r;
                y += h + this.vgap;
            }
            ++c;
            x += w + this.hgap;
        }
    }

    public String toString() {
        return this.getClass().getName() + "[hgap = " + this.hgap + ", vgap = " + this.vgap + ", rows = " + this.rows + ", cols = " + this.cols + "]";
    }
}

