/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import com.acunia.wonka.rudolph.DropTargetEvent;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ComponentPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Locale;
import java.util.Vector;

public abstract class Component
implements ImageObserver,
MenuContainer,
Serializable {
    private static final Object lock = new Object();
    private static int counter;
    public static final Font DEFAULT_FONT;
    public static final float BOTTOM_ALIGNMENT = 1.0f;
    public static final float CENTER_ALIGNMENT = 0.5f;
    public static final float LEFT_ALIGNMENT = 0.0f;
    public static final float RIGHT_ALIGNMENT = 1.0f;
    public static final float TOP_ALIGNMENT = 0.0f;
    int x;
    int y;
    int height;
    int width;
    Dimension prefSize;
    Dimension minSize;
    Dimension maximumSize;
    boolean isPacked;
    String name = "Component" + ++counter;
    boolean nameExplicitlySet;
    boolean visible = true;
    boolean valid = false;
    transient boolean validate = false;
    boolean enabled = true;
    protected transient boolean notified = false;
    Locale locale;
    transient Container parent = null;
    Color background;
    Color foreground;
    transient Cursor cursor;
    transient ComponentListener componentListener;
    transient MouseMotionListener mouseMotionListener;
    transient MouseListener mouseListener;
    transient FocusListener focusListener;
    transient ActionListener actionListener;
    transient KeyListener keyListener;
    boolean newEventsOnly;
    transient boolean eventsEnabled = true;
    Font font;
    Font peerFont;
    public transient ComponentPeer peer;
    Vector popups;
    private static transient Component focusComponent;
    private static transient Component focusComponentPrev;
    boolean hasFocus;
    private DropTarget dropTarget;

    public static void revertFocus() {
        focusComponent = focusComponentPrev;
        if (focusComponent != null) {
            focusComponent.dispatchEvent(new FocusEvent(focusComponent, 1004));
        }
    }

    public static Component getFocusComponent() {
        return focusComponent;
    }

    protected Component() {
        this.addNotify();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name != null ? this.name : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setForeground(Color color) {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.foreground = color;
            this.peer.setForeground(color);
        }
    }

    public Color getForeground() {
        if (this.foreground != null) {
            return this.foreground;
        }
        return this.parent != null ? this.parent.getForeground() : null;
    }

    public void setBackground(Color color) {
        this.background = color;
        this.peer.setBackground(color);
    }

    public Color getBackground() {
        if (this.background != null) {
            return this.background;
        }
        return this.parent != null ? this.parent.getBackground() : null;
    }

    public ColorModel getColorModel() {
        return this.peer.getColorModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setFont(Font font) {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.font = font;
            this.valid = false;
            this.peer.setFont(font);
        }
    }

    public Font getFont() {
        if (this.font != null) {
            return this.font;
        }
        if (this.parent != null) {
            return this.parent.getFont();
        }
        return DEFAULT_FONT;
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.peer.getFontMetrics(font == null ? DEFAULT_FONT : font);
    }

    public synchronized void setCursor(Cursor cursor) {
        this.cursor = cursor;
        this.peer.setCursor(cursor);
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBounds(int x, int y, int width, int height) {
        Object object = this.getTreeLock();
        synchronized (object) {
            boolean s;
            boolean l = this.x != x || this.y != y;
            boolean bl = s = this.width != width || this.height != height;
            if (l || s) {
                this.x = x;
                this.y = y;
                this.width = width;
                this.height = height;
                this.invalidate();
                if (this.componentListener != null) {
                    if (s) {
                        this.dispatchEvent(new ComponentEvent(this, 101));
                    }
                    if (l) {
                        this.dispatchEvent(new ComponentEvent(this, 100));
                    }
                }
                this.peer.setBounds(x, y, width, height);
            }
        }
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void setSize(int w, int h) {
        this.setBounds(this.x, this.y, w, h);
    }

    public void setSize(Dimension dimension) {
        this.setBounds(this.x, this.y, dimension.width, dimension.height);
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension size() {
        return new Dimension(this.width, this.height);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public ComponentPeer getPeer() {
        return this.peer;
    }

    public boolean contains(int x, int y) {
        return x < this.width && y < this.height;
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    public Dimension getMaximumSize() {
        return this.maximumSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.minSize == null || !this.valid) {
                this.minSize = this.peer.getMinimumSize();
            }
            return this.minSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.prefSize == null || !this.valid) {
                this.prefSize = this.peer.getPreferredSize();
            }
            return this.prefSize;
        }
    }

    public Dimension maximumSize() {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public void setLocation(int x, int y) {
        this.setBounds(x, y, this.width, this.height);
    }

    public void setLocation(Point point) {
        this.setBounds(point.x, point.y, this.width, this.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getLocation() {
        Object object = this.getTreeLock();
        synchronized (object) {
            return new Point(this.x, this.y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getLocationOnScreen() {
        Object object = this.getTreeLock();
        synchronized (object) {
            return this.peer.getLocationOnScreen();
        }
    }

    public Component getComponentAt(int x, int y) {
        return this.contains(x, y) ? this : null;
    }

    public Component getComponentAt(Point point) {
        return this.contains(point.x, point.y) ? this : null;
    }

    public void list(PrintStream out, int indent) {
    }

    public void list(PrintWriter out, int indent) {
    }

    public void list() {
        this.list(System.out, 0);
    }

    public void list(PrintStream out) {
        this.list(out, 0);
    }

    public void list(PrintWriter out) {
        this.list(out, 0);
    }

    public Container getParent() {
        return this.parent;
    }

    public void doLayout() {
    }

    public float getAlignmentX() {
        return 0.5f;
    }

    public float getAlignmentY() {
        return 0.5f;
    }

    public void addNotify() {
        if (!this.notified) {
            this.notified = true;
        }
        if (this.peer == null) {
            this.peer = this.getToolkit().createComponent(this);
        }
    }

    public void removeNotify() {
    }

    public synchronized void add(PopupMenu popup) {
    }

    public synchronized void remove(MenuComponent popup) {
    }

    public final Object getTreeLock() {
        return lock;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() throws IllegalComponentStateException {
        if (this.locale != null) {
            return this.locale;
        }
        if (this.parent != null) {
            return this.parent.getLocale();
        }
        throw new IllegalComponentStateException("no locale set for this component or its parents");
    }

    public void requestFocus() {
        if (focusComponent != this) {
            focusComponentPrev = focusComponent;
            focusComponent = this;
            if (focusComponentPrev != null) {
                this.dispatchEvent(new FocusEvent(focusComponentPrev, 1005));
            }
            this.dispatchEvent(new FocusEvent(focusComponent, 1004));
        }
    }

    public void transferFocus() {
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void validate() {
        this.valid = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.valid) {
                this.minSize = null;
                this.prefSize = null;
                this.valid = false;
                if (this.parent != null && this.parent.valid) {
                    this.parent.invalidate();
                }
            }
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setEnabled(boolean condition) {
        this.enabled = condition;
        this.peer.setEnabled(condition);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void addComponentListener(ComponentListener listener) {
        this.componentListener = AWTEventMulticaster.add(this.componentListener, listener);
    }

    public synchronized void removeComponentListener(ComponentListener listener) {
        this.componentListener = AWTEventMulticaster.remove(this.componentListener, listener);
    }

    public synchronized void addFocusListener(FocusListener listener) {
        this.focusListener = AWTEventMulticaster.add(this.focusListener, listener);
    }

    public synchronized void removeFocusListener(FocusListener listener) {
        this.focusListener = AWTEventMulticaster.remove(this.focusListener, listener);
    }

    public synchronized void addKeyListener(KeyListener listener) {
        this.keyListener = AWTEventMulticaster.add(this.keyListener, listener);
    }

    public synchronized void removeKeyListener(KeyListener listener) {
        this.keyListener = AWTEventMulticaster.remove(this.keyListener, listener);
    }

    public synchronized void addMouseListener(MouseListener listener) {
        this.mouseListener = AWTEventMulticaster.add(this.mouseListener, listener);
    }

    public synchronized void removeMouseListener(MouseListener listener) {
        this.mouseListener = AWTEventMulticaster.remove(this.mouseListener, listener);
    }

    public synchronized void addMouseMotionListener(MouseMotionListener listener) {
        this.mouseMotionListener = AWTEventMulticaster.add(this.mouseMotionListener, listener);
    }

    public synchronized void removeMouseMotionListener(MouseMotionListener listener) {
        this.mouseMotionListener = AWTEventMulticaster.remove(this.mouseMotionListener, listener);
    }

    protected final void enableEvents(long eventTypes) {
    }

    protected final void disableEvents(long eventTypes) {
    }

    protected void dispatchEventImpl(AWTEvent event) {
        if (!this.enabled && event instanceof InputEvent) {
            return;
        }
        this.peer.handleEvent(event);
        if (this.dropTarget != null && event instanceof MouseEvent) {
            DropTargetEvent.setDropTargetContext(this.dropTarget.getDropTargetContext());
            DropTargetEvent.getDropTargetEvent().dispatch((MouseEvent)event);
        }
        if (this.dropTarget == null && event instanceof MouseEvent && event.getID() == 510) {
            DropTargetEvent.setInProgress(false, null);
        } else {
            this.processEvent(event);
        }
    }

    public final void dispatchEvent(AWTEvent event) {
        this.dispatchEventImpl(event);
    }

    protected void processEvent(AWTEvent event) {
        if (event instanceof MouseEvent) {
            switch (event.getID()) {
                case 500: 
                case 501: 
                case 502: 
                case 504: 
                case 505: {
                    this.processMouseEvent((MouseEvent)event);
                    break;
                }
                case 503: 
                case 506: {
                    this.processMouseMotionEvent((MouseEvent)event);
                }
            }
        } else if (event instanceof KeyEvent) {
            this.processKeyEvent((KeyEvent)event);
        } else if (event instanceof FocusEvent) {
            this.processFocusEvent((FocusEvent)event);
        } else if (event instanceof ItemEvent) {
            this.processEvent(event);
        } else if (event instanceof ComponentEvent) {
            this.processComponentEvent((ComponentEvent)event);
        }
    }

    protected void processComponentEvent(ComponentEvent event) {
        if (this.componentListener != null) {
            switch (event.getID()) {
                case 101: {
                    this.componentListener.componentResized(event);
                    break;
                }
                case 100: {
                    this.componentListener.componentMoved(event);
                    break;
                }
                case 102: {
                    this.componentListener.componentShown(event);
                    break;
                }
                case 103: {
                    this.componentListener.componentHidden(event);
                }
            }
        }
    }

    protected void processFocusEvent(FocusEvent event) {
        if (this.focusListener != null) {
            switch (event.getID()) {
                case 1004: {
                    this.focusListener.focusGained(event);
                    break;
                }
                case 1005: {
                    this.focusListener.focusLost(event);
                }
            }
        }
    }

    protected void processKeyEvent(KeyEvent event) {
        if (this.keyListener != null) {
            switch (event.getID()) {
                case 400: {
                    this.keyListener.keyTyped(event);
                    break;
                }
                case 401: {
                    this.keyListener.keyPressed(event);
                    break;
                }
                case 402: {
                    this.keyListener.keyReleased(event);
                }
            }
        }
    }

    protected void processMouseEvent(MouseEvent event) {
        if (this.mouseListener != null) {
            switch (event.getID()) {
                case 505: {
                    this.mouseListener.mouseExited(event);
                    break;
                }
                case 504: {
                    this.mouseListener.mouseEntered(event);
                    break;
                }
                case 501: {
                    this.mouseListener.mousePressed(event);
                    break;
                }
                case 502: {
                    this.mouseListener.mouseReleased(event);
                    break;
                }
                case 500: {
                    this.mouseListener.mouseClicked(event);
                }
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent event) {
        if (this.mouseMotionListener != null) {
            switch (event.getID()) {
                case 503: {
                    this.mouseMotionListener.mouseMoved(event);
                    break;
                }
                case 506: {
                    this.mouseMotionListener.mouseDragged(event);
                }
            }
        }
    }

    public void print(Graphics context) {
        throw new RuntimeException("Not implemented");
    }

    public void printAll(Graphics context) {
        throw new RuntimeException("Not implemented");
    }

    public String toString() {
        String display = this.name == null ? this.getClass().getName() : this.name;
        return display + " - bounds: x = " + this.x + ", y = " + this.y + ", w = " + this.width + ", h = " + this.height;
    }

    protected String paramString() {
        return this.getClass().getName() + "<" + this.name + "> - bounds(" + this.x + ", " + this.y + ", " + this.width + ", " + this.height + ")";
    }

    public boolean isVisible() {
        return this.visible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisible(boolean condition) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (condition) {
                if (!this.visible) {
                    this.visible = true;
                    this.invalidate();
                    this.peer.setVisible(condition);
                    this.validate();
                    if (this.componentListener != null) {
                        this.dispatchEvent(new ComponentEvent(this, 102));
                    }
                }
            } else if (this.visible) {
                this.visible = false;
                this.peer.setVisible(condition);
                this.invalidate();
                if (this.componentListener != null) {
                    this.dispatchEvent(new ComponentEvent(this, 103));
                }
            }
        }
    }

    public void show() {
        this.setVisible(true);
    }

    public void hide() {
        this.setVisible(false);
    }

    public boolean isDisplayable() {
        return this.peer != null;
    }

    public boolean isShowing() {
        return this.isVisible();
    }

    public Graphics getGraphics() {
        return this.peer.getGraphics();
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    public Image createImage(int w, int h) {
        return this.peer.createImage(w, h);
    }

    public Image createImage(ImageProducer producer) {
        return this.peer.createImage(producer);
    }

    public boolean prepareImage(Image image, ImageObserver observer) {
        return this.prepareImage(image, -1, -1, observer);
    }

    public boolean prepareImage(Image image, int w, int h, ImageObserver observer) {
        return this.peer.prepareImage(image, w, h, observer);
    }

    public int checkImage(Image image, ImageObserver observer) {
        return this.checkImage(image, -1, -1, observer);
    }

    public int checkImage(Image image, int w, int h, ImageObserver observer) {
        return this.peer.checkImage(image, w, h, observer);
    }

    public boolean imageUpdate(Image image, int flags, int x, int y, int w, int h) {
        if ((flags & 0x10) != 0) {
            this.repaint();
        }
        return (flags & 0x20) == 0;
    }

    public void repaint() {
        this.peer.repaint(0L, 0, 0, this.width, this.height);
    }

    public void repaint(long ms) {
        this.peer.repaint(ms, 0, 0, this.width, this.height);
    }

    public void repaint(int x, int y, int w, int h) {
        this.peer.repaint(0L, x, y, w, h);
    }

    public void repaint(long ms, int x, int y, int w, int h) {
        this.peer.repaint(ms, x, y, w, h);
    }

    public void paint(Graphics context) {
    }

    public void update(Graphics g) {
        g.clearRect(0, 0, this.width, this.height);
        this.paint(g);
    }

    public void paintAll(Graphics context) {
        this.validate();
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        System.out.println("Not yet implemented");
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        System.out.println("Not yet implemented");
    }

    public boolean action(Event evt, Object arg) {
        System.out.println("Not implemented - Deprecated");
        return false;
    }

    public Rectangle bounds() {
        return this.getBounds();
    }

    public void deliverEvent(Event e) {
        System.out.println("Not implemented - Deprecated");
    }

    public void disable() {
        this.enabled = false;
        this.peer.setEnabled(false);
    }

    public void enable() {
        this.enabled = true;
        this.peer.setEnabled(true);
    }

    public void enable(boolean cond) {
        this.setEnabled(cond);
    }

    public boolean gotFocus(Event evt, Object arg) {
        System.out.println("Not implemented - Deprecated");
        return false;
    }

    public boolean handleEvent(Event evt) {
        System.out.println("Not implemented - Deprecated");
        return false;
    }

    public boolean inside(int x, int y) {
        return this.contains(x, y);
    }

    public boolean keyDown(Event evt, int key) {
        System.out.println("Not implemented - Deprecated");
        return false;
    }

    public boolean keyUp(Event evt, int key) {
        System.out.println("Not implemented - Deprecated");
        return false;
    }

    public void layout() {
        System.out.println("Not implemented - Deprecated");
    }

    public Component locate(int x, int y) {
        return this.getComponentAt(x, y);
    }

    public Point location() {
        return this.getLocation();
    }

    public boolean lostFocus(Event evt, Object arg) {
        System.out.println("Not implemented - Deprecated");
        return false;
    }

    public boolean mouseDown(Event evt, int x, int y) {
        System.out.println("Not implemented - Deprecated");
        return false;
    }

    public boolean mouseDrag(Event evt, int x, int y) {
        System.out.println("Not implemented - Deprecated");
        return false;
    }

    public boolean mouseEnter(Event evt, int x, int y) {
        System.out.println("Not implemented - Deprecated");
        return false;
    }

    public boolean mouseExit(Event evt, int x, int y) {
        System.out.println("Not implemented - Deprecated");
        return false;
    }

    public boolean mouseMove(Event evt, int x, int y) {
        System.out.println("Not implemented - Deprecated");
        return false;
    }

    public boolean mouseUp(Event evt, int x, int y) {
        System.out.println("Not implemented - Deprecated");
        return false;
    }

    public void move(int x, int y) {
        this.setLocation(x, y);
    }

    public void nextFocus() {
        this.transferFocus();
    }

    public void reshape(int x, int y, int w, int h) {
        this.setBounds(x, y, w, h);
    }

    public void resize(int w, int h) {
        this.setSize(w, h);
    }

    public void resize(Dimension d) {
        this.setSize(d);
    }

    public void show(boolean cond) {
        this.setVisible(cond);
    }

    public void setDropTarget(DropTarget dt) {
        this.dropTarget = dt;
    }

    public DropTarget getDropTarget() {
        return this.dropTarget;
    }

    static {
        DEFAULT_FONT = new Font("helvP08", 0, 8);
        focusComponent = null;
        focusComponentPrev = null;
    }
}

