/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.security;

import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class BasicPermissionCollection
extends PermissionCollection {
    static final int INITIAL_TABSIZE = 11;
    private Hashtable prefixes = new Hashtable(11);

    public synchronized void add(Permission permission) throws SecurityException {
        BasicPermission newperm;
        if (super.isReadOnly()) {
            throw new SecurityException("read-only");
        }
        try {
            newperm = (BasicPermission)permission;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("not a BasicPermission");
        }
        Hashtable table = this.prefixes;
        String name = newperm.getName();
        String longest_prefix = "";
        String target_matched = "";
        int namelen = name.length();
        int longest_prefix_length = 0;
        boolean wild = false;
        if (namelen > 1 && name.charAt(namelen - 1) == '*') {
            wild = true;
            name = name.substring(0, --namelen);
        }
        while (namelen > 0) {
            Enumeration e = table.keys();
            boolean found = false;
            while (e.hasMoreElements()) {
                String prefix = name;
                int prefixlen = namelen;
                String target = (String)e.nextElement();
                while (prefixlen > longest_prefix_length) {
                    if (target.startsWith(prefix)) {
                        longest_prefix = prefix;
                        target_matched = target;
                        longest_prefix_length = prefixlen;
                        found = true;
                    }
                    prefix = prefix.substring(0, --prefixlen);
                }
            }
            if (longest_prefix_length == 0) {
                if (wild) {
                    Hashtable new_table = new Hashtable(11);
                    table.put(name, new_table);
                    table = new_table;
                } else {
                    table.put(name, newperm);
                }
                name = "";
                namelen = 0;
            } else {
                Object old_data = table.get(target_matched);
                if (longest_prefix_length < target_matched.length() || old_data instanceof Permission) {
                    Hashtable new_table = new Hashtable(11);
                    new_table.put(target_matched.substring(longest_prefix_length), old_data);
                    table.remove(target_matched);
                    table.put(longest_prefix, new_table);
                    table = new_table;
                } else {
                    table = (Hashtable)old_data;
                }
                name = name.substring(longest_prefix_length);
                namelen = name.length();
                longest_prefix = "";
                longest_prefix_length = 0;
            }
            if (!wild || namelen != 0) continue;
            name = "*";
            namelen = 1;
            wild = false;
        }
    }

    public boolean implies(Permission permission) {
        BasicPermission tryperm;
        try {
            tryperm = (BasicPermission)permission;
        }
        catch (ClassCastException e) {
            return false;
        }
        Hashtable table = this.prefixes;
        String name = tryperm.getName();
        int namelen = name.length();
        while (namelen >= 0) {
            Object data = table.get(name);
            if (data instanceof Permission) {
                return true;
            }
            data = table.get(new String("*"));
            if (data != null) {
                return true;
            }
            Enumeration e = table.keys();
            boolean found = false;
            while (e.hasMoreElements()) {
                String prefix = name;
                int prefixlen = namelen;
                String target = (String)e.nextElement();
                if (!name.startsWith(target) || !((data = table.get(target)) instanceof Hashtable)) continue;
                table = (Hashtable)data;
                name = name.substring(target.length());
                namelen = name.length();
                found = true;
                break;
            }
            if (!found) break;
        }
        return false;
    }

    private final Enumeration enumerate_subtree(Hashtable h) {
        Vector temp = new Vector();
        Enumeration e = h.elements();
        while (e.hasMoreElements()) {
            Object data = e.nextElement();
            if (data instanceof Hashtable) {
                Hashtable hh = (Hashtable)data;
                Enumeration ee = this.enumerate_subtree(hh);
                while (ee.hasMoreElements()) {
                    temp.addElement(ee.nextElement());
                }
                continue;
            }
            temp.addElement(data);
        }
        return temp.elements();
    }

    public synchronized Enumeration elements() {
        return this.enumerate_subtree(this.prefixes);
    }
}

