/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rudolph.taskbar.applets;

import com.acunia.wonka.rudolph.keyboard.Keyboard;
import com.acunia.wonka.rudolph.taskbar.TaskBar;
import com.acunia.wonka.rudolph.taskbar.TaskBarApplet;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.List;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class KeyboardApplet
extends TaskBarApplet
implements MouseListener {
    static int fontSize = 12;
    private Image kbdIcon_e = this.loadImage("applet.keyboard.icon.open");
    private Image kbdIcon_d = this.loadImage("applet.keyboard.icon.close");
    private Image kbdSelect_e = this.loadImage("applet.keyboard.select.open");
    private Image kbdSelect_d = this.loadImage("applet.keyboard.select.close");
    private boolean showKbd = false;
    private boolean showSelection = false;
    private boolean selection = true;
    private Window kbdWindow;
    private KeyboardSelect selectMenu;
    private Vector keyboardItems = new Vector();
    private KeyboardItem keyboard;
    private Font kbdFont;
    private int iconWidth = 20;
    private int iconHeight = 15;
    private int selectWidth = 10;

    private Image loadImage(String property) {
        URL url;
        Image result = null;
        String imgname = this.taskbar.getProperties().getProperty(property, null);
        if (imgname != null && (url = ClassLoader.getSystemResource(imgname)) != null) {
            result = Toolkit.getDefaultToolkit().getImage(url);
        }
        return result;
    }

    public KeyboardApplet(TaskBar taskbar) {
        super(taskbar);
        StringTokenizer st = new StringTokenizer(taskbar.getProperties().getProperty("applet.keyboard.layouts", "Default"));
        while (st.hasMoreTokens()) {
            this.keyboardItems.add(new KeyboardItem(st.nextToken()));
        }
        this.keyboard = new KeyboardItem(taskbar.getProperties().getProperty("applet.keyboard.defaultlayout", "Default"));
        this.selection = Boolean.valueOf(taskbar.getProperties().getProperty("applet.keyboard.selectable", "false"));
        Properties props = taskbar.getProperties();
        String prop = props.getProperty("applet.keyboard.icon.width");
        if (prop != null) {
            this.iconWidth = Integer.parseInt(prop);
        }
        if ((prop = props.getProperty("applet.keyboard.icon.height")) != null) {
            this.iconHeight = Integer.parseInt(prop);
        }
        if ((prop = props.getProperty("applet.keyboard.select.width")) != null) {
            this.selectWidth = Integer.parseInt(prop);
        }
        if ((prop = props.getProperty("applet.keyboard.select.fontSize")) != null) {
            fontSize = Integer.parseInt(prop);
        }
        this.kbdFont = new Font(taskbar.getProperties().getProperty("applet.keyboard.font", "Helvetica"), 0, Integer.parseInt(taskbar.getProperties().getProperty("applet.keyboard.fontsize", "8")));
        this.addMouseListener(this);
    }

    public void paint(Graphics g) {
        if (this.selection) {
            if (this.showSelection) {
                g.drawImage(this.kbdSelect_e, this.iconWidth, 0, null);
            } else {
                g.drawImage(this.kbdSelect_d, this.iconWidth, 0, null);
            }
        }
        if (this.showKbd) {
            g.drawImage(this.kbdIcon_e, 0, 0, null);
        } else {
            g.drawImage(this.kbdIcon_d, 0, 0, null);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.selection ? this.iconWidth + this.selectWidth : this.iconWidth, this.iconHeight);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    private void buildKeyboard() {
        try {
            Class cl = Class.forName("com.acunia.wonka.rudolph.keyboard.Keyboard" + this.keyboard.name);
            Constructor con = cl.getConstructor(new Class[0]);
            this.keyboard.keyboard = (Keyboard)con.newInstance(new Object[0]);
            this.kbdWindow = new Window(this.taskbar);
            this.kbdWindow.setFont(this.kbdFont);
            this.kbdWindow.add(this.keyboard.keyboard);
            this.kbdWindow.addMouseListener(this);
            this.keyboard.keyboard.addMouseListener(this);
            int top = 0;
            int bottom = Toolkit.getDefaultToolkit().getScreenSize().height;
            String loc = this.taskbar.getProperties().getProperty("applet.keyboard.location", "bottom");
            if (loc.equals("top")) {
                this.kbdWindow.setBounds(0, top, this.keyboard.keyboard.getPreferredSize().width, this.keyboard.keyboard.getPreferredSize().height);
            } else if (loc.equals("bottom")) {
                this.kbdWindow.setBounds(0, bottom - this.keyboard.keyboard.getPreferredSize().height, this.keyboard.keyboard.getPreferredSize().width, this.keyboard.keyboard.getPreferredSize().height);
            } else if (loc.equals("taskbar")) {
                this.kbdWindow.setBounds(0, 0, this.keyboard.keyboard.getPreferredSize().width, this.keyboard.keyboard.getPreferredSize().height);
            } else if (loc.equals("custom")) {
                int x = Integer.parseInt(this.taskbar.getProperties().getProperty("applet.keyboard.x", "0"));
                int y = Integer.parseInt(this.taskbar.getProperties().getProperty("applet.keyboard.y", "0"));
                int w = Integer.parseInt(this.taskbar.getProperties().getProperty("applet.keyboard.width", "240"));
                int h = Integer.parseInt(this.taskbar.getProperties().getProperty("applet.keyboard.height", "81"));
                this.kbdWindow.setBounds(x, y, w, h);
            }
        }
        catch (Exception e) {
            System.err.println("-- Could not load keyboard layout: " + this.keyboard.name + " -->");
            e.printStackTrace();
            System.err.println("<--");
        }
    }

    public void mouseClicked(MouseEvent event) {
        if (event.getSource() == this) {
            if (event.getX() <= this.iconWidth) {
                if (this.showKbd) {
                    this.showKbd = false;
                    this.kbdWindow.setVisible(false);
                    this.keyboard.keyboard.close();
                } else {
                    if (this.kbdWindow == null) {
                        this.buildKeyboard();
                    }
                    this.showKbd = true;
                    this.keyboard.keyboard.open();
                    this.kbdWindow.setVisible(true);
                }
            } else if (this.showSelection) {
                this.showSelection = false;
                this.selectMenu.setVisible(false);
            } else {
                if (this.selectMenu == null) {
                    this.selectMenu = new KeyboardSelect(this.taskbar);
                    int x = this.getLocationOnScreen().x + this.kbdIcon_e.getWidth(null);
                    int y = this.getLocationOnScreen().y + this.kbdIcon_e.getHeight(null);
                    Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
                    if (x + this.selectMenu.getSize().width > size.width) {
                        x = size.width - this.selectMenu.getSize().width;
                    }
                    if (y + this.selectMenu.getSize().height > size.height) {
                        y -= this.selectMenu.getSize().height + this.kbdIcon_e.getHeight(null);
                    }
                    this.selectMenu.setLocation(x, y);
                }
                this.showSelection = true;
                this.selectMenu.setVisible(true);
                this.selectMenu.toFront();
            }
            this.repaint();
        }
        if (this.kbdWindow != null && this.showKbd) {
            this.kbdWindow.setVisible(true);
        }
        if (this.selectMenu != null && this.showSelection) {
            this.selectMenu.setVisible(true);
        }
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        if (this.kbdWindow != null && this.showKbd) {
            this.kbdWindow.setVisible(true);
        }
        if (this.selectMenu != null && this.showSelection) {
            this.selectMenu.setVisible(true);
        }
    }

    public void mouseReleased(MouseEvent event) {
        if (this.kbdWindow != null && this.showKbd) {
            this.kbdWindow.setVisible(true);
        }
        if (this.selectMenu != null && this.showSelection) {
            this.selectMenu.setVisible(true);
        }
    }

    private class KeyboardSelect
    extends Window
    implements ItemListener {
        private List layoutList;

        public KeyboardSelect(Frame f) {
            super(f);
            this.layoutList = new List(KeyboardApplet.this.keyboardItems.size());
            this.layoutList.setFont(new Font("Helvetica", 0, fontSize));
            for (int i = 0; i < KeyboardApplet.this.keyboardItems.size(); ++i) {
                this.layoutList.add(((KeyboardItem)((KeyboardApplet)KeyboardApplet.this).keyboardItems.elementAt((int)i)).name);
            }
            this.layoutList.addItemListener(this);
            this.add(this.layoutList);
            this.pack();
        }

        public void itemStateChanged(ItemEvent e) {
            String item = (String)e.getItem();
            KeyboardApplet.this.showSelection = false;
            KeyboardApplet.this.selectMenu.setVisible(false);
            for (int i = 0; i < KeyboardApplet.this.keyboardItems.size(); ++i) {
                KeyboardItem keybItem = (KeyboardItem)KeyboardApplet.this.keyboardItems.elementAt(i);
                if (!item.equals(keybItem.name)) continue;
                KeyboardApplet.this.keyboard = keybItem;
                this.layoutList.select(i);
                if (KeyboardApplet.this.showKbd) {
                    KeyboardApplet.this.kbdWindow.setVisible(false);
                    KeyboardApplet.this.buildKeyboard();
                    KeyboardApplet.this.kbdWindow.setVisible(true);
                    continue;
                }
                KeyboardApplet.this.buildKeyboard();
            }
            KeyboardApplet.this.repaint();
        }
    }

    private class KeyboardItem {
        public String name;
        public Keyboard keyboard;

        public KeyboardItem(String name) {
            this.name = name;
        }
    }
}

