/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rudolph.peers;

import com.acunia.wonka.rudolph.peers.RudolphTextAreaPeer;
import com.acunia.wonka.rudolph.peers.TextAreaPainter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class TextAreaPainter_WrappingFixFont
extends TextAreaPainter {
    protected int painterCharWidth;

    public int getMaxAdvance() {
        return 1;
    }

    public void setSize(Dimension newsize) {
        this.viewport.width = RudolphTextAreaPeer.getInnerwidth(newsize.width) / this.painterCharWidth;
        this.viewport.height = RudolphTextAreaPeer.getLines(newsize.height, this.painterMetrics);
        this.calculateVisibleLineparts();
    }

    public void setImage(String text) {
        this.textBuffer = new char[text.length()];
        text.getChars(0, this.textBuffer.length, this.textBuffer, 0);
        if (this.viewport.width > 0) {
            this.calculateVisibleLineparts();
        } else {
            this.textlineEnd = new int[0];
        }
    }

    protected void calculateVisibleLineparts() {
        if (this.textBuffer.length <= 0 || this.viewport.width <= 0) {
            this.textlineEnd = new int[0];
            this.viewTextOffset = new int[0];
            this.viewTextLength = new int[0];
            return;
        }
        int words = 1;
        int i = 0;
        while (i < this.textBuffer.length) {
            if (this.textBuffer[i] == ' ' || this.textBuffer[i] == '\n' || this.textBuffer[i] == '.' || this.textBuffer[i] == ',' || this.textBuffer[i] == '?' || this.textBuffer[i] == ':' || this.textBuffer[i] == ';') {
                ++words;
            }
            ++i;
        }
        int[] wordstart = new int[words];
        int[] wordstop = new int[words];
        boolean[] newline = new boolean[words];
        int line = 0;
        wordstart[0] = 0;
        newline[0] = true;
        i = 1;
        while (i < this.textBuffer.length - 1) {
            if (this.textBuffer[i] == '\n' || this.textBuffer[i] == ' ' || this.textBuffer[i] == '.' || this.textBuffer[i] == ',' || this.textBuffer[i] == '?' || this.textBuffer[i] == ':' || this.textBuffer[i] == ';') {
                wordstop[line] = this.textBuffer[i] == '\n' || this.textBuffer[i] == ' ' ? i : i + 1;
                wordstart[++line] = i + 1;
                boolean bl = false;
                if (this.textBuffer[i] == '\n') {
                    bl = true;
                }
                newline[line] = bl;
            }
            ++i;
        }
        wordstop[line] = this.textBuffer.length;
        int last = words - 1;
        i = 0;
        while (i < last) {
            if (wordstop[i] - wordstart[i] >= this.viewport.width) {
                newline[i] = true;
                wordstop[i] = wordstart[i] + this.viewport.width;
                newline[i + 1] = true;
            }
            ++i;
        }
        if (wordstop[last] - wordstart[last] >= this.viewport.width) {
            newline[last] = true;
            wordstop[last] = wordstart[last] + this.viewport.width;
        }
        line = 1;
        int linestop = this.viewport.width;
        i = 1;
        while (i < words) {
            if (newline[i] || wordstop[i] >= linestop) {
                newline[i] = true;
                linestop = wordstart[i] + this.viewport.width;
                ++line;
            }
            ++i;
        }
        this.textlineEnd = new int[line];
        this.viewTextOffset = new int[line];
        this.viewTextLength = new int[line];
        line = 0;
        this.viewTextOffset[0] = wordstart[0];
        i = 1;
        while (i < words) {
            if (newline[i]) {
                this.textlineEnd[line] = wordstop[i - 1];
                this.viewTextLength[line] = wordstop[i - 1] - this.viewTextOffset[line];
                this.viewTextOffset[++line] = wordstart[i];
            }
            ++i;
        }
        this.textlineEnd[line] = this.textBuffer[this.textBuffer.length - 1] == '\n' ? this.textBuffer.length - 1 : this.textBuffer.length;
        this.viewTextLength[line] = this.textlineEnd[line] - this.viewTextOffset[line];
    }

    public void setScreenPosition(int x, int y, int[] pointdata) {
        if (this.viewport.width <= 0 || this.viewport.height <= 0 || this.textlineEnd.length <= 0) {
            return;
        }
        pointdata[1] = RudolphTextAreaPeer.getLine(y, this.painterMetrics) + this.lineOffset;
        if (pointdata[1] >= this.textlineEnd.length) {
            pointdata[1] = this.textlineEnd.length - 1;
        }
        pointdata[2] = RudolphTextAreaPeer.getTextPos(x) / this.painterCharWidth;
        if (pointdata[2] > this.viewTextLength[pointdata[1]]) {
            pointdata[2] = this.viewTextLength[pointdata[1]];
        }
        pointdata[3] = this.viewTextOffset[pointdata[1]] + pointdata[2];
        pointdata[0] = pointdata[3];
    }

    public void setScreenPosition(int pos, int[] pointdata) {
        if (this.viewport.width <= 0 || this.viewport.height <= 0 || this.textlineEnd.length <= 0) {
            return;
        }
        if (pos < 0) {
            pointdata[0] = 0;
            pointdata[1] = 0;
            pointdata[2] = 0;
            pointdata[3] = 0;
        } else if (pos >= this.textBuffer.length) {
            pointdata[0] = this.textBuffer.length;
            pointdata[1] = this.textlineEnd.length - 1;
            pointdata[2] = this.viewTextLength[pointdata[1]];
            pointdata[3] = this.textBuffer.length;
        } else {
            pointdata[0] = pos;
            pointdata[1] = 0;
            while (pos > this.textlineEnd[pointdata[1]]) {
                pointdata[1] = pointdata[1] + 1;
            }
            pointdata[2] = pos - this.viewTextOffset[pointdata[1]];
            pointdata[3] = pos;
        }
    }

    public void setScreenPositionLine(int line, int offset, int[] pointdata) {
        if (line < 0) {
            pointdata[0] = 0;
            pointdata[1] = 0;
            pointdata[2] = 0;
            pointdata[3] = 0;
        } else if (line >= this.textlineEnd.length) {
            pointdata[0] = this.textBuffer.length;
            pointdata[1] = this.textlineEnd.length - 1;
            pointdata[2] = this.viewTextLength[pointdata[1]];
            pointdata[3] = this.textBuffer.length;
        } else if (offset < 0) {
            pointdata[0] = this.textlineEnd[line];
            pointdata[1] = line;
            pointdata[2] = this.viewTextLength[line];
            pointdata[3] = this.textlineEnd[line];
        } else {
            pointdata[1] = line;
            if (offset > this.viewTextLength[line]) {
                pointdata[2] = this.viewTextLength[line];
                pointdata[0] = this.textlineEnd[line];
            } else {
                pointdata[0] = line > 0 ? this.textlineEnd[line - 1] + offset + 1 : offset;
                pointdata[2] = offset;
            }
            pointdata[3] = pointdata[0];
        }
    }

    public void paint(int width, int height, int cursorline, int cursoroffset, int cursorscreenpos, Graphics g) {
        RudolphTextAreaPeer.paintTextArea(0, 0, width, height, this.textBuffer, this.viewTextOffset, this.viewTextLength, this.lineOffset, cursorline, cursorscreenpos * this.painterCharWidth, this.painterFont, this.painterMetrics, this.textColors, g, this.drawCursor);
    }

    public void paint(int width, int height, int startline, int startbufferoffset, int starthorizontaloffset, int stopline, int stopbufferoffset, int stophorizontaloffset, Graphics g) {
        RudolphTextAreaPeer.paintTextArea(0, 0, width, height, this.textBuffer, this.viewTextOffset, this.viewTextLength, this.lineOffset, startline, startbufferoffset, starthorizontaloffset * this.painterCharWidth, stopline, stopbufferoffset, stophorizontaloffset * this.painterCharWidth, this.painterFont, this.painterMetrics, this.textColors, g, this.drawCursor);
    }

    public TextAreaPainter_WrappingFixFont(Font textfont, FontMetrics metrics, int fixedwidth, String text, Dimension size, Color[] colors) {
        super(metrics, size, colors);
        this.viewport.width /= fixedwidth;
        this.painterFont = textfont;
        this.painterMetrics = metrics;
        this.painterCharWidth = fixedwidth;
        this.setImage(text);
    }
}

