/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rudolph.peers;

import com.acunia.wonka.rudolph.peers.RudolphPeer;
import com.acunia.wonka.rudolph.peers.RudolphTextAreaPeer;
import com.acunia.wonka.rudolph.peers.TextAreaPainter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;

public class TextAreaPainter_ScrollingVarFont
extends TextAreaPainter {
    protected int maximumTextWidth;
    protected int textOffset = 0;

    public void setImage(String text) {
        super.setImage(text);
        this.calculateMaximumWidth();
    }

    public int getMaximumWidth() {
        return this.maximumTextWidth;
    }

    public void setTextOffset(int offset) {
        this.textOffset = offset;
        this.calculateVisibleLineparts();
    }

    public void setOffset(int offsetx, int offsety) {
        this.textOffset = offsetx;
        this.lineOffset = offsety;
        this.calculateVisibleLineparts();
    }

    public int getTextOffset() {
        return this.textOffset;
    }

    public Point getOffset() {
        return new Point(this.textOffset, this.lineOffset);
    }

    protected void calculateMaximumWidth() {
        int start = this.textlineEnd[0];
        this.maximumTextWidth = this.painterMetrics.charsWidth(this.textBuffer, 0, start);
        int i = 1;
        while (i < this.textlineEnd.length) {
            int currentwidth = this.painterMetrics.charsWidth(this.textBuffer, start, this.textlineEnd[i] - start);
            if (currentwidth > this.maximumTextWidth) {
                this.maximumTextWidth = currentwidth;
            }
            start = this.textlineEnd[i];
            ++i;
        }
    }

    protected void calculateVisibleLineparts() {
        if (this.textBuffer.length <= 0 || this.viewport.width <= 0) {
            return;
        }
        int start = 0;
        int i = 0;
        while (i < this.textlineEnd.length) {
            int n = this.viewTextOffset[i] = this.textOffset > 0 ? RudolphPeer.getChars(this.textOffset, start, this.textBuffer, this.painterMetrics) + 1 : start;
            if (this.viewTextOffset[i] >= this.textlineEnd[i]) {
                this.viewTextOffset[i] = this.textlineEnd[i];
                this.viewTextLength[i] = 0;
            } else {
                this.viewTextLength[i] = RudolphPeer.getChars(this.viewport.width, this.viewTextOffset[i], this.textBuffer, this.painterMetrics);
                if (this.viewTextLength[i] >= this.textlineEnd[i]) {
                    this.viewTextLength[i] = this.textlineEnd[i] - this.viewTextOffset[i];
                } else {
                    int n2 = i;
                    this.viewTextLength[n2] = this.viewTextLength[n2] - this.viewTextOffset[i];
                }
            }
            start = this.textlineEnd[i];
            ++i;
        }
    }

    public void setScreenPosition(int x, int y, int[] pointdata) {
        if (this.viewport.width <= 0 || this.viewport.height <= 0 || this.textlineEnd.length <= 0) {
            return;
        }
        pointdata[1] = RudolphTextAreaPeer.getLines(y, this.painterMetrics) + this.lineOffset;
        if (pointdata[1] >= this.textlineEnd.length) {
            pointdata[1] = this.textlineEnd.length - 1;
        }
        pointdata[3] = RudolphPeer.getChars(RudolphTextAreaPeer.getTextPos(x), this.viewTextOffset[pointdata[1]], this.textBuffer, this.painterMetrics);
        try {
            pointdata[2] = this.painterMetrics.charsWidth(this.textBuffer, this.viewTextOffset[pointdata[1]], pointdata[3] - this.viewTextOffset[pointdata[1]]) + this.textOffset;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            pointdata[2] = 0;
        }
        pointdata[0] = pointdata[3] + pointdata[1];
    }

    public void setScreenPosition(int pos, int[] pointdata) {
        if (this.viewport.width <= 0 || this.viewport.height <= 0 || this.textlineEnd.length <= 0) {
            return;
        }
        if (pos < 0) {
            pointdata[0] = 0;
            pointdata[1] = 0;
            pointdata[3] = 0;
            pointdata[2] = 0;
        } else if (this.textlineEnd.length <= 1 && pos >= this.textBuffer.length) {
            pointdata[0] = this.textBuffer.length;
            pointdata[1] = 0;
            pointdata[2] = this.painterMetrics.charsWidth(this.textBuffer, 0, this.textBuffer.length);
            pointdata[3] = this.textBuffer.length;
        } else if (pos >= this.textBuffer.length + this.textlineEnd.length - 1) {
            pointdata[0] = this.textBuffer.length + this.textlineEnd.length;
            pointdata[1] = this.textlineEnd.length - 1;
            pointdata[2] = this.painterMetrics.charsWidth(this.textBuffer, this.textlineEnd[pointdata[1] - 1], this.textBuffer.length - this.textlineEnd[pointdata[1] - 1]);
            pointdata[3] = this.textBuffer.length;
        } else {
            pointdata[0] = pos;
            pointdata[1] = 0;
            while (pos > this.textlineEnd[pointdata[1]]) {
                pointdata[1] = pointdata[1] + 1;
                --pos;
            }
            pointdata[3] = pos;
            pointdata[2] = pointdata[1] > 0 ? this.painterMetrics.charsWidth(this.textBuffer, this.textlineEnd[pointdata[1] - 1], pos - this.textlineEnd[pointdata[1] - 1]) : this.painterMetrics.charsWidth(this.textBuffer, 0, pos);
        }
    }

    public void setScreenPositionLine(int line, int offset, int[] pointdata) {
        if (line < 0) {
            pointdata[0] = 0;
            pointdata[1] = 0;
            pointdata[2] = 0;
            pointdata[3] = 0;
        } else if (line >= this.textlineEnd.length) {
            pointdata[1] = this.textlineEnd.length - 1;
            pointdata[2] = pointdata[1] > 0 ? this.painterMetrics.charsWidth(this.textBuffer, this.textlineEnd[pointdata[1] - 1], this.textBuffer.length - this.textlineEnd[pointdata[1] - 1]) : this.painterMetrics.charsWidth(this.textBuffer, 0, this.textBuffer.length);
            pointdata[3] = this.textBuffer.length;
            pointdata[0] = pointdata[3] + pointdata[1];
        } else if (offset < 0) {
            pointdata[1] = line;
            pointdata[3] = this.textlineEnd[line];
            pointdata[2] = line > 0 ? this.painterMetrics.charsWidth(this.textBuffer, this.textlineEnd[line - 1], this.textlineEnd[line] - this.textlineEnd[line - 1]) : this.painterMetrics.charsWidth(this.textBuffer, 0, this.textlineEnd[line]);
            pointdata[0] = pointdata[3] + line;
        } else if (offset == 0) {
            int n = 0;
            if (line > 0) {
                n = this.textlineEnd[line - 1];
            }
            pointdata[3] = n;
            pointdata[2] = 0;
            pointdata[1] = line;
            pointdata[0] = pointdata[3] + line;
        } else {
            pointdata[1] = line;
            int n = pointdata[3] = line > 0 ? RudolphPeer.getChars(offset, this.textlineEnd[line - 1], this.textBuffer, this.painterMetrics) : RudolphPeer.getChars(offset, 0, this.textBuffer, this.painterMetrics);
            if (pointdata[3] > this.textlineEnd[line]) {
                pointdata[3] = this.textlineEnd[line];
                pointdata[2] = line > 0 ? this.painterMetrics.charsWidth(this.textBuffer, this.textlineEnd[line - 1], this.textlineEnd[line] - this.textlineEnd[line - 1]) : this.painterMetrics.charsWidth(this.textBuffer, 0, this.textlineEnd[line]);
            } else {
                pointdata[2] = offset;
            }
            pointdata[0] = pointdata[3] + line;
        }
    }

    public void paint(int width, int height, int cursorline, int cursoroffset, int cursorscreenpos, Graphics g) {
        int offset;
        if (cursorline >= this.viewTextOffset.length) {
            cursorline = this.viewTextOffset.length - 1;
        }
        cursorscreenpos = cursoroffset > (offset = this.viewTextOffset[cursorline]) && offset < this.textBuffer.length && cursoroffset < this.textBuffer.length ? this.painterMetrics.charsWidth(this.textBuffer, offset, cursoroffset - offset) : -1;
        RudolphTextAreaPeer.paintTextArea(0, 0, width, height, this.textBuffer, this.viewTextOffset, this.viewTextLength, this.lineOffset, cursorline, cursorscreenpos, this.painterFont, this.painterMetrics, this.textColors, g, this.drawCursor);
    }

    public void paint(int width, int height, int startline, int startbufferoffset, int startscreenpos, int stopline, int stopbufferoffset, int stopscreenpos, Graphics g) {
        int temp;
        if (startbufferoffset > this.viewTextOffset[startline]) {
            temp = startbufferoffset - this.viewTextOffset[startline];
            if (temp > this.textBuffer.length - this.viewTextOffset[startline]) {
                temp = this.textBuffer.length - this.viewTextOffset[startline];
            }
            startscreenpos = this.painterMetrics.charsWidth(this.textBuffer, this.viewTextOffset[startline], temp);
        } else {
            startscreenpos = -1;
        }
        if (stopbufferoffset > this.viewTextOffset[stopline]) {
            temp = stopbufferoffset - this.viewTextOffset[stopline];
            if (temp > this.textBuffer.length - this.viewTextOffset[stopline]) {
                temp = this.textBuffer.length - this.viewTextOffset[stopline];
            }
            stopscreenpos = this.painterMetrics.charsWidth(this.textBuffer, this.viewTextOffset[stopline], temp);
        } else {
            stopscreenpos = -1;
        }
        RudolphTextAreaPeer.paintTextArea(0, 0, width, height, this.textBuffer, this.viewTextOffset, this.viewTextLength, this.lineOffset, startline, startbufferoffset, startscreenpos, stopline, stopbufferoffset, stopscreenpos, this.painterFont, this.painterMetrics, this.textColors, g, this.drawCursor);
    }

    public TextAreaPainter_ScrollingVarFont(Font textfont, FontMetrics metrics, String text, Dimension size, Color[] colors) {
        super(textfont, metrics, text, size, colors);
        this.calculateVisibleLineparts();
    }
}

