/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rudolph.peers;

import com.acunia.wonka.rudolph.peers.DefaultComponent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.peer.LabelPeer;

public class DefaultLabel
extends DefaultComponent
implements LabelPeer {
    private String text;
    private int alignment;

    public DefaultLabel(Label label) {
        super(label);
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
        this.paint(this.getGraphics());
    }

    public void setText(String text) {
        this.text = text;
        this.paint(this.getGraphics());
    }

    public Dimension getPreferredSize() {
        Label label = (Label)this.component;
        Font f = label.getFont();
        FontMetrics fm = this.getFontMetrics(f != null ? f : Component.DEFAULT_FONT);
        int cx = fm.stringWidth(this.text);
        int cy = fm.getHeight() + 4;
        return new Dimension(cx, cy);
    }

    public void paint(Graphics g) {
        if (g == null) {
            return;
        }
        this.alignment = ((Label)this.component).getAlignment();
        this.text = ((Label)this.component).getText();
        if (this.text != null) {
            Dimension size = this.component.getSize();
            g.setColor(this.component.getBackground());
            g.fillRect(0, 0, size.width, size.height);
            Font f = this.component.getFont();
            FontMetrics fm = this.getFontMetrics(f != null ? f : Component.DEFAULT_FONT);
            int sx = fm.stringWidth(this.text);
            switch (this.alignment) {
                case 0: {
                    sx = 0;
                    break;
                }
                case 1: {
                    sx = (size.width - sx) / 2;
                    break;
                }
                case 2: {
                    sx = size.width - sx;
                }
            }
            g.setColor(this.component.getForeground());
            g.drawString(this.text, sx, (size.height - fm.getHeight()) / 2 + fm.getAscent());
            super.paint(g);
        }
    }
}

