/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rudolph.peers;

import com.acunia.wonka.rudolph.peers.DefaultComponent;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ContainerEvent;
import java.awt.peer.ContainerPeer;

public class DefaultContainer
extends DefaultComponent
implements ContainerPeer {
    private int cw;
    private int ch;
    boolean validate = false;

    public native void createPeer(boolean var1);

    public native void addComponent(Component var1, int var2);

    public native void addContainer(Component var1, int var2);

    public native void removeComponent(Component var1);

    public native void scale(int var1, int var2);

    public DefaultContainer(Container container) {
        super(container);
        if (container instanceof Window) {
            this.createPeer(false);
        } else {
            this.createPeer(true);
        }
    }

    public void beginValidate() {
        this.validate = true;
    }

    public void endValidate() {
        this.validate = false;
    }

    public Insets getInsets() {
        return null;
    }

    public void setBounds(int x, int y, int w, int h) {
        if (this.cw != w || this.ch != h) {
            this.scale(w, h);
            this.ch = h;
            this.cw = w;
        }
        super.setBounds(x, y, w, h);
    }

    private void componentAdded(Component component) {
        int pos;
        Component[] components = component.getParent().getComponents();
        for (pos = 0; pos < components.length && components[pos] != component; ++pos) {
        }
        if (component instanceof Container) {
            this.addContainer(component, pos);
        } else {
            this.addComponent(component, pos);
        }
        if (pos != components.length - 1) {
            this.refresh(2);
        }
    }

    private void componentRemoved(Component component) {
        this.removeComponent(component);
        component.validate();
        this.refresh(2);
    }

    public boolean handleEvent(AWTEvent event) {
        if (event instanceof ContainerEvent) {
            ContainerEvent e = (ContainerEvent)event;
            switch (event.getID()) {
                case 300: {
                    this.componentAdded(e.getChild());
                    break;
                }
                case 301: {
                    this.componentRemoved(e.getChild());
                }
            }
        }
        return false;
    }

    public Insets insets() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRepaint() {
        Object object = this.component.getTreeLock();
        synchronized (object) {
            Graphics g = this.getGraphics();
            if (g != null) {
                this.component.update(g);
                this.refresh(2);
            }
        }
    }
}

