/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rudolph;

import com.acunia.wonka.rudolph.DecorationWindow;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class TitleWindow
extends DecorationWindow
implements MouseListener,
MouseMotionListener {
    private Label titlebar;
    private Window win;
    private Point lastClick = new Point();
    private boolean pressed = false;

    public TitleWindow(Window win) {
        this.titlebar = new Label();
        this.titlebar.setForeground(SystemColor.activeCaptionText);
        this.titlebar.setBackground(SystemColor.activeCaption);
        this.add((Component)this.titlebar, "Center");
        this.win = win;
        this.titlebar.addMouseListener(this);
        this.titlebar.addMouseMotionListener(this);
    }

    public void setTitle(String title) {
        this.titlebar.setText(title != null ? "  " + title : "");
    }

    public Insets getInsets() {
        return new Insets(1, 1, 1, 1);
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mouseMoved(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        this.pressed = true;
        this.lastClick.setLocation(event.getX(), event.getY());
    }

    public void mouseReleased(MouseEvent event) {
        this.pressed = false;
    }

    public void mouseDragged(MouseEvent event) {
        if (this.pressed) {
            int x1 = this.lastClick.x;
            int y1 = this.lastClick.y;
            int x2 = event.getX();
            int y2 = event.getY();
            int w = this.win.getSize().width;
            int h = this.win.getSize().height;
            int ox = this.win.getLocationOnScreen().x;
            int oy = this.win.getLocationOnScreen().y;
            this.win.setBounds(ox + x2 - x1, oy + y2 - y1, w, h);
        }
    }
}

