/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rmi;

import com.acunia.wonka.rmi.DefaultRMISocketFactory;
import com.acunia.wonka.rmi.ParameterSet;
import com.acunia.wonka.rmi.RMIConnection;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.net.Socket;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ObjID;
import java.rmi.server.Operation;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteRef;

public class UnicastRef2
implements RemoteRef {
    static final String REF_TYPE = "UnicastRef2";
    private String address;
    private int port;
    private ObjID id;
    private RMIClientSocketFactory csf;

    public String getRefClass(ObjectOutput out) {
        return REF_TYPE;
    }

    public Object invoke(Remote obj, Method method, Object[] params, long opnum) throws Exception {
        boolean type;
        Socket s = this.csf.createSocket(this.address, this.port);
        Class ret = method.getReturnType();
        boolean bl = false;
        if (ret != Void.TYPE) {
            bl = true;
        }
        Object o = (type = bl) && ret.isPrimitive() ? RMIConnection.requestPrimitive(s, opnum, -1, this.id, new ParameterSet(method, params), ret) : RMIConnection.requestObject(s, opnum, -1, this.id, new ParameterSet(method, params), type);
        return o;
    }

    public boolean remoteEquals(RemoteRef obj) {
        if (obj instanceof UnicastRef2) {
            UnicastRef2 ref = (UnicastRef2)obj;
            boolean bl = false;
            if (this.address.equals(ref.address) && this.port == ref.port && this.id.equals(ref.id)) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public int remoteHashCode() {
        return this.hashCode();
    }

    public String remoteToString() {
        return this.toString();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte useClientSocket = in.readByte();
        this.address = in.readUTF();
        this.port = in.readInt();
        if (useClientSocket == 1) {
            this.csf = (RMIClientSocketFactory)in.readObject();
        }
        this.id = ObjID.read(in);
        boolean bool = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        boolean writeFactory = false;
        if (this.csf.equals(DefaultRMISocketFactory.theDefault)) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            writeFactory = true;
        }
        out.writeUTF(this.address);
        out.writeInt(this.port);
        if (writeFactory) {
            out.writeObject(this.csf);
        }
        this.id.write(out);
        out.writeBoolean(false);
    }

    public String toString() {
        StringBuffer str = new StringBuffer(super.toString());
        return str.toString();
    }

    public void invoke(RemoteCall call) throws Exception {
        throw new RemoteException("UnsupportedOperation -- deprecated method");
    }

    public void done(RemoteCall call) throws RemoteException {
        throw new RemoteException("UnsupportedOperation -- deprecated method");
    }

    public RemoteCall newCall(RemoteObject obj, Operation[] op, int opnum, long hash) throws RemoteException {
        throw new RemoteException("UnsupportedOperation -- deprecated method");
    }

    public UnicastRef2() {
        this.csf = DefaultRMISocketFactory.theDefault;
    }

    public UnicastRef2(String address, int port, ObjID id, RMIClientSocketFactory csf) {
        this.address = address;
        this.port = port;
        this.id = id;
        this.csf = csf != null ? csf : DefaultRMISocketFactory.theDefault;
    }
}

