/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rmi;

import com.acunia.wonka.rmi.UnicastRef2;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.rmi.MarshalException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationID;
import java.rmi.server.ObjID;
import java.rmi.server.Operation;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteRef;

public class ActivatableRef
implements RemoteRef {
    static final String REF_TYPE = "ActivatableRef";
    private ActivationID activationID;
    private UnicastRef2 ref;

    public String getRefClass(ObjectOutput out) {
        return REF_TYPE;
    }

    public Object invoke(Remote obj, Method method, Object[] params, long opnum) throws Exception {
        return this.ref.invoke(obj, method, params, opnum);
    }

    public boolean remoteEquals(RemoteRef obj) {
        if (obj instanceof ActivatableRef) {
            ActivatableRef activatableRef = (ActivatableRef)obj;
            return this.ref.remoteEquals(activatableRef.ref);
        }
        return false;
    }

    public int remoteHashCode() {
        return this.hashCode();
    }

    public String remoteToString() {
        return this.toString();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.activationID = (ActivationID)in.readObject();
        String refType = in.readUTF();
        if (refType.equals("UnicastRef2")) {
            String name = "com.acunia.wonka.rmi." + refType;
            try {
                this.ref = (UnicastRef2)Class.forName(name).newInstance();
                this.ref.readExternal(in);
            }
            catch (NoSuchMethodException ie) {
                throw new MarshalException("no constructor with no arguments found for " + name);
            }
            catch (IllegalAccessException ie) {
                throw new MarshalException("no access for " + name);
            }
            catch (InstantiationException ie) {
                throw new MarshalException("failed to instantiate " + name);
            }
        } else if (!refType.equals("")) {
            throw new MarshalException("illegal nested remote reference type " + refType);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.activationID);
        if (this.ref != null) {
            out.writeUTF("UnicastRef2");
            this.ref.writeExternal(out);
        } else {
            out.writeUTF("");
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer(super.toString());
        return str.toString();
    }

    public void invoke(RemoteCall call) throws Exception {
        throw new RemoteException("UnsupportedOperation -- deprecated method");
    }

    public void done(RemoteCall call) throws RemoteException {
        throw new RemoteException("UnsupportedOperation -- deprecated method");
    }

    public RemoteCall newCall(RemoteObject obj, Operation[] op, int opnum, long hash) throws RemoteException {
        throw new RemoteException("UnsupportedOperation -- deprecated method");
    }

    public ActivatableRef() {
    }

    public ActivatableRef(ActivationID activationID, String address, int port, ObjID id, RMIClientSocketFactory csf) {
        this.activationID = activationID;
        this.ref = new UnicastRef2(address, port, id, csf);
    }
}

