/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.net.ftp;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;

public class FtpURLConnection
extends URLConnection {
    private static int clientport = 64000;
    private static final byte[] USER_BYTES = "USER ftp\r\n".getBytes();
    private static final byte[] PASS_BYTES = "PASS wonka\r\n".getBytes();
    private static final byte[] PORT_BYTES = "PORT ".getBytes();
    private static final byte[] RETR_BYTES = "RETR ".getBytes();
    private static final byte[] QUIT_BYTES = "QUIT \r\n".getBytes();
    private static final byte[] CRLF = new byte[]{13, 10};
    private Socket control;
    private ServerSocket acceptor;
    private Socket datastream;

    public synchronized void connect() throws IOException {
        if (!this.connected) {
            int port = this.url.getPort();
            if (port == -1) {
                port = 21;
            }
            this.control = new Socket(this.url.getHost(), port);
            this.control.setSoTimeout(5000);
            if (clientport < 1025) {
                clientport = 64000;
            }
            port = clientport;
            while (true) {
                try {
                    this.acceptor = new ServerSocket(port);
                    clientport = port - 1;
                }
                catch (IOException ioe) {
                    if (port < 1025) {
                        port = 65000;
                        continue;
                    }
                    --port;
                    continue;
                }
                break;
            }
            OutputStream out = this.control.getOutputStream();
            DataInputStream in = new DataInputStream(this.control.getInputStream());
            String code = this.checkReply(in);
            if (!code.equals("220")) {
                this.closeWithException("ftp service is unavailable");
            }
            out.write(USER_BYTES);
            code = this.checkReply(in);
            if (code.equals("331")) {
                out.write(PASS_BYTES);
                code = this.checkReply(in);
                if (!code.equals("230") && !code.equals("202")) {
                    this.closeWithException("Password needed to login on " + this.url.getHost() + " as user ftp");
                }
            } else if (!code.equals("230")) {
                this.closeWithException("Unable to login on " + this.url.getHost() + " as user ftp");
            }
            out.write("TYPE I\r\n".getBytes());
            code = this.checkReply(in);
            if (!code.equals("200") && !code.equals("502")) {
                this.closeWithException("Failed to set type");
            }
            out.write(PORT_BYTES);
            out.write(this.writePort(InetAddress.getLocalHost().getAddress(), port));
            out.write(CRLF);
            code = this.checkReply(in);
            if (!code.equals("200")) {
                this.closeWithException("Failed to specify port");
            }
            out.write(RETR_BYTES);
            out.write(this.url.getFile().getBytes());
            out.write(CRLF);
            code = this.checkReply(in);
            if (!code.equals("150") && !code.equals("125")) {
                this.closeWithException("RETR request failed for " + this.url.getFile());
            }
            this.acceptor.setSoTimeout(5000);
            this.datastream = this.acceptor.accept();
            this.connected = true;
        }
    }

    public Permission getPermission() throws IOException {
        return new SocketPermission(this.url.getHost() + ':' + (this.url.getPort() == -1 ? 21 : this.url.getPort()), "connect");
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.datastream.getInputStream();
    }

    private final byte[] writePort(byte[] address, int port) throws IOException {
        StringBuffer buf = new StringBuffer(128);
        int i = 0;
        while (i < address.length) {
            buf.append(0xFF & (char)address[i]);
            buf.append(',');
            ++i;
        }
        buf.append(port >> 8);
        buf.append(',');
        buf.append(port & 0xFF);
        return buf.toString().getBytes();
    }

    private final String checkReply(DataInputStream in) throws IOException {
        String reply = null;
        do {
            if ((reply = in.readLine()) != null && reply.length() >= 3) continue;
            this.control.getOutputStream().write(QUIT_BYTES);
            this.control.close();
            throw new IOException("Invalid Response");
        } while (reply.length() != 3 && reply.charAt(3) == '-');
        return reply.substring(0, 3);
    }

    private final void closeWithException(String message) throws IOException {
        this.control.getOutputStream().write(QUIT_BYTES);
        this.control.close();
        throw new IOException(message);
    }

    public FtpURLConnection(URL url) {
        super(url);
    }
}

