/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.misc;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class DialogTest
extends VisualTestImpl {
    public DialogTest() {
        Button modal = new Button("Modal");
        Button modeless = new Button("Modeless");
        this.add(modal);
        this.add(modeless);
        modal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new TestDialog(DialogTest.this.vt.getFrame(), true);
            }
        });
        modeless.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new TestDialog(DialogTest.this.vt.getFrame(), false);
            }
        });
    }

    public String getHelpText() {
        return "DialogTest";
    }

    private class TestDialog
    extends Dialog
    implements ActionListener {
        TestDialog(Frame frame, boolean modal) {
            super(frame, "A Dialog", modal);
            this.setBackground(Color.yellow);
            this.add((Component)new Label(modal ? "Modal dialog" : "Modeless dialog"), "Center");
            Button close = new Button("close");
            close.addActionListener(this);
            this.add((Component)close, "South");
            this.pack();
            Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((screensize.width - this.getSize().width) / 2, (screensize.height - this.getSize().height) / 2);
            this.show();
        }

        public void actionPerformed(ActionEvent e) {
            this.dispose();
        }

        public Insets getInsets() {
            return new Insets(10, 10, 10, 10);
        }
    }
}

