/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.layout;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class FlowLayoutHorizontal
extends VisualTestImpl
implements ActionListener {
    private Button addTop;
    private Button removeAllTop;
    private Panel Top;
    private int topCount;
    private Button addMid;
    private Button removeAllMid;
    private Panel Mid;
    private int midCount;
    private Button addBottom;
    private Button removeAllBottom;
    private Panel Bottom;
    private int bottomCount;
    private int step = 16;
    private static final int ELEMENTS = 6;

    public FlowLayoutHorizontal() {
        this.setLayout(new GridLayout(3, 1));
        Panel screentop = new Panel(new BorderLayout());
        screentop.setBackground(new Color(140, 140, 128));
        screentop.add((Component)new Label("FlowLayout (small elements)", 1), "North");
        this.addTop = new Button("add one button");
        this.addTop.setBackground(new Color(140, 155, 128));
        this.addTop.addActionListener(this);
        screentop.add((Component)this.addTop, "West");
        this.removeAllTop = new Button("remove all buttons");
        this.removeAllTop.setBackground(new Color(155, 140, 128));
        this.removeAllTop.addActionListener(this);
        screentop.add((Component)this.removeAllTop, "East");
        this.Top = new Panel(new FlowLayout());
        this.Top.setBackground(new Color(155, 155, 128));
        screentop.add((Component)this.Top, "Center");
        this.add(screentop);
        Panel screenmid = new Panel(new BorderLayout());
        screenmid.setBackground(new Color(140, 128, 140));
        screenmid.add((Component)new Label("FlowLayout (bigger elements)", 1), "North");
        this.addMid = new Button("add one button");
        this.addMid.setBackground(new Color(140, 128, 155));
        this.addMid.addActionListener(this);
        screenmid.add((Component)this.addMid, "West");
        this.removeAllMid = new Button("remove all buttons");
        this.removeAllMid.setBackground(new Color(155, 128, 140));
        this.removeAllMid.addActionListener(this);
        screenmid.add((Component)this.removeAllMid, "East");
        this.Mid = new Panel(new FlowLayout());
        this.Mid.setBackground(new Color(155, 128, 155));
        screenmid.add((Component)this.Mid, "Center");
        this.add(screenmid);
        Panel screenbottom = new Panel(new BorderLayout());
        screenbottom.setBackground(new Color(128, 140, 140));
        screenbottom.add((Component)new Label("FlowLayout (biggest elements)", 1), "North");
        this.addBottom = new Button("add one button");
        this.addBottom.setBackground(new Color(128, 140, 155));
        this.addBottom.addActionListener(this);
        screenbottom.add((Component)this.addBottom, "West");
        this.removeAllBottom = new Button("remove all buttons");
        this.removeAllBottom.setBackground(new Color(128, 155, 140));
        this.removeAllBottom.addActionListener(this);
        screenbottom.add((Component)this.removeAllBottom, "East");
        this.Bottom = new Panel(new FlowLayout());
        this.Bottom.setBackground(new Color(128, 155, 155));
        screenbottom.add((Component)this.Bottom, "Center");
        this.add(screenbottom);
    }

    public void actionPerformed(ActionEvent evt) {
        Button source = (Button)evt.getSource();
        if (source == this.addTop) {
            this.buildTopButton();
            this.Top.validate();
        } else if (source == this.removeAllTop) {
            this.Top.removeAll();
            this.Top.validate();
            this.topCount = 0;
        } else if (source.getActionCommand() == "Top") {
            this.Top.remove(source);
            this.Top.validate();
        } else if (source == this.addMid) {
            this.buildMidButton();
            this.Mid.validate();
        } else if (source == this.removeAllMid) {
            this.Mid.removeAll();
            this.Mid.validate();
            this.midCount = 0;
        } else if (source.getActionCommand() == "Mid") {
            this.Mid.remove(source);
            this.Mid.validate();
        } else if (source == this.addBottom) {
            this.buildBottomButton();
            this.Bottom.validate();
        } else if (source == this.removeAllBottom) {
            this.Bottom.removeAll();
            this.Bottom.validate();
            this.bottomCount = 0;
        } else if (source.getActionCommand() == "Bottom") {
            this.Bottom.remove(source);
            this.Bottom.validate();
        }
    }

    private void buildTopButton() {
        ++this.topCount;
        Button b = new Button("<Top no." + this.topCount + ">");
        b.setBackground(new Color(128, 155 + this.step * (this.topCount % 6), 128));
        b.setActionCommand("Top");
        b.addActionListener(this);
        this.Top.add(b);
    }

    private void buildMidButton() {
        ++this.midCount;
        Button b = new Button("<Mid element no." + this.midCount + ">");
        b.setBackground(new Color(155 + this.step * (this.midCount % 6), 128, 128));
        b.setActionCommand("Mid");
        b.addActionListener(this);
        this.Mid.add(b);
    }

    private void buildBottomButton() {
        ++this.bottomCount;
        Button b = new Button("<Bottom element number " + this.bottomCount + ", a rally, really, really, really big element>");
        b.setBackground(new Color(128, 128, 155 + this.step * (this.bottomCount % 6)));
        b.setActionCommand("Bottom");
        b.addActionListener(this);
        this.Bottom.add(b);
    }

    public String getHelpText() {
        return "A test to verify the dynamic layout of Rudolph's FlowLayout implementation\nA flowLayout displays as many elements in a row as can be added and then switches to the next row for the next elements\nThis tests shows three FlowLayouts. The buttons allow you to add new components to this row, remove them again and clear the whole layout. Each component has place for two rows of layouts. The elements are sized so that the top Container can display three of them in a row, the middle container two and the bottom container only one (and even that one not completely)\n\nItems to test:\n -> the placement of the elements over several rows.\n -> the moving up of the elements of the lower row when elements of the higher rows get deleted\n -> Managing elements that do not fit on the screen anymore. These elements becomming visible when higher (visible) elements get deleted and thus space for them becomes available.\n -> In the bottom row, the element is bigger then the available width. At least as much of the center part of it as is visible should be displayed.\nFOLLOWING THE DEFINITIONS OF A GRIDLAYOUT, REGARDLESS OF THE NUMBER OF COLUMS SPECIFIED, A LAYOUT WITH <n> COMPONENTS WILL SHOW ALL THESE <n> COMPONENTS IN A ROW AND EVERY COMPONENT WILL OCCUPY ONE <n>TH OF THE TOTAL SPACE AVAILABLE";
    }
}

