/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.layout;

import com.acunia.wonka.test.awt.layout.GridLayoutPositions;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class CardLayoutPositions
extends GridLayoutPositions
implements ActionListener {
    private static final String CARDA = "card <A>";
    private static final String CARDB = "card <B>";
    private static final String CARDC = "card <C>";
    private static final String CARDD = "card <D>";
    private Button first;
    private Button second;
    private Button third;
    private Button fourth;
    private Button buttonA;
    private Button buttonB;
    private Button buttonC;
    private Button buttonD;
    private Button lastClicked;
    private CardLayout layout1;
    private CardLayout layout2;
    private CardLayout layout3;
    private CardLayout layout4;
    private CardLayout layout5;
    private CardLayout layout6;
    private Panel panel1;
    private Panel panel2;
    private Panel panel3;
    private Panel panel4;
    private Panel panel5;
    private Panel panel6;

    protected Panel buildLayout(Button title, Panel layout, Button first, Object firstconstraints, Button second, Object secondconstraints, Button third, Object thirdconstraints, Button fourth, Object fourthconstraints) {
        Panel bigpicture = new Panel(new BorderLayout());
        bigpicture.add((Component)title, "North");
        layout.setForeground(Color.black);
        layout.add((Component)first, firstconstraints);
        layout.add((Component)second, secondconstraints);
        layout.add((Component)third, thirdconstraints);
        layout.add((Component)fourth, fourthconstraints);
        bigpicture.add((Component)layout, "Center");
        return bigpicture;
    }

    protected Panel buildLayout(Button title, Panel layout, Button first, Object firstconstraints, int firstpos, Button second, Object secondconstraints, int secondpos, Button third, Object thirdconstraints, int thirdpos, Button fourth, Object fourthconstraints, int fourthpos) {
        Panel bigpicture = new Panel(new BorderLayout());
        bigpicture.add((Component)title, "North");
        layout.setForeground(Color.black);
        layout.add(first, firstconstraints, firstpos);
        layout.add(second, secondconstraints, secondpos);
        layout.add(third, thirdconstraints, thirdpos);
        layout.add(fourth, fourthconstraints, fourthpos);
        bigpicture.add((Component)layout, "Center");
        return bigpicture;
    }

    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        String command = evt.getActionCommand();
        if (this.display.getItemCount() > 40) {
            this.display.removeAll();
        }
        if (src == this.first) {
            this.layout1.first(this.panel1);
            this.layout2.first(this.panel2);
            this.layout3.first(this.panel3);
            this.layout4.first(this.panel4);
            this.layout5.first(this.panel5);
            this.layout6.first(this.panel6);
            this.display.add("Showing first panel", 0);
            this.setButtons(this.first, false, true, false, true);
        } else if (src == this.second) {
            if (this.lastClicked == this.first) {
                this.layout1.next(this.panel1);
                this.layout2.next(this.panel2);
                this.layout3.next(this.panel3);
                this.layout4.next(this.panel4);
                this.layout5.next(this.panel5);
                this.layout6.next(this.panel6);
                this.display.add("Moved down (CardLayout.next() ) to second panel", 0);
            } else {
                this.layout1.previous(this.panel1);
                this.layout2.previous(this.panel2);
                this.layout3.previous(this.panel3);
                this.layout4.previous(this.panel4);
                this.layout5.previous(this.panel5);
                this.layout6.previous(this.panel6);
                this.display.add("Moved up (CardLayout.previous() ) to second panel", 0);
            }
            this.setButtons(this.second, true, false, true, true);
        } else if (src == this.third) {
            if (this.lastClicked == this.second) {
                this.layout1.next(this.panel1);
                this.layout2.next(this.panel2);
                this.layout3.next(this.panel3);
                this.layout4.next(this.panel4);
                this.layout5.next(this.panel5);
                this.layout6.next(this.panel6);
                this.display.add("Moved down (CardLayout.next() ) to third panel", 0);
            } else {
                this.layout1.previous(this.panel1);
                this.layout2.previous(this.panel2);
                this.layout3.previous(this.panel3);
                this.layout4.previous(this.panel4);
                this.layout5.previous(this.panel5);
                this.layout6.previous(this.panel6);
                this.display.add("Moved up (CardLayout.previous() ) to third panel", 0);
            }
            this.setButtons(this.third, true, true, false, true);
        } else if (src == this.fourth) {
            this.layout1.last(this.panel1);
            this.layout2.last(this.panel2);
            this.layout3.last(this.panel3);
            this.layout4.last(this.panel4);
            this.layout5.last(this.panel5);
            this.layout6.last(this.panel6);
            this.display.add("Showing last panel", 0);
            this.setButtons(this.fourth, true, false, true, false);
        } else if (command.equals(CARDA) || command.equals(CARDB) || command.equals(CARDC) || command.equals(CARDD)) {
            this.layout1.show(this.panel1, command);
            this.layout2.show(this.panel2, command);
            this.layout3.show(this.panel3, command);
            this.layout4.show(this.panel4, command);
            this.layout5.show(this.panel5, command);
            this.layout6.show(this.panel6, command);
            this.display.add("Showing panel " + command, 0);
            this.setButtons(null, true, false, false, true);
        } else {
            this.display.add(command, 0);
        }
    }

    private final void setButtons(Button current, boolean enablefirst, boolean enablesecond, boolean enablethird, boolean enablefourth) {
        boolean bl = false;
        if (current == this.first) {
            bl = true;
        }
        this.setButton(this.first, enablefirst, bl);
        boolean bl2 = false;
        if (current == this.second) {
            bl2 = true;
        }
        this.setButton(this.second, enablesecond, bl2);
        boolean bl3 = false;
        if (current == this.third) {
            bl3 = true;
        }
        this.setButton(this.third, enablethird, bl3);
        boolean bl4 = false;
        if (current == this.fourth) {
            bl4 = true;
        }
        this.setButton(this.fourth, enablefourth, bl4);
        this.lastClicked = current;
    }

    private final void setButton(Button target, boolean enabled, boolean iscurrent) {
        if (iscurrent) {
            target.setEnabled(false);
            target.setForeground(Color.white);
        } else if (!enabled) {
            target.setEnabled(false);
            target.setForeground(RUST);
        } else {
            target.setEnabled(true);
            target.setForeground(Color.yellow);
        }
    }

    public String getHelpText() {
        return "A test to verify Rudolph's implementation of the Container.add(Component, name, position) form in a CardLayout :\n\nThe cardlayout is special in a way that it stores its elements both under a specific name as well as by its position in the internal list. Likewise you can show an element <directly> by calling CardLayout.show(element name) and also can access it by its position in the list by calling the CardLayout.first(), -.next(), -.previous() and -.last() functions\n\nAgain, this test shows three rows of two panels. Again to each of them are added our four elements <A>,<B>,<C> and.<D>\nUsing the <first>,<second>, <third> and <fourth> buttons, you can use a combination of CardLayout.first(), -.next(), -.previous() and -.last() calls to access the first, second, third or fourth element in the layout\nUsing the <card- > buttons, you can directly access the element of that name by using CardLayout.show(element name)\n\nAs in all other position tests, the elements are added in order <A>+<B>+<C>+<D>, order <D>+<C>+<B>+<A> and order <A>+<B>+<D>+<C>respectingly, the left side by changing the order in which the elements are added to the list (using add(element, name)), the right one by specifying the order in the add(element, name, position) form\n\nIN ALL OF THE SITUATIONS, FOR ALL OF THE ROWS, THE LEFT PANELS AND THEIR CORRESPONDING RIGHT PANELS SHOULD LOOK EXACTLY THE SAME";
    }

    public CardLayoutPositions() {
        this.setBackground(Color.black);
        this.setForeground(Color.yellow);
        this.setLayout(new BorderLayout());
        Panel buttons = new Panel(new GridLayout(9, 1));
        this.first = new Button("First panel");
        this.first.addActionListener(this);
        this.first.setEnabled(false);
        buttons.add(this.first);
        this.second = new Button("Second panel");
        this.second.addActionListener(this);
        this.second.setEnabled(true);
        buttons.add(this.second);
        this.third = new Button("Third panel");
        this.third.addActionListener(this);
        this.third.setEnabled(false);
        buttons.add(this.third);
        this.fourth = new Button("Fourth panel");
        this.fourth.addActionListener(this);
        this.fourth.setEnabled(true);
        buttons.add(this.fourth);
        this.lastClicked = this.first;
        buttons.add(new Label());
        this.buttonA = new Button(CARDA);
        this.buttonA.addActionListener(this);
        buttons.add(this.buttonA);
        this.buttonB = new Button(CARDB);
        this.buttonB.addActionListener(this);
        buttons.add(this.buttonB);
        this.buttonC = new Button(CARDC);
        this.buttonC.addActionListener(this);
        buttons.add(this.buttonC);
        this.buttonD = new Button(CARDD);
        this.buttonD.addActionListener(this);
        buttons.add(this.buttonD);
        this.add((Component)buttons, "West");
        Panel main = new Panel(new GridLayout(3, 2));
        this.layout1 = new CardLayout();
        this.panel1 = new Panel(this.layout1);
        Button a = this.locationButton(CARDA, Color.red, "card <A> added first using add()");
        Button b = this.locationButton(CARDB, Color.green, "card <B> added second using add()");
        Button c = this.locationButton(CARDC, Color.blue, "card <C> added third using add()");
        Button d = this.locationButton(CARDD, Color.yellow, "card <D> added last using add()");
        Button title = this.locationButton("Reference layout add()", Color.black, "Layout built in sequence <A>,<B>,<C>,<D> using add()");
        main.add(this.buildLayout(title, this.panel1, a, CARDA, b, CARDB, c, CARDC, d, CARDD));
        this.layout2 = new CardLayout();
        this.panel2 = new Panel(this.layout2);
        a = this.locationButton(CARDA, Color.red, "card <A> added first to last place in list using add(-1)");
        b = this.locationButton(CARDB, Color.green, "card <B> added second to last place in list using add(-1)");
        c = this.locationButton(CARDC, Color.blue, "card <C> added third to last place in list using add(-1)");
        d = this.locationButton(CARDD, Color.yellow, "card <D> added last to last place in list using add()");
        title = this.locationButton("positioned default by add(-1)", Color.black, "Components added in sequence <A>,<B>,<C>,<D> using add(-1)");
        main.add(this.buildLayout(title, this.panel2, a, CARDA, -1, b, CARDB, -1, c, CARDC, -1, d, CARDD, -1));
        this.layout3 = new CardLayout();
        this.panel3 = new Panel(this.layout3);
        a = this.locationButton(CARDA, Color.red, "card <A> added last using add()");
        b = this.locationButton(CARDB, Color.green, "card <B> added third using add()");
        c = this.locationButton(CARDC, Color.blue, "card <C> added second using add()");
        d = this.locationButton(CARDD, Color.yellow, "card <D> added first using add()");
        title = this.locationButton("Inverse layout", Color.black, "Layout built in sequence <D>,<C>,<B>,<A> using add()");
        main.add(this.buildLayout(title, this.panel3, d, CARDD, c, CARDC, b, CARDB, a, CARDA));
        this.layout4 = new CardLayout();
        this.panel4 = new Panel(this.layout4);
        a = this.locationButton(CARDA, Color.red, "card <A> added first using add(0)");
        b = this.locationButton(CARDB, Color.green, "card <B> added second to first place in list using add(0)");
        c = this.locationButton(CARDC, Color.blue, "card <C> added third to first place in list using add(0)");
        d = this.locationButton(CARDD, Color.yellow, "card <D> added fourth to first place in list using add(0)");
        title = this.locationButton("Positioned first by add(0)", Color.black, "Components added in sequence <A>,<B>,<C>,<D>/new added first in list using add(0)");
        main.add(this.buildLayout(title, this.panel4, a, CARDA, 0, b, CARDB, 0, c, CARDC, 0, d, CARDD, 0));
        this.layout5 = new CardLayout();
        this.panel5 = new Panel(this.layout5);
        a = this.locationButton(CARDA, Color.red, "card <A> added first using add()");
        b = this.locationButton(CARDB, Color.green, "card <D> added second using add()");
        c = this.locationButton(CARDC, Color.blue, "card <C> added fourth using add()");
        d = this.locationButton(CARDD, Color.yellow, "card <D> added third by add() sequence");
        title = this.locationButton("<A>,<B>,<D>,<C> by adding order", Color.black, "Layout built in sequence <A>,<B>,<D>,<C> using add()");
        main.add(this.buildLayout(title, this.panel5, a, CARDA, b, CARDB, d, CARDD, c, CARDC));
        this.layout6 = new CardLayout();
        this.panel6 = new Panel(this.layout6);
        a = this.locationButton(CARDA, Color.red, "card <A> added first to first place in list using add(0)");
        b = this.locationButton(CARDB, Color.green, "card <B> added second to second place in list using add(1)");
        c = this.locationButton(CARDC, Color.blue, "card <C> added third to third in list using add(2), later moved up by <D>");
        d = this.locationButton(CARDD, Color.yellow, "card <D> deliberately added fourth to third place in list using add(2)");
        title = this.locationButton("<D> third by add(2)", Color.black, "Components added in sequence <A>,<B>,<C>,<D> using add(2) to set <D> third in list");
        main.add(this.buildLayout(title, this.panel6, a, CARDA, 0, b, CARDB, 1, c, CARDC, 2, d, CARDD, 2));
        this.add((Component)main, "Center");
        this.display = new List(2, false);
        this.display.setForeground(Color.white);
        this.display.add("Click on an item to get more info");
        this.add((Component)this.display, "South");
        this.layout1.first(this.panel1);
        this.layout2.first(this.panel2);
        this.layout3.first(this.panel3);
        this.layout4.first(this.panel4);
        this.layout5.first(this.panel5);
        this.layout6.first(this.panel6);
    }
}

