/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.layout;

import com.acunia.wonka.test.awt.VisualTestImpl;
import com.acunia.wonka.test.awt.layout.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class BorderLayout2
extends VisualTestImpl
implements ActionListener {
    private FillComponent north;
    private FillComponent south;
    private FillComponent east;
    private FillComponent west;
    private FillComponent center;
    private Button addNorth;
    private Button removeNorth;
    private Button addSouth;
    private Button removeSouth;
    private Button addCenter;
    private Button removeCenter;
    private Button addEast;
    private Button removeEast;
    private Button addWest;
    private Button removeWest;
    private Panel screen;

    public BorderLayout2() {
        this.setLayout(new java.awt.BorderLayout());
        this.setBackground(new Color(96, 96, 48));
        this.north = new FillComponent("north", new Color(96, 32, 32), Color.red, Color.white);
        this.west = new FillComponent("west", new Color(128, 128, 32), Color.yellow, Color.black);
        this.center = new FillComponent("center", new Color(32, 96, 32), Color.green, Color.white);
        this.east = new FillComponent("east", new Color(32, 32, 96), Color.blue, Color.white);
        this.south = new FillComponent("south", new Color(96, 32, 96), Color.magenta, Color.white);
        Panel buttons = new Panel(new GridLayout(10, 0));
        this.addNorth = new Button("add North component");
        this.addNorth.addActionListener(this);
        this.addNorth.setBackground(new Color(128, 64, 64));
        buttons.add(this.addNorth);
        this.removeNorth = new Button("remove North component");
        this.removeNorth.addActionListener(this);
        this.removeNorth.setBackground(new Color(192, 128, 128));
        buttons.add(this.removeNorth);
        this.addWest = new Button("add West component");
        this.addWest.addActionListener(this);
        this.addWest.setBackground(new Color(192, 192, 64));
        buttons.add(this.addWest);
        this.removeWest = new Button("remove West component");
        this.removeWest.addActionListener(this);
        this.removeWest.setBackground(new Color(255, 255, 128));
        buttons.add(this.removeWest);
        this.addCenter = new Button("add Center component");
        this.addCenter.addActionListener(this);
        this.addCenter.setBackground(new Color(64, 128, 64));
        buttons.add(this.addCenter);
        this.removeCenter = new Button("remove Center component");
        this.removeCenter.addActionListener(this);
        this.removeCenter.setBackground(new Color(128, 192, 128));
        buttons.add(this.removeCenter);
        this.addEast = new Button("add East component");
        this.addEast.addActionListener(this);
        this.addEast.setBackground(new Color(64, 64, 128));
        buttons.add(this.addEast);
        this.removeEast = new Button("remove East component");
        this.removeEast.addActionListener(this);
        this.removeEast.setBackground(new Color(128, 128, 192));
        buttons.add(this.removeEast);
        this.addSouth = new Button("add South component");
        this.addSouth.addActionListener(this);
        this.addSouth.setBackground(new Color(128, 64, 128));
        buttons.add(this.addSouth);
        this.removeSouth = new Button("remove South component");
        this.removeSouth.addActionListener(this);
        this.removeSouth.setBackground(new Color(192, 128, 192));
        buttons.add(this.removeSouth);
        this.add((Component)buttons, "East");
        this.screen = new Panel(new java.awt.BorderLayout());
        this.add((Component)this.screen, "Center");
    }

    public void actionPerformed(ActionEvent e) {
        Button b = (Button)e.getSource();
        if (b == this.addNorth) {
            this.screen.add((Component)this.north, "North");
            this.screen.validate();
        } else if (b == this.removeNorth) {
            this.screen.remove(this.north);
            this.screen.validate();
        } else if (b == this.addSouth) {
            this.screen.add((Component)this.south, "South");
            this.screen.validate();
        } else if (b == this.removeSouth) {
            this.screen.remove(this.south);
            this.screen.validate();
        } else if (b == this.addEast) {
            this.screen.add((Component)this.east, "East");
            this.screen.validate();
        } else if (b == this.removeEast) {
            this.screen.remove(this.east);
            this.screen.validate();
        } else if (b == this.addWest) {
            this.screen.add((Component)this.west, "West");
            this.screen.validate();
        } else if (b == this.removeWest) {
            this.screen.remove(this.west);
            this.screen.validate();
        } else if (b == this.addCenter) {
            this.screen.add((Component)this.center, "Center");
            this.screen.validate();
        } else if (b == this.removeCenter) {
            this.screen.remove(this.center);
            this.screen.validate();
        }
    }

    public static void main(String[] args) {
        BorderLayout tf = new BorderLayout();
        tf.show();
    }

    public String getHelpText() {
        return "A test to verify Rudolph's BorderLayout implementation\nUse the add- and remove- buttons on the right of the screen to add or remove a component to the panel on the left respectingly to the north, south, east, west or center of the panel using a BorderLayout layout manager\n\nitems to test\n\n => Correct location of the components added and a correct recalculation of all other components already present when adding or removing a component\n => correct size: Every one of the components displays in its center a rectangle that shows the minimum size of the component. FOR ALL OF THE BORDER LOCATIONS THE FRAME AROUND THIS RECTANGLE MUST BE COMPLETELY VISIBLE\n => pushing the add-button for a component several times in a row to make sure the application doesn't hang or crash when the same component is added twice\n\n WONKA 0.7.2: ADDING THE SAME COMPONENT TWICE CAUSES THE APPLICATION TO HANG\n =>pushing the remove-button for a component several times in a row to make sure the application doesn't hang or crash when the same component is removed twice";
    }

    class FillComponent
    extends Container {
        private Dimension bounds;
        private Rectangle innerRect;
        private Color innerColor;
        private Color textColor;
        private int middle;

        public FillComponent(String name, Color background, Color rectangle, Color text) {
            this.setBackground(background);
            this.setName(name);
            this.bounds = new Dimension();
            this.innerRect = new Rectangle(0, 0, 60, 50);
            this.innerColor = rectangle;
            this.textColor = text;
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.innerRect.width, this.innerRect.height);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.innerRect.width, this.innerRect.height);
        }

        public void paint(Graphics g) {
            this.update(g);
        }

        public void update(Graphics g) {
            if (!this.bounds.equals(this.getSize())) {
                this.bounds.setSize(this.getSize());
                this.innerRect.setLocation((this.bounds.width - this.innerRect.width) / 2, (this.bounds.height - this.innerRect.height) / 2);
                this.middle = this.getSize().height / 2;
            }
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.bounds.width - 1, this.bounds.height - 1);
            g.setColor(this.innerColor);
            g.drawRect(this.innerRect.x, this.innerRect.y, this.innerRect.width - 1, this.innerRect.height - 1);
            g.fillRect(this.innerRect.x + 2, this.innerRect.y + 2, this.innerRect.width - 4, this.innerRect.height - 4);
            g.setColor(this.textColor);
            g.drawString(this.getName(), this.innerRect.x + 5, this.middle);
        }
    }
}

