/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.event;

import com.acunia.wonka.test.awt.VisualTestImpl;
import com.acunia.wonka.test.awt.event.WindowEventDisplay;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class WindowMulticastTest
extends VisualTestImpl
implements ActionListener {
    private Window testWindow;
    private Button build;
    private Button kill;
    private Button show;
    private Button hide;
    private WindowEventDisplay anchor;
    private Button[] add;
    private Button[] remove;
    private WindowEventDisplay[] display;
    static final int LISTENERS = 5;

    public WindowMulticastTest() {
        this.setLayout(new BorderLayout());
        this.setBackground(new Color(128, 32, 128));
        this.setForeground(Color.white);
        int lighter = 96;
        int darker = 64;
        Panel buttons = new Panel(new GridLayout(1, 4));
        this.build = new Button("[*]build window");
        this.build.setBackground(new Color(lighter += 16, 32, darker += 16));
        this.build.addActionListener(this);
        buttons.add(this.build);
        this.show = new Button("[ ] show window");
        this.show.setBackground(new Color(lighter += 16, 32, darker += 16));
        this.show.addActionListener(this);
        buttons.add(this.show);
        this.hide = new Button("[.] hide window");
        this.hide.setBackground(new Color(lighter += 16, 32, darker += 16));
        this.hide.addActionListener(this);
        buttons.add(this.hide);
        this.kill = new Button("[x] dispose window");
        this.kill.setBackground(new Color(lighter += 16, 32, darker += 16));
        this.kill.addActionListener(this);
        buttons.add(this.kill);
        this.add((Component)buttons, "North");
        this.anchor = new WindowEventDisplay("Your window displayed here", new Color(darker, 32, darker += 16), Color.white);
        this.add((Component)this.anchor, "Center");
        Panel listeners = new Panel(new GridLayout(5, 1));
        Panel[] row = new Panel[5];
        this.add = new Button[5];
        this.display = new WindowEventDisplay[5];
        this.remove = new Button[5];
        for (int i = 0; i < 5; ++i) {
            row[i] = new Panel(new BorderLayout());
            this.display[i] = new WindowEventDisplay("press <build> to create a new window", new Color(darker -= 16, 48, lighter -= 16), Color.white);
            row[i].add((Component)this.display[i], "Center");
            this.add[i] = new Button("Add");
            this.add[i].setBackground(new Color(darker, 32, lighter));
            this.add[i].addActionListener(this);
            row[i].add((Component)this.add[i], "West");
            this.remove[i] = new Button("Remove");
            this.remove[i].setBackground(new Color(darker, 64, lighter));
            this.remove[i].addActionListener(this);
            row[i].add((Component)this.remove[i], "East");
            listeners.add(row[i]);
        }
        this.add((Component)listeners, "South");
    }

    public void stop(Panel p) {
        if (this.testWindow != null) {
            this.testWindow.dispose();
            this.testWindow = null;
        }
    }

    public void actionPerformed(ActionEvent evt) {
        Component source = (Component)evt.getSource();
        if (source == this.build && this.testWindow == null) {
            this.testWindow = this.buildWindow("Event Test Window", Color.red, this.anchor);
            for (int i = 0; i < 5; ++i) {
                this.display[i].displayMessage("Window built, press <add> to add this listener");
            }
        } else if (source == this.kill && this.testWindow != null) {
            int i;
            for (i = 0; i < 5; ++i) {
                this.display[i].displayMessage("Window and listeners deleted, press <build> for a new window");
            }
            this.testWindow.dispose();
            for (i = 0; i < 5; ++i) {
                this.testWindow.removeWindowListener(this.display[i]);
            }
            this.testWindow = null;
        } else if (source == this.show && this.testWindow != null) {
            this.testWindow.setVisible(true);
        } else if (source == this.hide && this.testWindow != null) {
            this.testWindow.setVisible(false);
        } else {
            boolean found = false;
            for (int i = 0; i < 5 && !found; ++i) {
                if (source == this.add[i] && this.testWindow != null) {
                    this.testWindow.addWindowListener(this.display[i]);
                    this.display[i].displayMessage("Window listener added. press <remove> to remove it again");
                    found = true;
                    continue;
                }
                if (source == this.add[i]) {
                    this.display[i].displayMessage("No window to add a listener to. Please build a one first");
                    found = true;
                    continue;
                }
                if (source == this.remove[i] && this.testWindow != null) {
                    this.testWindow.removeWindowListener(this.display[i]);
                    this.display[i].displayMessage("Window listener removed. press <add> to add it again");
                    found = true;
                    continue;
                }
                if (source != this.remove[i]) continue;
                this.display[i].displayMessage("No window to remove a listener from. Please build a one first");
                found = true;
            }
        }
    }

    private Window buildWindow(String text, Color textcolor, Component displayframe) {
        Window target = null;
        Frame vtframe = this.vt.getFrame();
        if (vtframe != null) {
            WindowEventDisplay contents = new WindowEventDisplay(text, new Color(198, 198, 128), textcolor, 150, 40);
            target = new Window(vtframe);
            target.setName(text);
            target.setLayout(new FlowLayout());
            target.add(contents);
            target.pack();
            Point p = displayframe.getLocationOnScreen();
            Rectangle b = displayframe.getBounds();
            target.setLocation(p.x + (b.width - target.getWidth()) / 2, p.y + (b.height - target.getHeight()) / 2);
        }
        return target;
    }

    public String getHelpText() {
        return "The aim: test the throwing of WindowEvents through the AWTEventMulticaster functions:\n\nThe screen consists out a row of buttons, an anchor area for the test window and 5 ItemDisplay panels. Each of this panels is flanked by an <add> and a <remove> button.\nUsing the <build window>, <show>, <hide> and <dispose> buttons in the top row, you can build a new test window, show and hide it and dispose/delete it again. Building a new window will do nothing, but showing, hiding or disposing it will fire a WindowEvent.\nUsing the <Add> button next to an event panel you can add a WindowListener to that panel in order to get all WindowEvents fired by the test window casted to that panel (and subsequently displayed there). Using the <remove> button you can remove that listener again\n.(Adding and removing of TextListeners is done by calls to the static AWTEventMulticaster.Add()and -remove() functions)\n\nThe top row buttons:\n-------------------\n <Build window> builds a new window and locates it in the center of the middle panel. (As this window is just freshly constructed, no listeners are added to it yet. They have to be added anew after every call to <build> by pressing that listener's <add> button.)\n <show> displays the testwindow on the screen. This triggers a WindowOpened() or WindowDeiconified() event on the test window that is casted to all subscribed listeners\n <hide> hides the testwindow again. This triggers a WindowIconified() event on the test window, again casted to all subscribed listeners\n <dispose> disposes the testwindow and subsequently deletes it. Disposing triggers a WindowClosed() event on the test window, again casted to all subscribed listeners. As the window is no longer available, this also removes all its listeners. they have to be added anew when the next test window is built\n\n Items to test : \n -------------\n => Pressing <add> for a panel and subsequently clicking the buttons to check if a WindowEvent is thrown and displayed on the newly selected panel, as well as on all other previously selected panels\n => Pressing <remove> for a panel and subsequently clicking a button to check if the WindowEvent thrown is no longer displayed on that panel, nor on the panels previously deselected, yet remains displayed on all other panels still selected\n => Pressing <add> for the same panel over and over again to see that the panel is not added twice\n => Pressing <remove> for the same panel over and over again, or pressing <remove> on a panel to which no listener is added yet to check that a panel is not removed twice\n \n ps. as the Add and remove routines have a slightly different algorithm for the first and second listener then for all subsequent listeners, specially check the behavior when \n    - adding the first panel, adding the second panel, adding the third panel\n    - removing the third-last panel, removing the second-last panel, removing the last panel\n    - giving a remove-command when no panels are selected";
    }

    public static void main(String[] args) {
        new WindowMulticastTest();
    }
}

