/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.event;

import com.acunia.wonka.test.awt.VisualTestImpl;
import com.acunia.wonka.test.awt.event.CollectsEvents;
import com.acunia.wonka.test.awt.event.MouseGeneratorComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Panel;

public class MouseMotionListenerTest
extends VisualTestImpl
implements CollectsEvents {
    private List display;
    private MouseGeneratorComponent trigger1 = new MouseGeneratorComponent("<MouseListener>", MouseGeneratorComponent.COPPER, MouseGeneratorComponent.DARKGREEN, this);
    private MouseGeneratorComponent trigger2;
    private MouseGeneratorComponent trigger3;

    public MouseMotionListenerTest() {
        this.trigger1.addMouseListener(this.trigger1);
        this.trigger2 = new MouseGeneratorComponent("<MouseMotionListener>", MouseGeneratorComponent.DARKSAND, MouseGeneratorComponent.DUSTGREEN, this);
        this.trigger2.addMouseMotionListener(this.trigger2);
        this.trigger3 = new MouseGeneratorComponent("<both listeners>", MouseGeneratorComponent.DARKGREEN, MouseGeneratorComponent.COPPER, this);
        this.trigger3.addMouseListener(this.trigger3);
        this.trigger3.addMouseMotionListener(this.trigger3);
        this.setLayout(new BorderLayout());
        Panel p = new Panel(new GridLayout(1, 3));
        p.add(this.trigger1);
        p.add(this.trigger2);
        p.add(this.trigger3);
        this.add((Component)p, "Center");
        this.display = new List(6, false);
        this.display.add("See your mouse events here");
        this.add((Component)this.display, "South");
    }

    public void displayMessage(String[] message) {
        if (this.display.getItemCount() > 40) {
            this.display.removeAll();
        }
        if (message.length > 1) {
            this.display.add("..... " + message[1], 0);
        }
        if (message.length > 0) {
            this.display.add(message[0], 0);
        }
    }

    public String getHelpText() {
        return "The test displays three mouse event fields and a list. Click or drag on any of the fields and see a display of the MouseEvent thrown appear in the list below.\n The left field only reacts to MouseListener events, the middle field only to MouseMotionListener events (moving and dragging) the right field reacts to both.\n\n Items to test:\n --------------\n=> The left panel must react to all MouseListener events (mouse entered, exited, pressed, released and clicked) and only to them\n=> The middle panel must react to all MouseMotionListener events (mouse moved and dragged) and only to them\n=> The right panel must react to both MouseListener as well as MouseMotionListener events\n=> The events displayed in the list must match the correct source as well as the correct mouse action\n\n current issues:\n --------------\n=> when moving the mouse, no MOUSE_MOVED MouseEvent is thrown \n=> No the MouseEvent's time is always 0 \n   (SEE THE OTHER ERRORS ON MOUSE-EVENTS IN THE MOUSE-EVENT TEST)\n\n\nPs: the behavior of the event fields to the panels is:" + this.trigger3.getHelpText();
    }

    public String toString() {
        return "MouseEventTest";
    }
}

