/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.event;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.Button;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.TextArea;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class MouseCoordinates
extends VisualTestImpl
implements MouseListener {
    Label l1;
    Button b1;
    TextArea t1;
    String lastEvent;
    String previousEvent;

    public MouseCoordinates() {
        this.setLayout(new GridLayout(3, 1));
        this.l1 = new Label("CLICK YOUR MOUSE HERE", 1);
        this.l1.addMouseListener(this);
        this.add(this.l1);
        this.b1 = new Button("CLICK YOUR MOUSE HERE");
        this.b1.setFont(new Font("helvB17", 1, 25));
        this.b1.addMouseListener(this);
        this.add(this.b1);
        this.t1 = new TextArea("Read your mouse events HERE", 3, 20, 1);
        this.add(this.t1);
    }

    public void mouseClicked(MouseEvent event) {
        this.displayMouseEvent("Function <mouseClicked(MouseEvent)> ...", event);
    }

    public void mouseEntered(MouseEvent event) {
        this.displayMouseEvent("Function <mouseEntered(MouseEvent)> ...", event);
    }

    public void mouseExited(MouseEvent event) {
        this.displayMouseEvent("Function <mouseExited(MouseEvent)> ...", event);
    }

    public void mousePressed(MouseEvent event) {
        this.displayMouseEvent("Function <mousePressed(MouseEvent)> ...", event);
    }

    public void mouseReleased(MouseEvent event) {
        this.displayMouseEvent("Function <mouseReleased(MouseEvent)> ...", event);
    }

    public String getHelpText() {
        return "using your mouse in either the uppermost panel or the central button shoule fire a MouseEvent that is then displayed in the textArea below.  The coordinates should be relative to the upper left corner of component clicked \n  The Mouse events that should be detected are: \n  Mouse clicked,\nMouse pressed,\nMouse released,\nMouse entered and\nMouse Exited";
    }

    private void displayMouseEvent(String eventstring, MouseEvent event) {
        this.previousEvent = this.lastEvent;
        this.lastEvent = eventstring;
        this.lastEvent = this.lastEvent + (event.getSource() == this.l1 ? "\nMouseEvent from Label :" : "\nMouseEvent from Button : ");
        switch (event.getID()) {
            case 500: {
                this.lastEvent = this.lastEvent + "\nevent getId() detected Mouse CLICKED";
                break;
            }
            case 501: {
                this.lastEvent = this.lastEvent + "\nevent getId() detected Mouse PRESSED";
                break;
            }
            case 502: {
                this.lastEvent = this.lastEvent + "\nevent getId() detected Mouse RELEASED";
                break;
            }
            case 504: {
                this.lastEvent = this.lastEvent + "\nevent getId() detected Mouse ENTERED)";
                break;
            }
            case 505: {
                this.lastEvent = this.lastEvent + "\nevent getId() detected Mouse EXITED";
                break;
            }
            default: {
                this.lastEvent = this.lastEvent + "\nevent getId() detected UNKNOWN MOUSE COMMAND";
            }
        }
        this.lastEvent = this.lastEvent + "\n at position(" + event.getX() + ", " + event.getY() + ")";
        this.lastEvent = this.lastEvent + "\n and getModifiers() = " + event.getModifiers();
        this.lastEvent = this.lastEvent + "\n and isControlDown() = " + event.isControlDown();
        this.lastEvent = this.lastEvent + "\n and isShiftDown() = " + event.isShiftDown();
        this.lastEvent = this.lastEvent + "\n and isConsumed() = " + event.isConsumed();
        this.lastEvent = this.lastEvent + "\n and isMetaDown() = " + event.isMetaDown();
        System.out.println(this.lastEvent);
        this.t1.setText(this.lastEvent + "\n\n  Previous event: \n" + this.previousEvent);
    }
}

