/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.event;

import com.acunia.wonka.test.awt.VisualTestImpl;
import com.acunia.wonka.test.awt.event.KeyDisplay;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class KeyEventTest
extends VisualTestImpl
implements ActionListener {
    private List listDisplay;
    private Button listClear;
    private static final int LISTENERS = 3;

    public KeyEventTest() {
        int gray = 96;
        int darkgray = 48;
        this.setLayout(new BorderLayout());
        Panel keydisplays = new Panel(new GridLayout(3, 1));
        for (int i = 0; i < 3; ++i) {
            keydisplays.add(new EventKeyDisplay("Listener_" + i, new Color(darkgray, darkgray, darkgray), new Color(gray, gray, gray + 48), Color.white));
            gray += 16;
            darkgray += 16;
        }
        this.add((Component)keydisplays, "North");
        this.listDisplay = new List(3, false);
        this.listDisplay.setBackground(new Color(gray, gray, gray + 48));
        this.listDisplay.add("Your KeyEvents displayed HERE");
        this.add((Component)this.listDisplay, "Center");
        this.listClear = new Button("Clear list");
        this.listClear.setBackground(new Color(gray += 16, gray, gray + 48));
        this.listClear.addActionListener(this);
        this.add((Component)this.listClear, "South");
    }

    public void actionPerformed(ActionEvent evt) {
        this.listDisplay.removeAll();
        this.listDisplay.add("Your KeyEvents displayed HERE");
    }

    public void displayListMessage(String message) {
        this.listDisplay.add(message, 0);
    }

    public void displayListMessage(String[] messagelist) {
        for (int i = 0; i < messagelist.length; ++i) {
            this.listDisplay.add(messagelist[i], i);
        }
    }

    public String getHelpText() {
        return "The aim: test the throwing and the correct layout of KeyEvents:\n\nThe test: The upper part of the screen consists out of three panels, each linked to a FocusListener and a KeyListener The FocusListener will cause the panel currently having the focus to change color. This is important because actions on the keyboard will send a KeyEvent to the component that currently has the focus and only to this one.\n\n Typing a key will display a short description of the key event in the panel currently active and will send a detailed description of the event to the message list below\n\nItems to test:\n- Key event chain: pressing a key should throw a KEY_PRESSED event. Releasing the key again should first throw a KEY_RELEASED event and then a KEY_TYPED event\n- Key modifiers: the four modifier keys <shift>, <ctrl>, <alt> and <meta>, when pressed together with a key character, should appear in that characters key-event as character modifiers\n- Key typed interpretation: when typing a character key together with the shift key, the KEY_RELEASED event should show this character as small char + shift, whereas the KEY_PRESSED event should show the corresponding capital character\n- Key focus: the key event will be thrown in that component that currently has the focus. If the focus is currently on the  display list, none of the event panels will receive the key events, so no events will be displayed\n- Non-character keys: There are a number of non-action keys such as F1 or home. The key event should recognise them through their KeyEvent.isActionKey() function which should return TRUE";
    }

    private class EventKeyDisplay
    extends KeyDisplay
    implements KeyListener,
    FocusListener,
    MouseListener {
        protected Color active;
        protected Color passive;
        protected String name;

        public EventKeyDisplay(String name, Color active, Color passive, Color text) {
            super(name, passive, text);
            this.active = active;
            this.passive = passive;
            this.name = name;
            this.addKeyListener(this);
            this.addFocusListener(this);
            this.addMouseListener(this);
        }

        public String toString() {
            return this.name;
        }

        public void focusGained(FocusEvent evt) {
            this.background = this.active;
            this.message = this.name + " (active)";
            KeyEventTest.this.displayListMessage(this.name + " gained focus");
            this.repaint();
        }

        public void focusLost(FocusEvent evt) {
            this.background = this.passive;
            this.message = this.name;
            KeyEventTest.this.displayListMessage(this.name + " lost focus");
            this.repaint();
        }

        public void keyPressed(KeyEvent evt) {
            this.message = EventKeyDisplay.displayKeyShortcut(evt);
            KeyEventTest.this.displayListMessage(EventKeyDisplay.displayKeyEvent(evt));
            KeyEventTest.this.displayListMessage("   => KEY EVENT...............");
            this.repaint();
        }

        public void keyReleased(KeyEvent evt) {
            this.message = EventKeyDisplay.displayKeyShortcut(evt);
            KeyEventTest.this.displayListMessage(EventKeyDisplay.displayKeyEvent(evt));
            KeyEventTest.this.displayListMessage("   => KEY EVENT...............");
            this.repaint();
        }

        public void keyTyped(KeyEvent evt) {
            this.message = EventKeyDisplay.displayKeyShortcut(evt);
            KeyEventTest.this.displayListMessage(EventKeyDisplay.displayKeyEvent(evt));
            KeyEventTest.this.displayListMessage("   => KEY EVENT...............");
            this.repaint();
        }

        public void mousePressed(MouseEvent evt) {
            if (this.background == this.passive) {
                this.requestFocus();
            }
        }

        public void mouseEntered(MouseEvent evt) {
        }

        public void mouseExited(MouseEvent evt) {
        }

        public void mouseReleased(MouseEvent evt) {
        }

        public void mouseClicked(MouseEvent evt) {
        }

        public boolean isFocusTraversable() {
            return true;
        }
    }
}

