/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.event;

import com.acunia.wonka.test.awt.event.AWTEventDisplay;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class KeyDisplay
extends AWTEventDisplay
implements KeyListener {
    public String getHelpText() {
        return "Displays a panel with a short text about the KeyEvent received.";
    }

    public void keyPressed(KeyEvent evt) {
        this.message = KeyDisplay.displayKeyShortcut(evt);
        this.repaint();
    }

    public void keyReleased(KeyEvent evt) {
        this.message = KeyDisplay.displayKeyShortcut(evt);
        this.repaint();
    }

    public void keyTyped(KeyEvent evt) {
        this.message = KeyDisplay.displayKeyShortcut(evt);
        this.repaint();
    }

    public static String[] displayKeyEvent(KeyEvent evt) {
        String[] lines = new String[3];
        Object source = evt.getSource();
        lines[0] = source == null ? "evt.getSource() == NULL" : "getSource()= " + source;
        int id = evt.getID();
        lines[0] = id == 401 ? lines[0] + " KEY_PRESSED(" : (id == 402 ? lines[0] + " KEY_RELEASED(" : (id == 400 ? lines[0] + " KEY_TYPED(" : lines[0] + " UNKNOWN COMMAND ID("));
        lines[0] = lines[0] + id + ") at time " + evt.getWhen();
        char key = evt.getKeyChar();
        id = evt.getModifiers();
        lines[1] = key == '\u0000' ? "undefined <CHAR_UNDEFINED> Actionkeys : " + id : "Character <" + key + "> Actionkeys : " + id;
        lines[1] = id == 0 ? lines[1] + " (No modifiers)" : lines[1] + " => " + KeyEvent.getKeyModifiersText(id);
        id = evt.getKeyCode();
        lines[2] = "Key code: " + id + " <" + KeyEvent.getKeyText(id);
        lines[2] = lines[2] + (evt.isActionKey() ? "> is action key" : ">");
        return lines;
    }

    public static String displayKeyShortcut(KeyEvent evt) {
        Object source = evt.getSource();
        int id = evt.getID();
        String line = id == 401 ? "<KEY_PRESSED> from " + source : (id == 402 ? "<KEY_RELEASED> from " + source : (id == 400 ? "<KEY_TYPED> from " + source : "<UNKNOWN COMMAND> from " + source));
        char c = evt.getKeyChar();
        line = evt.isActionKey() ? line + " Action key [" + KeyEvent.getKeyText(evt.getKeyCode()) + "] modifiers :" : (c == '\u0000' ? line + " undefined [" + KeyEvent.getKeyText(evt.getKeyCode()) + "] modifiers :" : line + " character <" + c + "> modifiers :");
        line = line + KeyEvent.getKeyModifiersText(evt.getModifiers());
        return line;
    }

    public KeyDisplay(String firstmessage, Color back, Color text) {
        super(firstmessage, back, text);
    }

    public KeyDisplay(Color back, Color text) {
        super("Your KeyEvents displayed HERE", back, text);
    }
}

