/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.event;

import com.acunia.wonka.test.awt.VisualTestImpl;
import com.acunia.wonka.test.awt.event.AWTEventDisplay;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

public class FocusMulticastTest
extends VisualTestImpl
implements ActionListener,
FocusListener {
    private Button[] add;
    private Button[] remove;
    private FocusDisplay[] display;
    static final int LISTENERS = 7;

    public FocusMulticastTest() {
        this.setForeground(new Color(32, 80, 32));
        this.setBackground(new Color(64, 128, 64));
        int step = 14;
        int green = 155;
        int shade1 = 100;
        int shade2 = 100;
        this.setLayout(new GridLayout(7, 1));
        Panel[] row = new Panel[7];
        this.add = new Button[7];
        this.display = new FocusDisplay[7];
        this.remove = new Button[7];
        for (int i = 0; i < 7; ++i) {
            row[i] = new Panel(new BorderLayout());
            this.add[i] = new Button("Add");
            this.add[i].setBackground(new Color(shade1, green, shade2));
            this.add[i].addActionListener(this);
            row[i].add((Component)this.add[i], "West");
            this.display[i] = new FocusDisplay("Display_" + i, "<Display" + i + "> (Press <add> to add a listener)", new Color(shade1 += step, green, shade2), this.getForeground());
            this.display[i].addFocusListener(this);
            row[i].add((Component)this.display[i], "Center");
            this.remove[i] = new Button("Remove");
            this.remove[i].setBackground(new Color(shade1, green += step, shade2));
            this.remove[i].addActionListener(this);
            row[i].add((Component)this.remove[i], "East");
            shade2 += step;
            this.add(row[i]);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        boolean found = false;
        Object source = evt.getSource();
        for (int i = 0; i < 7 && !found; ++i) {
            int j;
            if (source == this.add[i]) {
                for (j = 0; j < 7; ++j) {
                    this.display[j].addFocusListener(this.display[i]);
                }
                this.display[i].displayMessage("<" + this.display[i] + "> Listener added. press <remove> to remove it again");
                found = true;
                continue;
            }
            if (source != this.remove[i]) continue;
            for (j = 0; j < 7; ++j) {
                this.display[j].removeFocusListener(this.display[i]);
            }
            this.display[i].displayMessage("<" + this.display[i] + "> Listener removed. press <add> to add it again");
            found = true;
        }
    }

    public void focusGained(FocusEvent evt) {
        ((FocusDisplay)evt.getSource()).setFocus(true);
    }

    public void focusLost(FocusEvent evt) {
        ((FocusDisplay)evt.getSource()).setFocus(false);
    }

    public void displayMessage(String[] messagestrings) {
    }

    public String getHelpText() {
        return "The aim: test the throwing of FocusEvents through the AWTEventMulticaster functions:\n\nThe screen consists out of 7 FocusDisplay panels. Each of this panels is flanked by an <add> and a <remove> button.\nFurthermore, each of this panels has a focuslistener that throws an event every time it gained or lost focus Using the Add/Delete buttons next to the panels you can add to that panel the Focuslistener of all the panels on the screen, including the selected panel itself. A panel displays its panel name and the two last FocusEvents it received\n.(Adding and removing is done by calls to the static AWTEventMulticaster.Add()and -remove() functions)\n\n Items to test : \n -------------\n => Pressing <add> for a panel and subsequently clicking on one of the panels. On the newly selected panel, as well as on all other previously selected panels, you should see a focus-lost event for the panel previously clicked and a focus-gained event for the panel just clicked\n => Pressing one of the panels, you should see a focus-lost event for the panel previously clicked and a focus-gained event for the panel just clicked. (this on all panels selected) => Pressing one of the buttons either an add/remove button of the test, or a VisualTestEngine button, you should see a new event a focus-lost event for the panel previously clicked (the previous event also displayed should be the focus-gained event for that same panel)\n => Pressing <remove> for a panel and subsequently clicking a button you should see the FocusEvent no longer displayed on that panel, nor on the panels previously deselected, yet still displayed on the other panels still selected\n => Pressing <add> for the same panel over and over again, nothing should happen as a panel can not be added twice\n => Pressing <remove> for the same panel over and over again, or pressing <remove> on a panel to which no listener is added yet nothing should happen as a panel can not be removed twice\n \n ps. as the Add and remove routines have a slightly different algorithm for the first and second listener then for all subsequent listeners, specially check the behavior when \n    - adding the first panel, adding the second panel, adding the third panel\n    - removing the third-last panel, removing the second-last panel, removing the last panel\n    - giving a remove-command when no panels are selected\n Disclaimer : No panels were harmed during the making of this test.";
    }

    class FocusDisplay
    extends AWTEventDisplay
    implements FocusListener {
        private String name;
        private String lastEvent;
        private boolean hasFocus;

        public FocusDisplay(String title, String firstmessage, Color back, Color front) {
            super(firstmessage, back, front);
            this.name = title;
            this.lastEvent = "2) Nothing yet";
            this.hasFocus = false;
        }

        public void setFocus(boolean focus) {
            this.hasFocus = focus;
            this.repaint();
        }

        public void focusGained(FocusEvent evt) {
            this.message = this.displayFocusEventShortcut(evt);
            this.repaint();
        }

        public void focusLost(FocusEvent evt) {
            this.message = this.displayFocusEventShortcut(evt);
            this.repaint();
        }

        public String toString() {
            return this.name;
        }

        public void update(Graphics g) {
            if (this.frame.width == 0) {
                this.frame.setSize(this.getSize().width - 2, this.getSize().height - 2);
                this.inside.setBounds(5, 5, this.getSize().width - 10, this.getSize().height - 10);
            }
            g.setColor(this.hasFocus ? this.foreground : this.background);
            g.fillRect(1, 1, this.frame.width, this.frame.height);
            g.setColor(this.hasFocus ? this.background : this.foreground);
            g.drawRect(this.inside.x, this.inside.y, this.inside.width, this.inside.height);
            g.drawString(this.message, 20, 17);
        }

        public String displayFocusEventShortcut(FocusEvent evt) {
            String line = "<" + this.name + "> :1)" + evt.getSource();
            line = line + (evt.getID() == 1004 ? ":FOCUS GAINED " : ":FOCUS LOST ");
            line = line + this.lastEvent;
            this.lastEvent = "2)" + evt.getSource();
            this.lastEvent = this.lastEvent + (evt.getID() == 1004 ? ":FOCUS GAINED " : ":FOCUS LOST ");
            return line;
        }
    }
}

