/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.event;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.List;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class ContainerEventTest
extends VisualTestImpl
implements ItemListener,
ContainerListener {
    private Checkbox displayTopLeft;
    private FillComponent topLeft;
    private Checkbox displayTopCenter;
    private FillComponent topCenter;
    private Checkbox displayTopRight;
    private FillComponent topRight;
    private NamedPanel top;
    private Checkbox displayLowerLeft;
    private FillComponent lowerLeft;
    private Checkbox displayLowerCenter;
    private FillComponent lowerCenter;
    private Checkbox displayLowerRight;
    private FillComponent lowerRight;
    private NamedPanel lower;
    List display;
    int step = 16;
    static final int ELEMENTS = 6;

    public ContainerEventTest() {
        int clear = 155;
        this.setBackground(new Color(128, clear, clear));
        this.setLayout(new BorderLayout());
        this.display = new List(4, false);
        this.display.add("Your ContainerEvents displayed HERE");
        this.add((Component)this.display, "South");
        this.top = new NamedPanel("Top panel", new BorderLayout());
        this.top.setForeground(Color.white);
        this.top.setBackground(new Color(128, clear, 128));
        Label toplabel = new Label("Top panel", 1);
        toplabel.setBackground(new Color(128, clear += this.step, 128));
        this.top.add((Component)toplabel, "North");
        Panel topboxes = new Panel(new GridLayout(1, 3));
        topboxes.setBackground(new Color(128, clear += this.step, 128));
        this.displayTopLeft = new Checkbox("display left", false);
        this.displayTopLeft.addItemListener(this);
        topboxes.add(this.displayTopLeft);
        this.displayTopCenter = new Checkbox("display center", false);
        this.displayTopCenter.addItemListener(this);
        topboxes.add(this.displayTopCenter);
        this.displayTopRight = new Checkbox("display right", false);
        this.displayTopRight.addItemListener(this);
        topboxes.add(this.displayTopRight);
        this.top.add((Component)topboxes, "South");
        this.top.addContainerListener(this);
        this.add((Component)this.top, "North");
        this.topLeft = new FillComponent("<top Left>", new Color(128, clear += this.step, 128), new Color(128, 128, clear), Color.white);
        this.topCenter = new FillComponent("<top Center>", new Color(128, clear += this.step, 128), new Color(128, 128, clear), Color.white);
        this.topRight = new FillComponent("<top Right>", new Color(128, clear += this.step, 128), new Color(128, 128, clear), Color.white);
        clear = 155;
        this.lower = new NamedPanel("Lower panel", new BorderLayout());
        this.lower.setForeground(Color.white);
        this.lower.setBackground(new Color(128, 128, clear));
        Label lowerlabel = new Label("Lower panel", 1);
        lowerlabel.setBackground(new Color(128, 128, clear += this.step));
        this.lower.add((Component)lowerlabel, "North");
        Panel lowerboxes = new Panel(new GridLayout(1, 3));
        lowerboxes.setBackground(new Color(128, 128, clear += this.step));
        this.displayLowerLeft = new Checkbox("display left", false);
        this.displayLowerLeft.addItemListener(this);
        lowerboxes.add(this.displayLowerLeft);
        this.displayLowerCenter = new Checkbox("display center", false);
        this.displayLowerCenter.addItemListener(this);
        lowerboxes.add(this.displayLowerCenter);
        this.displayLowerRight = new Checkbox("display right", false);
        this.displayLowerRight.addItemListener(this);
        lowerboxes.add(this.displayLowerRight);
        this.lower.add((Component)lowerboxes, "South");
        this.lower.addContainerListener(this);
        this.add((Component)this.lower, "Center");
        this.lowerLeft = new FillComponent("<lower Left>", new Color(128, 128, clear += this.step), new Color(128, clear, 128), Color.white);
        this.lowerCenter = new FillComponent("<lower Center>", new Color(128, 128, clear += this.step), new Color(128, clear, 128), Color.white);
        this.lowerRight = new FillComponent("<lower Right>", new Color(128, 128, clear += this.step), new Color(128, clear, 128), Color.white);
    }

    public void itemStateChanged(ItemEvent evt) {
        Checkbox source = (Checkbox)evt.getSource();
        if (source == this.displayTopLeft && source.getState()) {
            this.top.add((Component)this.topLeft, "West");
            this.validate();
        } else if (source == this.displayTopLeft) {
            this.top.remove(this.topLeft);
            this.validate();
        } else if (source == this.displayTopCenter && source.getState()) {
            this.top.add((Component)this.topCenter, "Center");
            this.validate();
        } else if (source == this.displayTopCenter) {
            this.top.remove(this.topCenter);
            this.validate();
        } else if (source == this.displayTopRight && source.getState()) {
            this.top.add((Component)this.topRight, "East");
            this.validate();
        } else if (source == this.displayTopRight) {
            this.top.remove(this.topRight);
            this.validate();
        } else if (source == this.displayLowerLeft && source.getState()) {
            this.lower.add((Component)this.lowerLeft, "West");
            this.validate();
        } else if (source == this.displayLowerLeft) {
            this.lower.remove(this.lowerLeft);
            this.validate();
        } else if (source == this.displayLowerCenter && source.getState()) {
            this.lower.add((Component)this.lowerCenter, "Center");
            this.validate();
        } else if (source == this.displayLowerCenter) {
            this.lower.remove(this.lowerCenter);
            this.validate();
        } else if (source == this.displayLowerRight && source.getState()) {
            this.lower.add((Component)this.lowerRight, "East");
            this.validate();
        } else if (source == this.displayLowerRight) {
            this.lower.remove(this.lowerRight);
            this.validate();
        }
    }

    public void componentAdded(ContainerEvent evt) {
        this.displayEvent(evt, "componentAdded(evt)");
    }

    public void componentRemoved(ContainerEvent evt) {
        this.displayEvent(evt, "componentRemoved(evt)");
    }

    private void displayEvent(ContainerEvent evt, String action) {
        if (this.display.getItemCount() > 20) {
            this.display.removeAll();
        }
        String line = " On component " + evt.getChild() + " From source " + evt.getContainer();
        this.display.add(line, 0);
        int id = evt.getID();
        line = "Got " + action;
        line = id == 300 ? line + " for event <COMPONENT_ADDED>" : (id == 301 ? line + " for event <COMPONENT_REMOVED>" : line + " for unknown event (" + id + ")");
        this.display.add(line, 0);
    }

    public String getHelpText() {
        return "A on throwing and displaying ContainerEvents:\n The test shows a list and two panels (a green and a blue one) each with a heading and three checkboxes. The checkboxes allow you to add or remove a component on the left, right or center of the panel. The list displays the ContainerEvents fetched by a call to ContainerListener.componentAdded() or ContainerListener.componentRemoved() every time a component is added or removed\n\nItems to test:\n => Component adding/removing: Clicking a checkbox should result in a component being added or removed. This must be directly visible in the panel to which this component was added.\n => Component events: Also adding a component (through its checkbox) should throw a ContainerListener.componentAdded() event the ContainerEvent of which is analysed and displayed in the list below. Likewise, removing a component should throw a ContainerListener.componentRemoved() event displayrd likewise.\n => ComponentEvent data: the ComponentEvent display should list in a correct way the container that threw the event, the component added or removed and the event ID ContainerEvent.COMPONENT_ADDED or ContainerEvent.COMPONENT_REMOVED.\n => Component layout: The top panel is added as BorderLayout.NORTH through a BorderLayout manager. If it doesn't contain components, it should display only the title and the checkboxes. If one component is added, it should grow in height to host that component, while the lower panel should shrink an equal amount. Likewise removing the last component of the top panel should force the lower panel to grow until the top panel only contains title and checkboxes.\n => Component size: The components added are a special test component, that display their minimum size as a colored rectangle in the middle of their screen. the BorderLayout used takes the minimum sizes of the components for his layout calculations so that:\n ... the left and right conponents of the lower panel should not be wider then their inner rectangle, yet should display this rectangle completely\n ... the center component of the top panel should not be higher then the inner rectangle, yet should display this rectangle completely\n ... the left and right components of the top panel should consist out of the rectangle, and nothing but the rectangle, yet this rectangle should be completely visible";
    }

    public static void main(String[] args) {
        ContainerEventTest ce = new ContainerEventTest();
        ce.show();
    }

    class NamedPanel
    extends Panel {
        public NamedPanel(String name, LayoutManager layout) {
            super(layout);
            this.setName(name);
        }

        public String toString() {
            return this.getName();
        }
    }

    class FillComponent
    extends Container {
        private Dimension bounds;
        private Rectangle innerRect;
        private Color innerColor;
        private Color textColor;
        private int middle;

        public FillComponent(String name, Color background, Color rectangle, Color text) {
            this.setBackground(background);
            this.setName(name);
            this.bounds = new Dimension();
            this.innerRect = new Rectangle(0, 0, 60, 25);
            this.innerColor = rectangle;
            this.textColor = text;
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.innerRect.width, this.innerRect.height);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.innerRect.width, this.innerRect.height);
        }

        public void paint(Graphics g) {
            this.update(g);
        }

        public void update(Graphics g) {
            if (!this.bounds.equals(this.getSize())) {
                this.bounds.setSize(this.getSize());
                this.innerRect.setLocation((this.bounds.width - this.innerRect.width) / 2, (this.bounds.height - this.innerRect.height) / 2);
                this.middle = this.getSize().height / 2;
            }
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.bounds.width - 1, this.bounds.height - 1);
            g.setColor(this.innerColor);
            g.drawRect(this.innerRect.x, this.innerRect.y, this.innerRect.width - 1, this.innerRect.height - 1);
            g.fillRect(this.innerRect.x + 2, this.innerRect.y + 2, this.innerRect.width - 4, this.innerRect.height - 4);
            g.setColor(this.textColor);
            g.drawString(this.getName(), this.innerRect.x, this.middle + 3);
        }

        public String toString() {
            return this.getName();
        }
    }
}

