/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.event;

import com.acunia.wonka.test.awt.VisualTestImpl;
import com.acunia.wonka.test.awt.event.AdjustmentDisplay;
import com.acunia.wonka.test.awt.event.CollectsEvents;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.List;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

public class AdjustmentEventTest
extends VisualTestImpl
implements AdjustmentListener,
CollectsEvents {
    private NamedScrollbar leftVertical;
    private NamedScrollbar rightVertical;
    private NamedScrollbar centerHorizontal;
    private AdjustmentDisplay display1;
    private List display2;

    public AdjustmentEventTest() {
        this.setForeground(new Color(108, 56, 32));
        this.setBackground(new Color(64, 160, 96));
        int step = 25;
        int green = 155 - step;
        this.setLayout(new BorderLayout());
        this.display1 = new AdjustmentDisplay(new Color(64, 255, 255), this.getForeground());
        this.setLayout(new BorderLayout());
        Panel center = new Panel(new BorderLayout());
        this.leftVertical = new NamedScrollbar("<Left Vertical>", 1, 0, 10, 0, 100);
        this.leftVertical.setBackground(new Color(64, green, green));
        this.leftVertical.addAdjustmentListener(this);
        this.leftVertical.addAdjustmentListener(this.display1);
        center.add((Component)this.leftVertical, "West");
        this.centerHorizontal = new NamedScrollbar("<Center Horizontal>", 0, 0, 200, 0, 1000);
        this.centerHorizontal.setBackground(new Color(64, green += step, green));
        this.centerHorizontal.addAdjustmentListener(this);
        this.centerHorizontal.addAdjustmentListener(this.display1);
        center.add((Component)this.centerHorizontal, "Center");
        this.rightVertical = new NamedScrollbar("<Right Vertical>", 1, 200, 200, 200, 1000);
        this.rightVertical.setBackground(new Color(64, green += step, green));
        this.rightVertical.addAdjustmentListener(this);
        this.rightVertical.addAdjustmentListener(this.display1);
        center.add((Component)this.rightVertical, "East");
        green += step;
        center.add((Component)this.display1, "South");
        this.add((Component)center, "Center");
        this.display2 = new List(3, false);
        this.display2.add("Your ItemEvents displayed HERE");
        this.add((Component)this.display2, "South");
    }

    public void adjustmentValueChanged(AdjustmentEvent evt) {
        String[] messagestrings = AdjustmentDisplay.displayAdjustmentEvent(evt);
        if (this.display2.getItemCount() > 40) {
            this.display2.removeAll();
        }
        for (int i = messagestrings.length - 1; i >= 0; --i) {
            this.display2.add(messagestrings[i], 0);
        }
    }

    public void displayMessage(String[] messagestrings) {
        if (this.display2.getItemCount() > 40) {
            this.display2.removeAll();
        }
        for (int i = messagestrings.length - 1; i >= 0; --i) {
            this.display2.add(messagestrings[i], 0);
        }
    }

    public String getHelpText() {
        return "The aim: test the throwing and the correct layout of AdjustmentEvents:\n\nThe test: The upper part of the screen consists out of a series of horizontal and vertical scrollbars. The lower part consists out of an event panel and a list. All AdjustmentEvents fired by  the scrollbars are caught and displayed in both the list and the panel.\n\nItems to test:\n- Event generating and catching: Every movement of the scrollbox of one of the scrollboxes should fire an AdjustmentEvent that is displayed BOTH in the event panel as in the lower list\n- Correct event data: Every event is analysed and displayed in two lines in the lower list:\n   => first line: the object generating the event: THis is the 'name' of the scrollbar\n   Furthermore it should display the corrent value for AWTEvent.getID(). (601 for <AdjustmentEvent.ADJUSTMENT_VALUE_CHANGED > )\n   => second line: the AdjustmentEvent's type flag being one of <UNIT_INCREMENT>, <BLOCK_INCREMENT>, <BLOCK_DECREMENT>, <UNIT_DECREMENT> or <TRACK>according to the field the scrollbar was clicked\n   Also in this line is the position value of the scrollbox\n \n (The Scrollpane-class also throwing an ItemEvent is not covered here for reasons of it not being implemented yet in Wonka)\n";
    }

    class NamedScrollbar
    extends Scrollbar {
        String name;

        public NamedScrollbar(String name, int alignment, int position, int span, int minimum, int maximum) {
            super(alignment, position, span, minimum, maximum);
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

