/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.event;

import com.acunia.wonka.test.awt.event.CollectsEvents;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;

public class AWTEventDisplay
extends Component
implements CollectsEvents {
    protected static final int MINIMUMWIDTH = 70;
    protected static final int MINIMUMHEIGHT = 25;
    protected Color background;
    protected Color foreground;
    protected String message;
    protected Dimension frame;
    protected Rectangle inside;

    public Dimension getMinimumSize() {
        return new Dimension(70, 25);
    }

    public Dimension getPreferredSize() {
        return new Dimension(70, 25);
    }

    public String getHelpText() {
        return "Displays a panel with a short text about the Event received.";
    }

    public void displayMessage(String[] messagestrings) {
        if (messagestrings.length > 0) {
            this.message = messagestrings[0];
            this.repaint();
        }
    }

    public void displayMessage(String messagestring) {
        this.message = messagestring;
        this.repaint();
    }

    public void paint(Graphics g) {
        this.update(g);
    }

    public void update(Graphics g) {
        if (this.frame.width == 0) {
            this.frame.setSize(this.getSize().width - 2, this.getSize().height - 2);
            this.inside.setBounds(5, 5, this.getSize().width - 10, this.getSize().height - 10);
        }
        g.setColor(this.background);
        g.fillRect(1, 1, this.frame.width, this.frame.height);
        g.setColor(this.foreground);
        g.drawRect(this.inside.x, this.inside.y, this.inside.width, this.inside.height);
        g.drawString(this.message, 20, 17);
    }

    public static String[] displayEvent(AWTEvent evt) {
        Object source = evt.getSource();
        String[] lines = new String[]{source == null ? "evt.getSource() == NULL" : (source instanceof Component && ((Component)source).getName() != null ? "getSource() = " + ((Component)source).getName() : "getSource()= " + source)};
        int id = evt.getID();
        lines[0] = lines[0] + " AWTEvent ID = (" + id + ')';
        return lines;
    }

    public static String displayEventShortcut(AWTEvent evt) {
        Object source = evt.getSource();
        String line = source == null ? "Source() == NULL " : (source instanceof Component && ((Component)source).getName() != null ? "Source() = " + ((Component)source).getName() : "Source() = " + source);
        line = line + " AWTEvent ID = (" + evt.getID() + ')';
        return line;
    }

    public AWTEventDisplay(String firstmessage, Color back, Color text) {
        this.background = back;
        this.foreground = text;
        this.frame = new Dimension();
        this.inside = new Rectangle();
        this.message = firstmessage;
    }

    public AWTEventDisplay(Color back, Color text) {
        this("Your ItemEvents displayed HERE", back, text);
    }
}

