/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Rectangle;

import com.acunia.wonka.test.awt.VisualTestImpl;
import com.acunia.wonka.test.awt.VisualTester;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class RectangleIntersects
extends VisualTestImpl
implements MouseListener,
MouseMotionListener {
    Rectangle target1;
    Rectangle target2;
    Rectangle union;
    Rectangle intersection;
    Rectangle bounds;
    Rectangle current;
    Point lastClick;

    public RectangleIntersects() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.target1 = new Rectangle();
        this.target2 = new Rectangle();
        this.union = new Rectangle();
        this.intersection = new Rectangle();
        this.bounds = new Rectangle();
        this.lastClick = new Point();
        this.current = null;
    }

    public String getHelpText() {
        return "Tests the functions Rectangle.union(Rectangle), Rectangle.intersects(Rectangle) and Rectangle.intersection(Rectangle)\n\nOn startup, the screen shows a blue field and two green rectangles: a smaller one in the topleft corner and a bigger one in the center A white rectangular frame surround them Issues to test : \n => Rectangle.union(Rectangle):click on one of the rectangles and then drag the mouse to move it. The white frame should change in size such that it forms the 'union' of the two rectangles: the smallest rectangle that contains both rectangles\n => Rectangle.intersection(dx,dy): when one rectangle moves over the other, the test will calculate the intersecting area of the two rectangles and paint it in yellow => Rectangle.intersects(): when <intersects()> detects that the two rectangles overlap, (regardless of the intersection shown). the frame will change its color from white to cyan";
    }

    public Panel getPanel(VisualTester vt) {
        return this;
    }

    public String getLogInfo(Panel p, boolean b) {
        return "no logging info !";
    }

    public void start(Panel p, boolean b) {
    }

    public void stop(Panel p) {
    }

    public void showTest() {
    }

    public void hideTest() {
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        if (this.target2.contains(event.getPoint())) {
            this.current = this.target2;
            this.lastClick.setLocation(event.getPoint());
            this.repaint();
        } else if (this.target1.contains(event.getPoint())) {
            this.current = this.target1;
            this.lastClick.setLocation(event.getPoint());
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent event) {
        if (this.current != null) {
            this.current = null;
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent event) {
        int dy;
        int dx = event.getX() - this.lastClick.x;
        if (this.bounds.contains(this.current.x + dx, this.current.y + (dy = event.getY() - this.lastClick.y)) && this.bounds.contains(this.current.x + this.current.width + dx, this.current.y + this.current.height + dy)) {
            this.current.translate(dx, dy);
            this.union = this.target1.union(this.target2);
            this.intersection = this.target1.intersection(this.target2);
            this.repaint();
        }
        this.lastClick.setLocation(event.getPoint());
    }

    public void mouseMoved(MouseEvent event) {
    }

    public void update(Graphics g) {
        if (this.bounds.width == 0) {
            this.bounds.setBounds(5, 5, this.getSize().width - 10, this.getSize().height - 10);
            this.target1.setBounds(5 + this.bounds.width / 3, 5 + this.bounds.height / 3, this.bounds.width / 3, this.bounds.height / 3);
            this.target2.setBounds(5, 5, this.bounds.width / 5, this.bounds.height / 5);
            this.union = this.target1.union(this.target2);
        }
        g.setColor(Color.blue);
        g.fillRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        g.setColor(this.current == this.target1 ? Color.red : Color.green);
        g.fillRect(this.target1.x, this.target1.y, this.target1.width, this.target1.height);
        g.setColor(this.current == this.target2 ? Color.red : Color.green);
        g.fillRect(this.target2.x, this.target2.y, this.target2.width, this.target2.height);
        g.setColor(this.target1.intersects(this.target2) ? Color.cyan : Color.white);
        g.drawRect(this.union.x, this.union.y, this.union.width, this.union.height);
        if (!this.intersection.isEmpty()) {
            g.setColor(Color.yellow);
            g.fillRect(this.intersection.x, this.intersection.y, this.intersection.width, this.intersection.height);
        }
    }

    public void paint(Graphics g) {
        this.update(g);
    }

    public static void main(String[] args) {
        new RectangleIntersects();
    }
}

