/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.List;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Writer;

public class SingleListTest
extends VisualTestImpl
implements ActionListener {
    List redList;
    List blueList;
    List greenList;
    Button toRed;
    Button toBlue;
    Button toGreen;
    String logString;

    public SingleListTest() {
        this(4, 5, false);
    }

    public SingleListTest(int minitems, int desired, boolean multiple) {
        this.setLayout(new BorderLayout());
        this.redList = new List(minitems, multiple);
        this.blueList = new List(minitems, multiple);
        this.greenList = new List(minitems, multiple);
        for (int i = 1; i <= desired; ++i) {
            this.redList.add("RED-LIST ITEM " + i + " (standard length)");
            this.blueList.add("BLUE-LIST ITEM" + i + " (short)");
            this.greenList.add("GREEN-LIST ITEM" + i + " (Extra long to test horizontal scrolling)");
        }
        this.redList.setBackground(new Color(255, 128, 128));
        this.blueList.setBackground(new Color(128, 128, 255));
        this.greenList.setBackground(new Color(128, 225, 128));
        this.toBlue = new Button("Red to BLUE");
        this.toBlue.addActionListener(this);
        this.toBlue.setBackground(new Color(255, 128, 128));
        this.toGreen = new Button("Blue to GREEN");
        this.toGreen.addActionListener(this);
        this.toGreen.setBackground(new Color(128, 128, 225));
        this.toRed = new Button("Green to RED");
        this.toRed.addActionListener(this);
        this.toRed.setBackground(new Color(128, 255, 128));
        Panel buttonrow = new Panel(new GridLayout(1, 2));
        buttonrow.add(this.toBlue);
        buttonrow.add(this.toGreen);
        buttonrow.add(this.toRed);
        this.add((Component)this.redList, "North");
        this.add((Component)this.blueList, "West");
        this.add((Component)this.greenList, "Center");
        this.add((Component)buttonrow, "South");
        this.logString = new String();
        this.setSize(389, 219);
        this.show();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.toBlue) {
            this.moveItems(this.redList, this.blueList);
        } else if (evt.getSource() == this.toGreen) {
            this.moveItems(this.blueList, this.greenList);
        } else {
            this.moveItems(this.greenList, this.redList);
        }
    }

    private void moveItems(List from, List to) {
        Object[] selected = from.getSelectedObjects();
        for (int i = 0; i < selected.length; ++i) {
            to.add((String)selected[i], 0);
            from.remove((String)selected[i]);
        }
    }

    public Panel getPanel() {
        return this;
    }

    public String getTitle() {
        return "ListTest : single selections";
    }

    public String getHelpText() {
        String help = "A test on list behavior for a single element selection list.\n";
        help = help + "The test draws three lists: a red one, a  blue one and a green one on different fields of a Borderlayout";
        help = help + " It also gives you three buttons that enable you to copy elements from one list to another\n";
        help = help + "\n Items to test:\n";
        help = help + "=> Minimum visible elements: The red list is defined with a minimum of 4 visible items, being drawn in the BorderLayout.NORTH";
        help = help + " field it should display exactly four of its five elements and a vertical scrollbar to scroll to the fifth\n";
        help = help + "=> Minimum width: The blue list is being drawn in the BorderLayout.WEST field. All of its items should be completely visible";
        help = help + "(with a default font big enough, this makes the remaining BroderLayout.CENTER field so small that the items";
        help = help + " of the green list can not displayed completely and this list is drawn with a vertical scrollbar)\n";
        help = help + " => Selecting: An item of a list can be selected by clicking it. It's selected state should be cleasly visible.";
        help = help + " Clicking a selected item deselects it again. Only one element can be selected at a time: selecting an element automatically deselects the previous one. \n";
        help = help + " => Moving between lists: clicking the red-to-blue button removes the selected item of the red list from that list";
        help = help + " and adds it to the blue one. Likewise the blue-to-green and green-to-red buttons copy elements between the lists of that colors\n";
        help = help + " => Scrollbar management: if copying an element to a list gives this list more elements than it can display, a vertical scrollbar";
        help = help + " is added to allow scrolling to any of the elements. If by removing an element from a list all elements can be displayed at once";
        help = help + " the scrollbar is removed again. Likewise a horizontal scrollbar is added when an element is copied into the list that is longer";
        help = help + " then the list length and removed again if that element is removed.\n";
        help = help + " => Mouse scrolling: next to scrolling through the list using the scrollbars, you can also move the selectinon";
        help = help + " by dragging your mouse along the borders of the list viewport\n";
        return help;
    }

    public void log(Panel p, Writer w) throws IOException {
        w.write(this.logString);
        this.logString = "";
    }

    public void start(Panel p, boolean b) {
    }

    public void stop(Panel p) {
    }

    public static void main(String[] args) {
        int min = 3;
        int desired = 5;
        boolean multiple = false;
        if (args.length > 0) {
            min = Integer.parseInt(args[0]);
        }
        if (args.length > 1) {
            desired = Integer.parseInt(args[1]);
        }
        if (args.length > 2) {
            multiple = true;
        }
        new SingleListTest(min, desired, multiple);
    }
}

