/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Image;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;

public class RGBImageFilter
extends VisualTestImpl {
    public RGBImageFilter() {
        String path = System.getProperty("property.path", "/test");
        Image original = Toolkit.getDefaultToolkit().getImage(path + "/lena1.png");
        Image color1 = this.createImage(new FilteredImageSource(original.getSource(), new MaskFilter(-2039584)));
        Image color2 = this.createImage(new FilteredImageSource(original.getSource(), new MaskFilter(-8355712)));
        Image red = this.createImage(new FilteredImageSource(original.getSource(), new MaskFilter(-65536)));
        Image green = this.createImage(new FilteredImageSource(original.getSource(), new MaskFilter(-16711936)));
        Image blue = this.createImage(new FilteredImageSource(original.getSource(), new MaskFilter(-16776961)));
        Image gray = this.createImage(new FilteredImageSource(original.getSource(), new GrayFilter()));
        Image invert = this.createImage(new FilteredImageSource(original.getSource(), new InvertFilter()));
        Image shaded = this.createImage(new FilteredImageSource(original.getSource(), new ShadeFilter()));
        this.setLayout(new GridLayout(3, 3));
        this.add(new MyPanel(original, "   Original   "));
        this.add(new MyPanel(color1, " 3 bit/color  "));
        this.add(new MyPanel(color2, " 1 bit/color  "));
        this.add(new MyPanel(red, "  red layer   "));
        this.add(new MyPanel(green, " green layer  "));
        this.add(new MyPanel(blue, "  blue layer  "));
        this.add(new MyPanel(gray, "   grayscale  "));
        this.add(new MyPanel(invert, "   inverted   "));
        this.add(new MyPanel(shaded, "    shaded    "));
    }

    public String getHelpText() {
        return "A Simple ImageFilter / FilteredImageSource test\n\nYou should see 9 images in a 3 by 3 grid. The first image on the first row is the original. Then there are 2 copies with less and even lesser colors.\nThe second row contains the red layer, the green layer and the blue layer of the image.\nThe third row are mixtures. The first should look yellow, the second should look cyan and the third should look purple";
    }

    public class MyPanel
    extends Panel {
        private Image image;
        private String label;

        public MyPanel(Image image, String label) {
            this.image = image;
            this.label = label;
            this.setBackground(Color.black);
        }

        public void paint(Graphics g) {
            g.drawImage(this.image, 1, 1, null);
            g.setColor(Color.white);
            g.drawString(this.label, 35, 60);
        }
    }

    public class InvertFilter
    extends java.awt.image.RGBImageFilter {
        private boolean canFilterIndexColorModel = false;

        public int filterRGB(int x, int y, int rgb) {
            return -1 - rgb | 0xFF000000;
        }
    }

    public class ShadeFilter
    extends java.awt.image.RGBImageFilter {
        private boolean canFilterIndexColorModel = false;
        private int w;
        private int h;
        private ColorModel model = ColorModel.getRGBdefault();

        public void setDimensions(int w, int h) {
            super.setDimensions(w, h);
            this.w = w;
            this.h = h;
        }

        public int filterRGB(int x, int y, int rgb) {
            int f1 = ((x < this.w / 2 ? x : this.w - x) << 8) / (this.w / 2);
            int f2 = ((y < this.h / 2 ? y : this.h - y) << 8) / (this.h / 2);
            int r = this.model.getRed(rgb) * f1 * f2 >>> 16;
            int g = this.model.getGreen(rgb) * f1 * f2 >>> 16;
            int b = this.model.getBlue(rgb) * f1 * f2 >>> 16;
            return 0xFF000000 | r << 16 | g << 8 | b;
        }
    }

    public class MaskFilter
    extends java.awt.image.RGBImageFilter {
        private int mask;
        private boolean canFilterIndexColorModel = false;

        public MaskFilter(int mask) {
            this.mask = mask;
        }

        public int filterRGB(int x, int y, int rgb) {
            return rgb & this.mask;
        }
    }

    public class GrayFilter
    extends java.awt.image.RGBImageFilter {
        private boolean canFilterIndexColorModel = false;
        private ColorModel model = ColorModel.getRGBdefault();

        public int filterRGB(int x, int y, int rgb) {
            float[] HSB = new float[3];
            Color.RGBtoHSB(this.model.getRed(rgb), this.model.getGreen(rgb), this.model.getBlue(rgb), HSB);
            return Color.HSBtoRGB(HSB[0], 0.0f, HSB[2]);
        }
    }
}

