/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Image;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.MemoryImageSource;

public class MemoryImageSourceTest
extends VisualTestImpl {
    Image img;

    public MemoryImageSourceTest() {
        int w = 100;
        int h = 100;
        int[] pix = new int[w * h];
        int index = 0;
        for (int y = 0; y < h; ++y) {
            int red = y * 255 / (h - 1);
            for (int x = 0; x < w; ++x) {
                int blue = x * 255 / (w - 1);
                pix[index++] = 0xFF000000 | red << 16 | blue;
            }
        }
        this.img = this.createImage(new MemoryImageSource(w, h, pix, 0, w));
        this.setBackground(Color.black);
        this.repaint();
    }

    public void paint(Graphics g) {
        g.drawImage(this.img, 10, 10, null);
    }

    public String getHelpText() {
        return "You should see a square with a gradient.\nThe top left should be black\nThe bottom left should be red\nThe top right should be blue\nThe bottom right should be purple\n";
    }
}

