/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Image;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ColorModel;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageProducer;
import java.awt.image.RGBImageFilter;
import java.awt.image.ReplicateScaleFilter;

public class CompositeFilters
extends VisualTestImpl {
    private Image original;
    private Rectangle crop;
    private Point lastClick;
    private Scrollbar slideR;
    private Scrollbar slideG;
    private Scrollbar slideB;
    private Scrollbar scaleX;
    private Scrollbar scaleY;
    private Checkbox flipV;
    private Checkbox flipH;
    private DstImagePanel dest = new DstImagePanel();

    public CompositeFilters() {
        String path = System.getProperty("property.path", "/test");
        this.original = Toolkit.getDefaultToolkit().getImage(path + "/lena1.png");
        this.setBackground(Color.black);
        this.setLayout(new BorderLayout());
        Panel left = new Panel(new BorderLayout());
        left.add((Component)new SrcImagePanel(), "North");
        Panel boxes = new Panel(new GridLayout(2, 1));
        boxes.setBackground(Color.black);
        boxes.setForeground(Color.white);
        this.flipH = new Checkbox("Flip Horizontal");
        this.flipV = new Checkbox("Flip Vertical");
        boxes.add(this.flipH);
        boxes.add(this.flipV);
        left.add((Component)boxes, "Center");
        Panel sliders = new Panel(new GridLayout(3, 1));
        sliders.setBackground(Color.black);
        sliders.setForeground(Color.white);
        this.slideR = new Scrollbar(0, 255, 5, 0, 255);
        this.slideG = new Scrollbar(0, 255, 5, 0, 255);
        this.slideB = new Scrollbar(0, 255, 5, 0, 255);
        sliders.add(this.slideR);
        sliders.add(this.slideG);
        sliders.add(this.slideB);
        Panel scalers = new Panel(new GridLayout(1, 2));
        scalers.setBackground(Color.black);
        scalers.setForeground(Color.white);
        this.scaleX = new Scrollbar(1, 10, 5, 1, 40);
        this.scaleY = new Scrollbar(1, 10, 5, 1, 40);
        scalers.add(this.scaleX);
        scalers.add(this.scaleY);
        this.add((Component)left, "West");
        this.add((Component)this.dest, "Center");
        this.add((Component)sliders, "South");
        this.add((Component)scalers, "East");
        this.repaint();
    }

    public String getHelpText() {
        return "CompositeFilters";
    }

    public class DstImagePanel
    extends Panel {
        public DstImagePanel() {
            this.setBackground(new Color(0x202020));
        }

        public void update(Graphics g) {
            g.setColor(new Color(0x202020));
            g.fillRect(0, 0, 500, 500);
            ImageProducer ip = CompositeFilters.this.original.getSource();
            ip = new FilteredImageSource(ip, new CropImageFilter(((CompositeFilters)CompositeFilters.this).crop.x, ((CompositeFilters)CompositeFilters.this).crop.y, ((CompositeFilters)CompositeFilters.this).crop.width, ((CompositeFilters)CompositeFilters.this).crop.height));
            Image cropped = this.createImage(ip);
            ip = new FilteredImageSource(ip, new ReplicateScaleFilter(cropped.getWidth(null) * CompositeFilters.this.scaleX.getValue() / 10, cropped.getHeight(null) * CompositeFilters.this.scaleY.getValue() / 10));
            ip = new FilteredImageSource(ip, new FlipFilter(CompositeFilters.this.flipH.getState(), CompositeFilters.this.flipV.getState()));
            ip = new FilteredImageSource(ip, new ShaderFilter(CompositeFilters.this.slideR.getValue(), CompositeFilters.this.slideG.getValue(), CompositeFilters.this.slideB.getValue()));
            g.drawImage(this.createImage(ip), 2, 2, null);
        }

        public void paint(Graphics g) {
            this.update(g);
        }
    }

    public class ShaderFilter
    extends RGBImageFilter {
        private boolean canFilterIndexColorModel = false;
        private int r;
        private int g;
        private int b;
        private ColorModel model = ColorModel.getRGBdefault();

        public ShaderFilter(int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public int filterRGB(int x, int y, int rgb) {
            int r2 = this.model.getRed(rgb) * this.r >>> 8;
            int g2 = this.model.getGreen(rgb) * this.g >>> 8;
            int b2 = this.model.getBlue(rgb) * this.b >>> 8;
            return 0xFF000000 | r2 << 16 | g2 << 8 | b2;
        }
    }

    public class FlipFilter
    extends ImageFilter {
        private boolean hor;
        private boolean ver;
        private int width;
        private int height;

        public FlipFilter(boolean hor, boolean ver) {
            this.hor = hor;
            this.ver = ver;
        }

        public void setDimensions(int w, int h) {
            super.setDimensions(w, h);
            this.width = w;
            this.height = h;
        }

        public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
            int[] newpixels = new int[pixels.length];
            int nx = this.hor ? this.width - x - w : x;
            int ny = this.ver ? this.height - y - h : y;
            for (int i = 0; i < h; ++i) {
                for (int j = 0; j < w; ++j) {
                    newpixels[(this.ver ? h - 1 - i : i) * w + (this.hor ? w - 1 - j : j)] = pixels[i * scansize + j + off];
                }
            }
            super.setPixels(nx, ny, w, h, model, newpixels, 0, w);
        }

        public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
            int[] newpixels = new int[pixels.length];
            int nx = this.hor ? this.width - x - w : x;
            int ny = this.ver ? this.height - y - h : y;
            for (int i = 0; i < h; ++i) {
                for (int j = 0; j < w; ++j) {
                    newpixels[(this.ver ? h - 1 - i : i) * w + (this.hor ? w - 1 - j : j)] = pixels[i * scansize + j + off];
                }
            }
            super.setPixels(nx, ny, w, h, model, newpixels, 0, w);
        }
    }

    public class SrcImagePanel
    extends Panel
    implements MouseListener,
    MouseMotionListener {
        public SrcImagePanel() {
            this.setBackground(Color.black);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            CompositeFilters.this.crop = new Rectangle(10, 10, 30, 30);
            CompositeFilters.this.lastClick = new Point();
        }

        public Dimension getMinimumSize() {
            return new Dimension(CompositeFilters.this.original.getWidth(null) + 4, CompositeFilters.this.original.getHeight(null) + 4);
        }

        public Dimension getPreferredSize() {
            return new Dimension(CompositeFilters.this.original.getWidth(null) + 4, CompositeFilters.this.original.getHeight(null) + 4);
        }

        public void update(Graphics g) {
            g.drawImage(CompositeFilters.this.original, 2, 2, null);
            g.setColor(Color.white);
            g.drawRect(2 + ((CompositeFilters)CompositeFilters.this).crop.x, 2 + ((CompositeFilters)CompositeFilters.this).crop.y, ((CompositeFilters)CompositeFilters.this).crop.width, ((CompositeFilters)CompositeFilters.this).crop.height);
        }

        public void paint(Graphics g) {
            this.update(g);
        }

        public void mouseClicked(MouseEvent event) {
        }

        public void mouseEntered(MouseEvent event) {
        }

        public void mouseExited(MouseEvent event) {
        }

        public void mouseMoved(MouseEvent event) {
        }

        public void mousePressed(MouseEvent event) {
            CompositeFilters.this.lastClick.setLocation(event.getX() - 2, event.getY() - 2);
            CompositeFilters.this.crop.setBounds(((CompositeFilters)CompositeFilters.this).lastClick.x, ((CompositeFilters)CompositeFilters.this).lastClick.y, 0, 0);
            this.repaint();
        }

        public void mouseReleased(MouseEvent event) {
            this.repaint();
            CompositeFilters.this.dest.repaint();
        }

        public void mouseDragged(MouseEvent event) {
            int x1 = ((CompositeFilters)CompositeFilters.this).lastClick.x;
            int y1 = ((CompositeFilters)CompositeFilters.this).lastClick.y;
            int x2 = event.getX() - 2;
            int y2 = event.getY() - 2;
            CompositeFilters.this.crop.setBounds(Math.min(x1, x2), Math.min(y1, y2), Math.abs(x1 - x2), Math.abs(y1 - y2));
            this.repaint();
        }
    }
}

