/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.GridBagLayout;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class GridBagWeights
extends VisualTestImpl
implements ActionListener {
    protected static final int ELEMENTSIZE = 20;
    protected Panel testPanel;
    protected FillComponent currentElement;
    private BorderedLabel number;
    private BorderedLabel weightX;
    private BorderedLabel weightY;
    private Button increaseX;
    private Button decreaseX;
    private Button increaseY;
    private Button decreaseY;
    private BorderedLabel colWidthsLeft;
    private BorderedLabel colWidthsMid;
    private BorderedLabel colWidthsRight;
    private BorderedLabel totalColWidths;
    private BorderedLabel colWeightsLeft;
    private BorderedLabel colWeightsMid;
    private BorderedLabel colWeightsRight;
    private BorderedLabel rowHeightsLeft;
    private BorderedLabel rowHeightsMid;
    private BorderedLabel rowHeightsRight;
    private BorderedLabel totalRowHeights;
    private BorderedLabel rowWeightsLeft;
    private BorderedLabel rowWeightsMid;
    private BorderedLabel rowWeightsRight;

    public GridBagWeights() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.yellow);
        this.add((Component)this.buildButtonPanel(), "East");
        Panel mid = new Panel(new BorderLayout());
        mid.add((Component)this.buildTopPanel(), "North");
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.testPanel = new Panel(gbl);
        this.testPanel.setBackground(new Color(200, 200, 120));
        gbc.fill = 1;
        for (int i = 0; i < 3; ++i) {
            gbc.gridy = i;
            for (int j = 0; j < 3; ++j) {
                gbc.gridx = j;
                this.currentElement = new FillComponent("no." + (3 * i + j) + " (" + j + ", " + i + ")", Color.white, new Color(i * 48, 100, j * 48));
                this.testPanel.add(this.currentElement);
                gbl.setConstraints(this.currentElement, gbc);
            }
        }
        mid.add((Component)this.testPanel, "Center");
        mid.add((Component)this.buildWeightsPanel(), "South");
        this.add((Component)mid, "Center");
        this.displayData(this.currentElement);
        this.currentElement.inverse(true);
    }

    protected Panel buildButtonPanel() {
        Panel buttons = new Panel(new GridLayout(11, 1));
        buttons.add(new Label("  columns  : weightX", 1));
        Panel split3 = new Panel(new GridLayout(1, 3));
        this.colWeightsLeft = new BorderedLabel(Color.lightGray);
        split3.add(this.colWeightsLeft);
        this.colWeightsMid = new BorderedLabel(Color.lightGray);
        split3.add(this.colWeightsMid);
        this.colWeightsRight = new BorderedLabel(Color.lightGray);
        split3.add(this.colWeightsRight);
        buttons.add(split3);
        buttons.add(new Label("widths / free widths  ", 1));
        Panel split4 = new Panel(new GridLayout(1, 3));
        this.colWidthsLeft = new BorderedLabel(Color.lightGray);
        split4.add(this.colWidthsLeft);
        this.colWidthsMid = new BorderedLabel(Color.lightGray);
        split4.add(this.colWidthsMid);
        this.colWidthsRight = new BorderedLabel(Color.lightGray);
        split4.add(this.colWidthsRight);
        buttons.add(split4);
        Panel split5 = new Panel(new GridLayout(1, 2));
        split5.add(new Label("total ", 2));
        this.totalColWidths = new BorderedLabel(Color.lightGray);
        split5.add(this.totalColWidths);
        buttons.add(split5);
        buttons.add(new Label());
        buttons.add(new Label("  Rows  : weightY", 1));
        Panel split6 = new Panel(new GridLayout(1, 3));
        this.rowWeightsLeft = new BorderedLabel(Color.lightGray);
        split6.add(this.rowWeightsLeft);
        this.rowWeightsMid = new BorderedLabel(Color.lightGray);
        split6.add(this.rowWeightsMid);
        this.rowWeightsRight = new BorderedLabel(Color.lightGray);
        split6.add(this.rowWeightsRight);
        buttons.add(split6);
        buttons.add(new Label("heights / free heights  ", 1));
        Panel split7 = new Panel(new GridLayout(1, 3));
        this.rowHeightsLeft = new BorderedLabel(Color.lightGray);
        split7.add(this.rowHeightsLeft);
        this.rowHeightsMid = new BorderedLabel(Color.lightGray);
        split7.add(this.rowHeightsMid);
        this.rowHeightsRight = new BorderedLabel(Color.lightGray);
        split7.add(this.rowHeightsRight);
        buttons.add(split7);
        Panel split8 = new Panel(new GridLayout(1, 2));
        split8.add(new Label("total ", 2));
        this.totalRowHeights = new BorderedLabel(Color.lightGray);
        split8.add(this.totalRowHeights);
        buttons.add(split8);
        return buttons;
    }

    protected Panel buildTopPanel() {
        Panel top = new Panel(new GridLayout(1, 3));
        top.add(new Label("element : ", 2));
        this.number = new BorderedLabel(Color.lightGray);
        top.add(this.number);
        top.add(new Label());
        return top;
    }

    protected Panel buildWeightsPanel() {
        Panel weights = new Panel(new GridLayout(2, 3));
        weights.add(new Label("Element: weightX : ", 2));
        this.weightX = new BorderedLabel(Color.white);
        weights.add(this.weightX);
        Panel split1 = new Panel(new GridLayout(1, 2));
        this.increaseX = new Button("+");
        this.increaseX.addActionListener(this);
        split1.add(this.increaseX);
        this.decreaseX = new Button("-");
        this.decreaseX.addActionListener(this);
        split1.add(this.decreaseX);
        weights.add(split1);
        weights.add(new Label("weightY : ", 2));
        this.weightY = new BorderedLabel(Color.white);
        weights.add(this.weightY);
        Panel split2 = new Panel(new GridLayout(1, 2));
        this.increaseY = new Button("+");
        this.increaseY.addActionListener(this);
        split2.add(this.increaseY);
        this.decreaseY = new Button("-");
        this.decreaseY.addActionListener(this);
        split2.add(this.decreaseY);
        weights.add(split2);
        return weights;
    }

    public void actionPerformed(ActionEvent evt) {
        Button source = (Button)evt.getSource();
        boolean succeeded = false;
        if (source == this.increaseX) {
            this.UpdateComponent(this.currentElement, 0.5, 0.0);
        } else if (source == this.decreaseX) {
            this.UpdateComponent(this.currentElement, -0.5, 0.0);
        } else if (source == this.increaseY) {
            this.UpdateComponent(this.currentElement, 0.0, 0.5);
        } else if (source == this.decreaseY) {
            this.UpdateComponent(this.currentElement, 0.0, -0.5);
        }
    }

    public void displayData(FillComponent target) {
        int[][] dimensions;
        GridBagLayout gbl = (GridBagLayout)this.testPanel.getLayout();
        GridBagConstraints gbc = gbl.getConstraints(target);
        this.number.setText(target.getName());
        this.weightX.setText(gbc.weightx);
        this.weightY.setText(gbc.weighty);
        GridBagLayout toscan = (GridBagLayout)this.testPanel.getLayout();
        double[][] weights = toscan.getLayoutWeights();
        if (weights[0].length >= 3 && weights[1].length >= 3) {
            this.colWeightsLeft.setText(weights[0][0]);
            this.colWeightsMid.setText(weights[0][1]);
            this.colWeightsRight.setText(weights[0][2]);
            this.rowWeightsLeft.setText(weights[1][0]);
            this.rowWeightsMid.setText(weights[1][1]);
            this.rowWeightsRight.setText(weights[1][2]);
        }
        if ((dimensions = toscan.getLayoutDimensions())[0].length >= 3 && dimensions[1].length >= 3) {
            this.colWidthsLeft.setText(dimensions[0][0], dimensions[0][0] - 20);
            this.colWidthsMid.setText(dimensions[0][1], dimensions[0][1] - 20);
            this.colWidthsRight.setText(dimensions[0][2], dimensions[0][2] - 20);
            this.rowHeightsLeft.setText(dimensions[1][0], dimensions[1][0] - 20);
            this.rowHeightsMid.setText(dimensions[1][1], dimensions[1][1] - 20);
            this.rowHeightsRight.setText(dimensions[1][2], dimensions[1][2] - 20);
        }
        Dimension panelsize = this.testPanel.getSize();
        if (panelsize.width > 0 && panelsize.height > 0) {
            this.totalColWidths.setText(panelsize.width, panelsize.width - 60);
            this.totalRowHeights.setText(panelsize.height, panelsize.height - 60);
        }
    }

    public void UpdateComponent(FillComponent target, double dx, double dy) {
        GridBagLayout gbl = (GridBagLayout)this.testPanel.getLayout();
        GridBagConstraints gbc = gbl.getConstraints(target);
        gbc.weightx += dx;
        gbc.weighty += dy;
        if (gbc.weightx >= 0.0 && gbc.weighty >= 0.0) {
            gbl.setConstraints(target, gbc);
            this.testPanel.invalidate();
            this.testPanel.validate();
            this.displayData(target);
        }
    }

    public String getHelpText() {
        return "A GridBagLayout test on the GridBag size calculation by weight:\nThe screen shows a central panel with 3x3 elements ranged using a GridBagLayout. Each element has a central square of20 x 20 pixels that shows its preferred size. \nYou can click an element to select it. The selected element will change color and displayed in the right panel. will appear its name, and weightX, weightY settings\nUsing the (+) and (-) buttons on the left panel you can change the preferred weights of the selected element. This forces the layout to change size. \n\nITEMS TO TEST:\n\n-> Overall grid weights: in the bottom area area watch the weightX and weightY of the selected element Compare to the overall weightX and weightY for the rows and columns and check that the overall weight is equal to the biggest value for the weights of all elements in that row/colomn.\n-> Division of the free widths: also regard the total width of each gridbag column and the 'free' width after subtracting the (uniform) element width and check that the total leftover width is devided amongst the columns proportional to their column weightX.\n-> Division of the free heights: just like above regard the total heights and free heights of each row and make sure that the leftover height is devided amongst the rows proportional to their row weightY.";
    }

    public void start(Panel p, boolean b) {
        this.currentElement.repaint();
        this.displayData(this.currentElement);
    }

    public void stop(Panel p) {
    }

    class FillComponent
    extends Component {
        private Dimension bounds;
        private Rectangle innerRect;
        private int middle;
        private String name;
        private Color background;
        private Color foreground;
        private boolean inversed;

        public FillComponent(String parent, Color fore, Color back) {
            this(parent, fore, back, 20, 20);
        }

        public FillComponent(String parent, Color fore, Color back, int w, int h) {
            this.foreground = fore;
            this.background = back;
            this.inversed = false;
            this.name = parent;
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ FillComponent this$1;
                {
                    this.this$1 = this$1;
                }

                public void mousePressed(MouseEvent evt) {
                    FillComponent.access$300((FillComponent)this.this$1).currentElement.inverse(false);
                    FillComponent.access$300((FillComponent)this.this$1).currentElement = (FillComponent)evt.getSource();
                    FillComponent.access$300(this.this$1).displayData(FillComponent.access$300((FillComponent)this.this$1).currentElement);
                    this.this$1.inverse(true);
                }
            });
            this.bounds = new Dimension();
            this.innerRect = new Rectangle(0, 0, w, h);
        }

        public String getName() {
            return this.name;
        }

        public void inverse(boolean newvalue) {
            this.inversed = newvalue;
            this.repaint();
        }

        public void setSize(int w, int h) {
            this.innerRect = new Rectangle(0, 0, w, h);
            this.repaint();
        }

        public boolean updateSize(int dx, int dy) {
            boolean allowed = true;
            if (this.innerRect.width + dx > 0) {
                this.innerRect.width += dx;
            } else {
                allowed = false;
            }
            if (this.innerRect.height + dy > 0) {
                this.innerRect.height += dy;
            } else {
                allowed = false;
            }
            this.repaint();
            return allowed;
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.innerRect.width, this.innerRect.height);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.innerRect.width, this.innerRect.height);
        }

        public Dimension getActualSize() {
            return this.bounds;
        }

        public void paint(Graphics g) {
            this.update(g);
        }

        public void update(Graphics g) {
            this.bounds.setSize(this.getSize());
            this.innerRect.setLocation((this.bounds.width - this.innerRect.width) / 2, (this.bounds.height - this.innerRect.height) / 2);
            g.setColor(this.inversed ? this.foreground : this.background);
            g.fillRect(0, 0, this.bounds.width - 1, this.bounds.height - 1);
            g.setColor(this.inversed ? this.background : this.foreground);
            g.drawRect(this.innerRect.x + 2, this.innerRect.y + 2, this.innerRect.width - 5, this.innerRect.height - 5);
            g.drawRect(this.innerRect.x, this.innerRect.y, this.innerRect.width - 1, this.innerRect.height - 1);
            g.drawLine(this.innerRect.x, this.innerRect.y, this.innerRect.x + this.innerRect.width - 1, this.innerRect.y + this.innerRect.height - 1);
            g.drawLine(this.innerRect.x, this.innerRect.y + this.innerRect.height - 1, this.innerRect.x + this.innerRect.width - 1, this.innerRect.y);
        }

        static /* synthetic */ GridBagWeights access$300(FillComponent x0) {
            return x0.GridBagWeights.this;
        }
    }

    class BorderedLabel
    extends Component {
        private String text;
        private Color background;
        private Color foreground;

        public BorderedLabel() {
            this.text = "";
        }

        public BorderedLabel(Color backcolor) {
            this.setBackground(backcolor);
            this.text = "";
        }

        public BorderedLabel(Color textcolor, Color backcolor) {
            this.setBackground(backcolor);
            this.setForeground(textcolor);
            this.text = "";
        }

        private void setText(String newtext) {
            this.text = newtext;
            this.repaint();
        }

        private void setText(int newvalue) {
            this.text = Integer.toString(newvalue);
            this.repaint();
        }

        private void setText(double newvalue) {
            this.text = Double.toString(newvalue);
            this.repaint();
        }

        private void setText(int value1, int value2) {
            this.text = value1 + " (" + value2 + ")";
            this.repaint();
        }

        public Dimension getMinimumSize() {
            return new Dimension(40, 12);
        }

        public Dimension getPreferredSize() {
            return new Dimension(40, 12);
        }

        public void paint(Graphics g) {
            this.update(g);
        }

        public void update(Graphics g) {
            Dimension d = this.getSize();
            g.clearRect(1, 1, d.width - 2, d.height - 2);
            g.setColor(this.getForeground());
            g.drawRect(1, 1, d.width - 2, d.height - 2);
            g.drawString(this.text, 5, d.height / 2 + 3);
        }
    }
}

