/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Graphics;

import com.acunia.wonka.test.awt.VisualTestImpl;
import com.acunia.wonka.test.awt.VisualTester;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class DrawStringClipped
extends VisualTestImpl
implements ActionListener {
    MyButton but;
    MyPanel pan;
    MyImagePanel im;

    public DrawStringClipped() {
        this.setLayout(new GridLayout(3, 1));
        this.pan = new MyPanel("Panel", "Tropical");
        this.but = new MyButton("Component", "Acunia");
        this.im = new MyImagePanel("Image", "Cuba Libre");
        this.but.addActionListener(this);
        this.add(this.pan);
        this.add(this.but);
        this.add(this.im);
    }

    public void actionPerformed(ActionEvent evt) {
        this.pan.repaint();
        this.im.repaint();
        this.but.repaint();
    }

    public String getHelpText() {
        return "A successful test looks like this: the screen is divided vertically in three areas of equal size. The upper area is painted orange, has black label \"Canvas\" and represents a panel or container which usually is the basis for a GUI. The second area is painted white, has black label \"Component\" and represents a customized button. The third area is painted blue, has black label \"Image\" and represents an off-screen buffer. Whenever one clicks on the central area, the button, colored strings are drawn on the three areas at random coordinates, which may be outside the three visible areas. As a consequence the strings may disappear partly or completely. The strings are clipped on the borders of each area. No parts of the strings should be visible outside the borders of each area.";
    }

    public Panel getPanel(VisualTester vt) {
        return this;
    }

    public void start(Panel p, boolean b) {
    }

    public void stop(Panel p) {
    }

    class MyImagePanel
    extends Panel {
        String label;
        String title;
        int labelWidth = 0;
        Font f1;
        Font f2;
        int f2Ascent = 0;
        Color c1 = Color.black;
        Color c2 = Color.yellow;
        Color backC;
        Image backBuffer = null;
        Graphics backG = null;

        public MyImagePanel(String myLabel, String myTitle) {
            this.label = myLabel;
            this.title = myTitle;
            this.backC = new Color(0, 160, 255);
            this.f1 = new Font("helvB14", 1, 18);
            this.f2 = new Font("helvB24", 1, 30);
        }

        public void update(Graphics g) {
            this.paint(g);
        }

        public void paint(Graphics g) {
            int w = this.getSize().width;
            int h = this.getSize().height;
            if (this.labelWidth == 0 || this.f2Ascent == 0) {
                this.labelWidth = g.getFontMetrics(this.f1).stringWidth(this.label);
                this.f2Ascent = g.getFontMetrics(this.f2).getAscent();
            }
            try {
                if (this.backBuffer == null || this.backBuffer.getWidth(null) != w || this.backBuffer.getHeight(null) != h) {
                    this.backBuffer = this.createImage(w, h);
                    if (this.backBuffer != null) {
                        this.backG = this.backBuffer.getGraphics();
                    }
                }
                if (this.backBuffer != null) {
                    this.backG.setColor(this.backC);
                    this.backG.fillRect(0, 0, w, h);
                    this.backG.setColor(this.c1);
                    this.backG.setFont(this.f1);
                    this.backG.drawString(this.label, (w - this.labelWidth) / 2, h / 2);
                    this.backG.setColor(this.c2);
                    this.backG.setFont(this.f2);
                    this.backG.drawString(this.title, (int)(Math.floor(Math.random() * (double)w * 1.33) - (double)(w / 3)), (int)(Math.floor(Math.random() * (double)h * 1.2) - (double)(h / 5) + (double)this.f2Ascent));
                }
                g.drawImage(this.backBuffer, 0, 0, null);
            }
            catch (Throwable t) {
                System.out.println("caught unwanted Exception " + t.toString());
                t.printStackTrace();
            }
        }
    }

    class MyPanel
    extends Panel {
        String label;
        String title;
        int labelWidth = 0;
        Font f1;
        Font f2;
        int f2Ascent = 0;

        public MyPanel(String myLabel, String myTitle) {
            this.label = myLabel;
            this.title = myTitle;
            this.setBackground(new Color(255, 160, 0));
            this.f1 = new Font("helvB14", 1, 18);
            this.f2 = new Font("helvB24", 1, 30);
            this.setFont(this.f1);
        }

        public void paint(Graphics g) {
            Dimension d = this.getSize();
            if (this.labelWidth == 0 || this.f2Ascent == 0) {
                this.labelWidth = g.getFontMetrics(this.f1).stringWidth(this.label);
                this.f2Ascent = g.getFontMetrics(this.f2).getAscent();
            }
            g.drawString(this.label, (d.width - this.labelWidth) / 2, d.height / 2);
            g.setFont(this.f2);
            g.setColor(Color.green);
            g.drawString(this.title, (int)(Math.floor(Math.random() * (double)d.width * 1.33) - (double)(d.width / 3)), (int)(Math.floor(Math.random() * (double)d.height * 1.2) - (double)(d.height / 5) + (double)this.f2Ascent));
        }
    }

    class MyButton
    extends Button {
        String title;
        Font f1;
        Font f2;
        Color c1;
        int f2Ascent;

        public MyButton(String myLabel, String myTitle) {
            super(myLabel);
            this.title = myTitle;
            this.setBackground(Color.white);
            this.f1 = new Font("helvB14", 1, 18);
            this.f2 = new Font("helvB24", 1, 30);
            this.setFont(this.f1);
            this.c1 = new Color(200, 40, 70);
        }

        public void paint(Graphics g) {
            Dimension d = this.getSize();
            if (this.f2Ascent == 0) {
                this.f2Ascent = g.getFontMetrics(this.f2).getAscent();
            }
            g.setColor(this.c1);
            g.setFont(this.f2);
            g.drawString(this.title, (int)(Math.floor(Math.random() * (double)d.width * 1.33) - (double)(d.width / 3)), (int)(Math.floor(Math.random() * (double)d.height * 1.2) - (double)(d.height / 5) + (double)this.f2Ascent));
        }
    }
}

