/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Graphics;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DrawString2
extends VisualTestImpl
implements ActionListener {
    Panel flowtop;
    Panel card;
    Panel flowbot;
    String s1;
    String s2;
    String s3;
    String s4;
    String s5;
    SubPanel spanel;
    Label lblL;
    Label lblC;
    Label lblR;
    Button but;
    Checkbox chkb;
    List lst;
    TextField tf;
    TextArea ta;

    void addComp(String label, Component c) {
        Button b = new Button(label);
        this.card.add(c, label);
        this.flowtop.add(b);
        b.addActionListener(this);
    }

    void addComp2(String label) {
        Button b = new Button(label);
        this.flowbot.add(b);
        b.addActionListener(this);
    }

    public void actionPerformed(ActionEvent evt) {
        String arg = evt.getActionCommand();
        if (arg.startsWith("String")) {
            if (arg.equals("String1")) {
                this.setText(this.s1);
            } else if (arg.equals("String2")) {
                this.setText(this.s2);
            } else if (arg.equals("String3")) {
                this.setText(this.s3);
            } else if (arg.equals("String4")) {
                this.setText(this.s4);
            } else if (arg.equals("String5")) {
                this.setText(this.s5);
            }
        } else {
            CardLayout l = (CardLayout)this.card.getLayout();
            l.show(this.card, arg);
        }
    }

    public void setText(String s) {
        this.spanel.setText(s);
        this.lblL.setText(s);
        this.lblC.setText(s);
        this.lblR.setText(s);
        this.but.setLabel(s);
        this.chkb.setLabel(s);
        this.lst.remove(5);
        this.lst.add(s, 5);
        this.tf.setText(s);
        this.ta.setText(s);
        this.validate();
    }

    public String getHelpText() {
        return "This test tests Graphics.drawString() for drawing on all kind of components. On top of the screen a row of buttons, drawn in light-blue, allows you to select a type of component to draw to. The center of the screen, drawn in blue, shows the component you selected with some text on it. At the bottom of the screen, a row of buttons, drawn in light-blue, allows you to change the string to be drawn on the component. You can choose between 1) a short string that fits on every component, 2) a medium sized string that will not fit on some components. 3) a long string that fits on no component, except on the TextArea which is able to interpret the line feeds in the string and cut the string in lines accordingly. 4) a long string like the former, but without line feeds, which consequently does not even fit on the TextArea. 5) A medium sized string containing many undefined characters. The test is successful if, 1) the Panel and TextArea show all strings in their top left corner; 2) in Label-L, Label-C, Label-R, Button, Checkbox and TextField, the strings are vertically centered, and left aligned, except in Label-C and Button, where strings are horizontally centered, and in Label-R where the string is right aligned; 3) in List the strings appear left aligned on the sixth line (lines 1 to 5 show planet names);3) if string1 fits on all components, 4) if string2 is almost visible on all components, 5) if string3 is only partly visible and shows litle rectangles in some positions, indicating unrecognized characters, except for the TextArea which recognizes these characters as tabs and new-lines, 6) if string4 is only partly visible on all components, 7) if string5 is almost completely visible and shows many unrecognised characters on all components\n\nRemark buggy behaviour: all components initially should inherit the size 17 Helvetica font of the central Panel with Card Layout. The TextArea cannot do that (yet)!";
    }

    public void start(Panel p, boolean b) {
    }

    public void stop(Panel p) {
    }

    private final /* synthetic */ void this() {
        this.flowtop = new Panel();
        this.card = new Panel();
        this.flowbot = new Panel();
        this.s1 = "Short string";
        this.s2 = "This medium size string should be partly invisible only ";
        this.s3 = "This long string tells\tthe story\nof Snow-White and the seven\ndwarves. It contains\tsome tab\nand new line characters. ";
        this.s4 = "This long string also tells the story of Snow-White and the seven dwarves, but it contains no special characters. ";
        this.s5 = "String \u0001wit\u0005h \bma\fny \u0010unde\u0014fined \u0018char\u001bacters. ";
        this.spanel = new SubPanel(this.s1);
        this.lblL = new Label(this.s1, 0);
        this.lblC = new Label(this.s1, 1);
        this.lblR = new Label(this.s1, 2);
        this.but = new Button(this.s1);
        this.chkb = new Checkbox(this.s1);
        this.lst = new List();
        this.tf = new TextField(this.s1);
        this.ta = new TextArea(this.s1);
    }

    public DrawString2() {
        this.this();
        this.setLayout(new BorderLayout());
        this.flowtop.setLayout(new FlowLayout(1, 0, 0));
        this.flowtop.setBackground(new Color(0, 200, 255));
        this.card.setLayout(new CardLayout());
        this.card.setForeground(Color.white);
        this.card.setBackground(new Color(0, 150, 255));
        this.card.setFont(new Font("helvR17", 0, 17));
        this.flowbot.setLayout(new FlowLayout());
        this.flowbot.setBackground(new Color(0, 200, 255));
        this.lst.add("Mercury");
        this.lst.add("Venus");
        this.lst.add("Earth");
        this.lst.add("Mars");
        this.lst.add("Planetoids");
        this.lst.add(this.s1);
        this.addComp("Panel", this.spanel);
        this.addComp("Label-L", this.lblL);
        this.addComp("Label-C", this.lblC);
        this.addComp("Label-R", this.lblR);
        this.addComp("Button", this.but);
        this.addComp("Checkbox", this.chkb);
        this.addComp("List", this.lst);
        this.addComp("TextField", this.tf);
        this.addComp("TextArea", this.ta);
        this.addComp2("String1");
        this.addComp2("String2");
        this.addComp2("String3");
        this.addComp2("String4");
        this.addComp2("String5");
        this.add((Component)this.flowtop, "North");
        this.add((Component)this.card, "Center");
        this.add((Component)this.flowbot, "South");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class SubPanel
    extends Panel {
        String slocal;

        public void setText(String s) {
            this.slocal = s;
            super.repaint();
        }

        public int paintOne(Graphics g, String s, Font f, int x, int y) {
            g.setFont(f);
            FontMetrics fm = g.getFontMetrics();
            g.drawString(s, x, y + fm.getLeading() + fm.getAscent());
            return fm.getHeight();
        }

        public void paint(Graphics g) {
            int fh = 0;
            int y = 0;
            y += fh;
            fh = this.paintOne(g, this.slocal, new Font("helvR17", 0, 17), 10, y);
        }

        public SubPanel(String s) {
            this.slocal = s;
        }
    }
}

