/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Graphics;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Panel;

public class DrawString
extends VisualTestImpl {
    public int test(Graphics g, String s, Font f, int x, int y, Color rectColor) {
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics();
        g.setColor(rectColor);
        g.drawRect(x, y, fm.stringWidth(s), fm.getHeight());
        g.setColor(Color.black);
        g.drawLine(x, y + fm.getMaxAscent() + 1, x + fm.stringWidth(s), y + fm.getMaxAscent() + 1);
        g.setColor(Color.blue);
        g.drawString(s, x, y + fm.getMaxAscent() + 1);
        return fm.getHeight() + 1;
    }

    public void paint(Graphics g) {
        String s = "abc-def-ghi-jkl-mno-pqr";
        int fh = 0;
        int y = 0;
        fh = this.test(g, s, new Font("helvR08", 0, 8), 10, y, Color.red);
        y += fh;
        fh = this.test(g, s, new Font("helvR14", 0, 14), 10, y, Color.white);
        y += fh;
        fh = this.test(g, s, new Font("helvR20", 0, 20), 10, y, Color.red);
        g.setColor(Color.white);
        g.drawRect(10, y += fh, 200, 15);
        fh = this.test(g, s, new Font("courR10", 0, 10), 10, y += 16, Color.red);
        y += fh;
        fh = this.test(g, s, new Font("courR14", 0, 14), 10, y, Color.white);
        y += fh;
        fh = this.test(g, s, new Font("courR17", 0, 17), 10, y, Color.red);
        y += fh;
        fh = this.test(g, s, new Font("courR24", 0, 24), 10, y, Color.white);
        g.setColor(Color.red);
        g.drawRect(10, y += fh, 200, 15);
        fh = this.test(g, s, new Font("helvB20", 1, 20), 10, y += 16, Color.white);
    }

    public static void main(String[] args) {
        new DrawString();
    }

    public String getHelpText() {
        return "This test tests Graphics.drawString() in combination with Graphics.setFont() and Graphics.getFontMetrics(). A string is shown in different fonts, surrounded by alternating red and white rectangles of heights equal to the fonts' heights. The top three 'Helvetica' fonts are separated by a white rectangle from next four 'Courier' fonts. These four fonts are separated from the last 'bold' 'Helvetica' font by a red rectangle. The fonts' baselines are drawn in black. The test is successful 1) if and only if the characters' ascents and descents do not span beyond and not even overlap the bounding box, 2) if the baseline occupies pixel locations exactly below bottom pixels of letters 'a', 'b', 'c', 'd', 'e' and 'f', 3) if the baseline does not span beyond the bounding box and 4) if the string to be drawn in the bottom white box is visible (is considered inside its bounding box).";
    }

    public void start(Panel p, boolean b) {
    }

    public void stop(Panel p) {
    }
}

