/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Graphics.ClickButton;

import com.acunia.wonka.test.awt.Graphics.ClickButton.ClickButtonEvent;
import com.acunia.wonka.test.awt.Graphics.ClickButton.ClickButtonListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

public class ClickButton
extends Panel
implements MouseListener {
    protected String value;
    protected int status;
    private Color shadowUp;
    private Color shadowDown;
    private int indent = 0;
    private Image imageUp = null;
    private Image imageDown = null;
    private Vector listeners;
    private int align;
    public static final int STATUS_DISABLED = 0;
    public static final int STATUS_DOWN = 1;
    public static final int STATUS_UP = 2;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_LEFT = 2;
    public static final int ALIGN_RIGHT = 3;

    public ClickButton(String value) {
        this(value, Color.green, Color.orange);
    }

    public ClickButton(String value, Color b, Color f) {
        this.setVisible(false);
        this.value = value;
        this.align = 1;
        this.status = 2;
        this.setBackground(b);
        this.setForeground(f);
        this.shadowUp = new Color(200, 200, 200);
        this.shadowDown = new Color(100, 100, 100);
        this.listeners = new Vector();
        this.addMouseListener(this);
        this.setBounds(0, 0, this.getMinimumSize().width, this.getMinimumSize().height);
        this.setVisible(true);
    }

    public ClickButton(String value, int indent) {
        this(value);
        this.indent = indent;
    }

    public Dimension getMinimumSize() {
        if (this.imageUp != null) {
            return new Dimension(this.imageUp.getWidth(null) + 20, this.imageUp.getHeight(null) + 10);
        }
        return new Dimension(this.value.length() * 12, 40 + this.indent * 4);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getMinimumSize().width, this.getMinimumSize().height);
    }

    protected void processClickButtonEvent() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ClickButtonListener cbl = (ClickButtonListener)this.listeners.elementAt(i);
            cbl.buttonPressed(new ClickButtonEvent(this, this.value));
        }
    }

    public void addListener(ClickButtonListener cbl) {
        this.listeners.addElement(cbl);
    }

    public void removeListener(ClickButtonListener cbl) {
        this.listeners.removeElement(cbl);
    }

    public void paint(Graphics g) {
        switch (this.status) {
            case 0: {
                this.paintDisabled(g);
                break;
            }
            case 1: {
                this.paintDown(g);
                break;
            }
            default: {
                this.paintUp(g);
            }
        }
    }

    public void paintDisabled(Graphics g) {
        this.paintUp(g);
    }

    public void paintUp(Graphics g) {
        if (this.imageUp == null) {
            g.setColor(this.shadowUp);
            g.drawLine(this.indent, this.indent, (int)super.getSize().getWidth() - 1 - this.indent * 2, this.indent);
            g.drawLine(this.indent, this.indent, this.indent, (int)super.getSize().getHeight() - 1 - this.indent * 2);
            g.setColor(this.shadowDown);
            g.drawLine((int)super.getSize().getWidth() - 1 - this.indent * 2, (int)super.getSize().getHeight() - 1 - this.indent * 2, (int)super.getSize().getWidth() - 1 - this.indent * 2, this.indent);
            g.drawLine((int)super.getSize().getWidth() - 1 - this.indent * 2, (int)super.getSize().getHeight() - 1 - this.indent * 2, this.indent, (int)super.getSize().getHeight() - 1 - this.indent * 2);
            g.setColor(this.getForeground());
            g.setFont(new Font("helvR20", 0, 20));
            g.drawString(this.value, (int)(super.getSize().getWidth() - (double)(this.value.length() * 6)) / 2, (int)(super.getSize().getHeight() / 2.0 + 3.0));
        } else {
            g.drawImage(this.imageUp, (this.getWidth() - this.imageUp.getWidth(null)) / 2, (this.getHeight() - this.imageUp.getHeight(null)) / 2, null);
        }
    }

    public void paintDown(Graphics g) {
        if (this.imageDown == null) {
            g.setColor(this.shadowDown);
            g.drawLine(this.indent, this.indent, (int)super.getSize().getWidth() - 1 - this.indent * 2, this.indent);
            g.drawLine(this.indent, this.indent, this.indent, (int)super.getSize().getHeight() - 1 - this.indent * 2);
            g.setColor(this.shadowUp);
            g.drawLine((int)super.getSize().getWidth() - 1 - this.indent * 2, (int)super.getSize().getHeight() - 1 - this.indent * 2, (int)super.getSize().getWidth() - 1 - this.indent * 2, this.indent);
            g.drawLine((int)super.getSize().getWidth() - 1 - this.indent * 2, (int)super.getSize().getHeight() - 1 - this.indent * 2, this.indent, (int)super.getSize().getHeight() - 1 - this.indent * 2);
            g.setColor(this.getForeground());
            g.setFont(new Font("helvB20", 1, 20));
            g.drawString(this.value, (int)(super.getSize().getWidth() - (double)(this.value.length() * 7)) / 2, (int)(super.getSize().getHeight() / 2.0 + 3.0) - 2);
        } else {
            g.drawImage(this.imageDown, (this.getWidth() - this.imageDown.getWidth(null)) / 2, (this.getHeight() - this.imageDown.getHeight(null)) / 2, null);
        }
    }

    public void mousePressed(MouseEvent e) {
        this.buttonPressed();
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        this.buttonReleased();
        this.repaint();
    }

    protected void buttonPressed() {
        if (this.status == 2) {
            this.processClickButtonEvent();
            this.status = 1;
        }
    }

    protected void buttonReleased() {
        if (this.status == 1) {
            this.status = 2;
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void setStatus(int status) {
        this.status = status;
        this.repaint();
    }

    public void setValue(String value) {
        this.value = value;
        this.repaint();
    }

    public String getValue() {
        return this.value;
    }

    public void setImageUp(Image image) {
        this.setBounds(0, 0, this.getMinimumSize().width, this.getMinimumSize().height);
        this.imageUp = image;
        this.repaint();
    }

    public void setImageDown(Image image) {
        this.setBounds(0, 0, this.getMinimumSize().width, this.getMinimumSize().height);
        this.imageDown = image;
        this.repaint();
    }

    public int getStatus() {
        return this.status;
    }
}

