/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Frame;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class FrameShowTest
extends VisualTestImpl
implements ActionListener {
    private static final int STEP = 20;
    private static final int DEPTH = 50;
    private int maxAnchor = -1;
    private Frame redFrame = null;
    private Frame blueFrame = null;
    private Button showRed;
    private Button hideRed;
    private Button frontRed;
    private Button backRed;
    private Button leftRed;
    private Button rightRed;
    private Button showBlue;
    private Button hideBlue;
    private Button frontBlue;
    private Button backBlue;
    private Button leftBlue;
    private Button rightBlue;
    private List display;

    public FrameShowTest() {
        this.setLayout(new BorderLayout());
        this.setBackground(new Color(48, 128, 48));
        this.setForeground(Color.white);
        this.add((Component)new Label("Show, hide, move and bring to front any of the two frames", 1), "North");
        this.display = new List(3, false);
        this.display.add("Dialog outcome dispayed here");
        this.add((Component)this.display, "South");
        Panel buttons = new Panel(new GridLayout(1, 3));
        Panel leftbuttons = new Panel(new GridLayout(7, 1));
        leftbuttons.setBackground(new Color(128, 48, 48));
        Label midlabel = new Label();
        midlabel.setBackground(new Color(192, 192, 128));
        Panel rightbuttons = new Panel(new GridLayout(7, 1));
        rightbuttons.setBackground(new Color(48, 48, 128));
        leftbuttons.add(new Label("Red frame:"));
        rightbuttons.add(new Label("blue frame:"));
        this.showRed = new Button("SHOW frame");
        this.showRed.addActionListener(this);
        leftbuttons.add(this.showRed);
        this.showBlue = new Button("SHOW frame");
        this.showBlue.addActionListener(this);
        rightbuttons.add(this.showBlue);
        this.hideRed = new Button("HIDE frame");
        this.hideRed.addActionListener(this);
        leftbuttons.add(this.hideRed);
        this.hideBlue = new Button("HIDE frame");
        this.hideBlue.addActionListener(this);
        rightbuttons.add(this.hideBlue);
        this.frontRed = new Button("frame to FRONT");
        this.frontRed.addActionListener(this);
        leftbuttons.add(this.frontRed);
        this.frontBlue = new Button("frame to FRONT");
        this.frontBlue.addActionListener(this);
        rightbuttons.add(this.frontBlue);
        this.backRed = new Button("frame to BACK");
        this.backRed.addActionListener(this);
        leftbuttons.add(this.backRed);
        this.backBlue = new Button("frame to BACK");
        this.backBlue.addActionListener(this);
        rightbuttons.add(this.backBlue);
        this.leftRed = new Button("move frame LEFT");
        this.leftRed.addActionListener(this);
        leftbuttons.add(this.leftRed);
        this.leftBlue = new Button("move frame LEFT");
        this.leftBlue.addActionListener(this);
        rightbuttons.add(this.leftBlue);
        this.rightRed = new Button("move frame RIGHT");
        this.rightRed.addActionListener(this);
        leftbuttons.add(this.rightRed);
        this.rightBlue = new Button("move frame RIGHT");
        this.rightBlue.addActionListener(this);
        rightbuttons.add(this.rightBlue);
        buttons.add(leftbuttons);
        buttons.add(midlabel);
        buttons.add(rightbuttons);
        this.add((Component)buttons, "Center");
    }

    public void actionPerformed(ActionEvent evt) {
        Component source = (Component)evt.getSource();
        if (source == this.showRed) {
            if (this.checkRed()) {
                this.redFrame.show();
                this.displayText("Red frame shown");
            }
        } else if (source == this.showBlue) {
            if (this.checkblue()) {
                this.blueFrame.show();
                this.displayText("blue frame shown");
            }
        } else if (source == this.hideRed) {
            if (this.checkRed()) {
                this.redFrame.setVisible(false);
                this.displayText("Red frame hidden");
            }
        } else if (source == this.hideBlue) {
            if (this.checkblue()) {
                this.blueFrame.setVisible(false);
                this.displayText("blue frame hidden");
            }
        } else if (source == this.frontRed) {
            if (this.checkRed()) {
                this.redFrame.toFront();
                this.displayText("Red frame to front");
            }
        } else if (source == this.frontBlue) {
            if (this.checkblue()) {
                this.blueFrame.toFront();
                this.displayText("blue frame to front");
            }
        } else if (source == this.backRed) {
            if (this.checkRed()) {
                this.redFrame.toBack();
                this.displayText("Red frame to back");
            }
        } else if (source == this.backBlue) {
            if (this.checkblue()) {
                this.blueFrame.toBack();
                this.displayText("blue frame to back");
            }
        } else if (source == this.leftRed) {
            int anchor = this.redFrame.getX();
            if (this.checkRed() && anchor > 20) {
                this.redFrame.setLocation(anchor -= 20, 50);
                this.displayText("Red frame moved left to (" + anchor + ", " + 50 + ")");
            }
        } else if (source == this.leftBlue) {
            int anchor = this.blueFrame.getX();
            if (this.checkblue() && anchor > 20) {
                this.blueFrame.setLocation(anchor -= 20, 50);
                this.displayText("blue frame moved left to (" + anchor + ", " + 50 + ")");
            }
        } else if (source == this.rightRed) {
            int anchor = this.redFrame.getX();
            if (this.checkRed() && anchor < this.maxAnchor - 20) {
                this.redFrame.setLocation(anchor += 20, 50);
                this.displayText("Red frame moved right to (" + anchor + ", " + 50 + ")");
            }
        } else if (source == this.rightBlue) {
            int anchor = this.blueFrame.getX();
            if (this.checkblue() && anchor < this.maxAnchor - 20) {
                this.blueFrame.setLocation(anchor += 20, 50);
                this.displayText("blue frame moved right to (" + anchor + ", " + 50 + ")");
            }
        }
    }

    private void displayText(String text) {
        if (this.display.getItemCount() > 40) {
            this.display.removeAll();
        }
        this.display.add(text, 0);
        System.out.println(text);
    }

    private boolean checkRed() {
        this.displayText("Checking red frame: " + this.redFrame);
        Frame vtframe = this.vt.getFrame();
        if (vtframe == null) {
            this.displayText("Skipped command for vt.getFrame() not available yet");
            return false;
        }
        if (this.redFrame == null) {
            this.redFrame = new Frame("Red Frame");
            this.redFrame.setLayout(new GridLayout(5, 3));
            this.redFrame.setBackground(Color.red);
            this.redFrame.setForeground(Color.white);
            this.redFrame.add(new Label("The Beatles", 2));
            this.redFrame.add(new Label());
            this.redFrame.add(new Label());
            this.redFrame.add(new Label());
            this.redFrame.add(new Label("the", 1));
            this.redFrame.add(new Label());
            this.redFrame.add(new Label());
            this.redFrame.add(new Label("R E D", 1));
            this.redFrame.add(new Label());
            this.redFrame.add(new Label());
            this.redFrame.add(new Label("album", 1));
            this.redFrame.add(new Label());
            this.redFrame.pack();
            int max = this.getSize().width - this.redFrame.getSize().width;
            if (this.maxAnchor < 0 || max < this.maxAnchor) {
                this.maxAnchor = max;
            }
            this.redFrame.setLocation(max / 2, 50);
            this.displayText("Build Red frame " + this.redFrame);
            return true;
        }
        return true;
    }

    private boolean checkblue() {
        this.displayText("Checking blue frame: " + this.blueFrame);
        Frame vtframe = this.vt.getFrame();
        if (vtframe == null) {
            this.displayText("Skipped command for vt.getFrame() not available yet");
            return false;
        }
        if (this.blueFrame == null) {
            this.blueFrame = new Frame("blue frame");
            this.blueFrame.setLayout(new GridLayout(5, 3));
            this.blueFrame.setBackground(Color.blue);
            this.blueFrame.setForeground(Color.white);
            this.blueFrame.add(new Label("The Beatles", 2));
            this.blueFrame.add(new Label());
            this.blueFrame.add(new Label());
            this.blueFrame.add(new Label());
            this.blueFrame.add(new Label("the", 1));
            this.blueFrame.add(new Label());
            this.blueFrame.add(new Label());
            this.blueFrame.add(new Label("B L U E", 1));
            this.blueFrame.add(new Label());
            this.blueFrame.add(new Label());
            this.blueFrame.add(new Label("album", 1));
            this.blueFrame.add(new Label());
            this.blueFrame.pack();
            int max = this.getSize().width - this.blueFrame.getSize().width;
            if (this.maxAnchor < 0 || max < this.maxAnchor) {
                this.maxAnchor = max;
            }
            this.blueFrame.setLocation(max / 2, 50);
            this.displayText("Build Blue frame " + this.blueFrame);
            return true;
        }
        return true;
    }

    public String getHelpText() {
        return "Test on the construction and behavior of the java.awt.Frame class:\nThe two rows of buttons each\n-> show a frame\n-> hide that frame again\n-> bring that frame to front (on overlapping frames)\n-> bring that frame to back (as the test itself is a frame already, this will hide the window)\n-> move that frame to the left \n-> move that frame to the right \nIn particularly check the correct behavior of the toFront()/toBack() functions (triggered by the buttons of that name)\nand the moving of the frames either using the buttons or by dragging";
    }

    public void stop(Panel p) {
        if (this.redFrame != null) {
            this.redFrame.dispose();
            this.redFrame = null;
        }
        if (this.blueFrame != null) {
            this.blueFrame.dispose();
            this.blueFrame = null;
        }
    }

    public void hideTest() {
        if (this.redFrame != null) {
            this.redFrame.setVisible(false);
        }
        if (this.blueFrame != null) {
            this.blueFrame.setVisible(false);
        }
    }

    public void showTest() {
        if (this.redFrame != null) {
            this.redFrame.setVisible(true);
        }
        if (this.blueFrame != null) {
            this.blueFrame.setVisible(true);
        }
    }

    public static void main(String[] args) {
        new FrameShowTest();
    }
}

