/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Component;

import com.acunia.wonka.test.awt.VisualTestImpl;
import com.acunia.wonka.test.awt.VisualTester;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;

public class CreateImage
extends VisualTestImpl {
    public Panel getPanel(VisualTester vte) {
        this.vt = vte;
        return new MainCanvas();
    }

    public String getHelpText() {
        return "You should see a background coloured in 'acunia-red'. On the foreground, a string \"ACUNIA\", in color white, in font Helvetica-bold-34, should be visible. The String should be moved upward, disappear piece by piece at the top of the screen, meanwhile reappearing at the bottom of the screen. At the same time light-blue and dark-blue colored circles are moving from bottom to top aswell. They should be moving faster than the string.";
    }

    public void start(Panel p, boolean autorun) {
        try {
            new Thread((Runnable)((MainCanvas)p), "CreateImage thread").start();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void stop(Panel p) {
        try {
            ((MainCanvas)p).stop = true;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    class MainCanvas
    extends Panel
    implements Runnable {
        public boolean stop = false;
        Image backBuffer = null;
        Graphics backG = null;
        String str = "ACUNIA";
        int pointSize = 25;
        Point[] points = new Point[10];
        int[] pointRates = new int[this.points.length];
        Point stringPt = new Point(0, 0);
        int ascent = 0;

        MainCanvas() {
            for (int i = 0; i < this.points.length; ++i) {
                this.points[i] = new Point(0, 0);
                this.initPoint(i);
            }
        }

        void initPoint(int i) {
            this.points[i].x = (int)Math.floor(Math.random() * (double)this.getSize().width);
            this.points[i].y = this.getSize().height;
            this.pointRates[i] = (int)Math.floor(Math.random() * 30.0) + 5;
        }

        public void update(Graphics g) {
            this.paint(g);
        }

        public void paint(Graphics g) {
            int w = this.getBounds().width;
            int h = this.getBounds().height;
            try {
                if (this.backBuffer == null || this.backBuffer.getWidth(null) != w || this.backBuffer.getHeight(null) != h) {
                    this.backBuffer = this.createImage(w, h);
                    if (this.backBuffer != null) {
                        this.backG = this.backBuffer.getGraphics();
                        this.backG.setFont(new Font("helvB34", 1, 34));
                        FontMetrics fm = this.backG.getFontMetrics();
                        this.stringPt.x = (w - fm.stringWidth(this.str)) / 2;
                        this.ascent = fm.getAscent();
                    }
                }
                if (this.backBuffer != null) {
                    int i;
                    this.backG.setColor(new Color(200, 40, 70));
                    this.backG.fillRect(0, 0, w, h);
                    this.backG.setColor(Color.cyan);
                    for (i = 0; i < this.points.length / 3; ++i) {
                        if (this.points[i].x <= 0 || this.points[i].x >= w - this.pointSize || this.points[i].y <= 0 || this.points[i].y >= h - this.pointSize) continue;
                        this.backG.drawOval(this.points[i].x, this.points[i].y, this.pointSize, this.pointSize);
                    }
                    this.backG.setColor(Color.white);
                    if (this.stringPt.y % h + h >= 0) {
                        this.backG.drawString(this.str, this.stringPt.x, this.stringPt.y % h + h);
                    }
                    if (this.stringPt.y % h + 2 * h < h + this.ascent) {
                        this.backG.drawString(this.str, this.stringPt.x, this.stringPt.y % h + 2 * h);
                    }
                    this.backG.setColor(Color.blue);
                    for (i = this.points.length / 3; i < this.points.length; ++i) {
                        if (this.points[i].x <= 0 || this.points[i].x >= w - this.pointSize || this.points[i].y <= 0 || this.points[i].y >= h - this.pointSize) continue;
                        this.backG.drawOval(this.points[i].x, this.points[i].y, this.pointSize, this.pointSize);
                    }
                    g.drawImage(this.backBuffer, 0, 0, null);
                }
            }
            catch (Throwable t) {
                System.out.println("caught unwanted Exception " + t.toString());
                t.printStackTrace();
            }
        }

        public void run() {
            int w = 0;
            int h = 0;
            int w0 = 400;
            try {
                while (w == 0 || h == 0 || w != w0) {
                    w0 = w;
                    Thread.sleep(80L);
                    w = this.getBounds().width;
                    h = this.getBounds().height;
                }
                while (!this.stop) {
                    for (int i = 0; i < this.points.length; ++i) {
                        this.points[i].y -= this.pointRates[i];
                        if (this.points[i].y >= -this.pointSize) continue;
                        this.initPoint(i);
                    }
                    --this.stringPt.y;
                    this.repaint();
                    Thread.sleep(80L);
                }
            }
            catch (Throwable t) {
                System.out.println("caught unwanted Exception " + t.toString());
                t.printStackTrace();
            }
        }
    }
}

