/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Component;

import com.acunia.wonka.test.awt.Component.ComponentUpdate;
import com.acunia.wonka.test.awt.Component.PaintComponent;
import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class ComponentUpdateBounds
extends VisualTestImpl
implements ActionListener {
    private InnerComponent innerComponent;
    private InnerPaintComponent paintComponent;
    private InnerBoundsComponent boundsComponent;
    private Button repaintAll;
    private Button repaintBounds;
    private List display;

    public ComponentUpdateBounds() {
        this.setLayout(new BorderLayout());
        this.setBackground(new Color(64, 64, 96));
        this.setForeground(Color.white);
        Panel top = new Panel(new FlowLayout());
        this.repaintAll = new Button("repaint() all");
        this.repaintAll.addActionListener(this);
        top.add(this.repaintAll);
        top.add(new Label("   "));
        this.repaintBounds = new Button("repaint(x,y,w,h) selection");
        this.repaintBounds.addActionListener(this);
        top.add(this.repaintBounds);
        this.add((Component)top, "North");
        this.display = new List(5, false);
        this.display.add("Use your mouse to select an update area in the center panel");
        this.display.add("Press <repaint all> to repaint the left and right screen completely");
        this.display.add("Press <repaint selection> to repaint the selected area");
        this.display.add("  on the left and right screen");
        this.add((Component)this.display, "South");
        Panel components = new Panel(new GridLayout(1, 3));
        this.innerComponent = new InnerComponent();
        components.add(this.innerComponent);
        this.boundsComponent = new InnerBoundsComponent(new Color(96, 96, 144));
        components.add(this.boundsComponent);
        this.paintComponent = new InnerPaintComponent();
        components.add(this.paintComponent);
        this.add((Component)components, "Center");
    }

    public void actionPerformed(ActionEvent evt) {
        this.display.removeAll();
        if (evt.getSource() == this.repaintAll) {
            this.display.add("Sending repaint()-command without bounds for whole screen");
            this.innerComponent.repaint();
            this.paintComponent.repaint();
        } else {
            Rectangle selection = this.boundsComponent.getSelection();
            this.display.add("Sending repaint(bounds) for bounds(" + selection.x + ", " + selection.y + ", " + selection.width + ", " + selection.height + ")");
            this.innerComponent.repaint(selection.x, selection.y, selection.width, selection.height);
            this.paintComponent.repaint(selection.x, selection.y, selection.width, selection.height);
        }
    }

    public String getHelpText() {
        return "A test on passing the boundaries in a Component.repaint(x,y,w,h) command\n The main part of this test are the two central Components. To refresh the content of the components, a paint() and an update() function are implemented, both painting the current clipping bound in a background color and also displaying the number of paints and updates made:\nWith each paint() or update() the background color changes along the colors of the rainbow (red, orange, yellow....) Paint commands display white text on dark colors, update-commands black text on light colors. Like this it is possible to see wether the clipping area is being paint()-ed or update()-ed \n(If the clipping bound is <NULL>, it is being replaced by the complete screen)\n\nThe <repaint()> button sends an empty repaint() command to both components. the <repaint(x,y,w,h)> sends the special form to repaint only a selected area. You can specify the area that has to be overpainted in the center panel using your mouse.\nThere are two display component. One derived from Component, the other from an extern class PaintComponent. For some reason the Sunsdk always sends a call tp paint() to the external PaintComponent, even on a call to repaint() when the inner component receives a call to update()";
    }

    public void main(String[] args) {
        Frame main = new Frame("Component paint test");
        main.setSize(400, 234);
        main.add(new ComponentUpdate());
        main.show();
    }

    class InnerBoundsComponent
    extends Component
    implements MouseListener,
    MouseMotionListener {
        Rectangle frame;
        Rectangle bounds;
        Color background;
        int startX;
        int startY;
        int mouseX;
        int mouseY;

        public InnerBoundsComponent(Color background) {
            this.background = background;
            this.frame = new Rectangle();
            this.bounds = new Rectangle();
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        public void mouseEntered(MouseEvent evt) {
        }

        public void mouseExited(MouseEvent evt) {
        }

        public void mousePressed(MouseEvent evt) {
            this.startX = evt.getX();
            this.startY = evt.getY();
            this.mouseX = this.startX;
            this.mouseY = this.startY;
            this.bounds.setBounds(this.mouseX, this.mouseY, 0, 0);
            this.repaint();
        }

        public void mouseReleased(MouseEvent evt) {
        }

        public void mouseClicked(MouseEvent evt) {
        }

        public void mouseMoved(MouseEvent evt) {
        }

        public void mouseDragged(MouseEvent evt) {
            this.mouseX = evt.getX();
            this.mouseY = evt.getY();
            if (this.mouseX > this.startX) {
                this.bounds.x = this.startX;
                this.bounds.width = this.mouseX - this.startX;
            } else {
                this.bounds.x = this.mouseX;
                this.bounds.width = this.startX - this.mouseX;
            }
            if (this.mouseY > this.startY) {
                this.bounds.y = this.startY;
                this.bounds.height = this.mouseY - this.startY;
            } else {
                this.bounds.y = this.mouseY;
                this.bounds.height = this.startY - this.mouseY;
            }
            this.repaint();
        }

        public Rectangle getSelection() {
            return this.bounds;
        }

        public void paint(Graphics g) {
            this.update(g);
        }

        public void update(Graphics g) {
            if (this.frame.width <= 0) {
                this.frame.setBounds(1, 1, this.getSize().width - 2, this.getSize().height - 2);
                this.bounds.setBounds(this.frame.width / 3, this.frame.height / 3, this.frame.width / 3, this.frame.height / 3);
            }
            g.setColor(this.background);
            g.fillRect(1, 1, this.frame.width, this.frame.height);
            g.setColor(Color.white);
            g.drawRect(1, 1, this.frame.width, this.frame.height);
            g.setColor(Color.red);
            g.drawRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        }
    }

    class InnerComponent
    extends Panel {
        protected Rectangle bounds;
        protected int updateCount = 0;
        protected int paintCount = 0;
        protected Rectangle frameRect = new Rectangle();

        public void paint(Graphics g) {
            ComponentUpdateBounds.this.display.add("Inner class: Received call to paint()");
            ++this.paintCount;
            if (this.paintArea(PaintComponent.DARKCOLORS[(this.paintCount - 1) % PaintComponent.COLORCOUNT], Color.white, g)) {
                ComponentUpdateBounds.this.display.add("Inner class: on paint() calculated sizes");
            }
            ComponentUpdateBounds.this.display.add("Inner class: paint() executed, total paints = " + this.paintCount);
        }

        public void update(Graphics g) {
            ComponentUpdateBounds.this.display.add("Inner class: Received call to update()");
            ++this.updateCount;
            if (this.paintArea(PaintComponent.LIGHTCOLORS[(this.updateCount - 1) % PaintComponent.COLORCOUNT], Color.black, g)) {
                ComponentUpdateBounds.this.display.add("Inner class: on update() calculated sizes");
            }
            ComponentUpdateBounds.this.display.add("Inner class: update() executed, total updates = " + this.updateCount);
        }

        private boolean paintArea(Color background, Color foreground, Graphics g) {
            this.bounds = g.getClipBounds();
            boolean calculated = false;
            if (this.frameRect.width <= 0) {
                this.frameRect.setBounds(0, 0, this.getSize().width, this.getSize().height);
                calculated = true;
            }
            if (this.bounds == null) {
                this.bounds = this.frameRect;
                ComponentUpdateBounds.this.display.add("NULL bounds: Reverting to full screen (0, 0, " + this.bounds.width + ", " + this.bounds.height + ")");
            } else {
                ComponentUpdateBounds.this.display.add("bounds (" + this.bounds.x + ", " + this.bounds.y + ", " + this.bounds.width + ", " + this.bounds.height + ")");
            }
            g.setColor(background);
            g.fillRect(5, 5, this.frameRect.width - 10, this.frameRect.height - 10);
            g.setColor(foreground);
            g.drawString("inner Component:", 10, 20);
            g.drawString("updates " + this.updateCount, 10, 35);
            g.drawString("paints = " + this.paintCount, 10, 50);
            return calculated;
        }
    }

    class InnerPaintComponent
    extends PaintComponent {
        private Rectangle bounds;

        public InnerPaintComponent() {
            super("extern PaintComponent", ComponentUpdateBounds.this.display);
        }

        protected boolean paintArea(Color background, Color foreground, Graphics g) {
            this.bounds = g.getClipBounds();
            boolean calculated = false;
            if (this.frameRect.width <= 0) {
                this.frameRect.setBounds(0, 0, this.getSize().width, this.getSize().height);
                calculated = true;
            }
            if (this.bounds == null) {
                this.bounds = this.frameRect;
                ComponentUpdateBounds.this.display.add("NULL bounds: Reverting to full screen (0, 0, " + this.bounds.width + ", " + this.bounds.height + ")");
            } else {
                ComponentUpdateBounds.this.display.add("bounds (" + this.bounds.x + ", " + this.bounds.y + ", " + this.bounds.width + ", " + this.bounds.height + ")");
            }
            g.setColor(background);
            g.fillRect(5, 5, this.frameRect.width - 10, this.frameRect.height - 10);
            g.setColor(foreground);
            g.drawString("extern PaintComponent:", 10, 20);
            g.drawString("updates " + this.updateCount, 10, 35);
            g.drawString("paints = " + this.paintCount, 10, 50);
            return calculated;
        }
    }
}

