/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Component;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ComponentUpdate2
extends VisualTestImpl
implements ActionListener {
    private UpdateComponent update;
    private UpdateComponent paint;
    private Button repaint;
    private Button reset;
    private Button validate;
    private Button validateEast;

    public ComponentUpdate2() {
        super(new BorderLayout());
        this.setBackground(Color.white);
        this.update = new UpdateComponent(true);
        this.paint = new UpdateComponent(false);
        this.repaint = new Button("repaint");
        this.reset = new Button("reset");
        this.validate = new Button("validate");
        this.validateEast = new Button("validate Eastern component");
        this.repaint.addActionListener(this);
        this.reset.addActionListener(this);
        this.validate.addActionListener(this);
        this.validateEast.addActionListener(this);
        this.add((Component)this.update, "West");
        this.add((Component)this.paint, "East");
        Panel p = new Panel(new GridLayout(4, 1));
        p.add(this.repaint);
        p.add(this.reset);
        p.add(this.validate);
        p.add(this.validateEast);
        this.add((Component)p, "Center");
    }

    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.validate) {
            this.invalidate();
            this.validate();
        } else if (src == this.validateEast) {
            this.paint.invalidate();
            this.paint.validate();
        } else {
            if (src == this.reset) {
                this.paint.firsttime = true;
            }
            this.update.repaint();
            this.paint.repaint();
        }
    }

    public String getHelpText() {
        return "This test shows the behaviour of update.  The green block on the right has a RED background, but overrides update to avoid the repainting of the background.  This test succeeds if at all time the background is green. Clicking on the reset button puts the test in correct state again";
    }

    public void showTest() {
        this.validate();
        this.paint.firsttime = true;
        this.paint.repaint();
    }

    public void start(Panel p, boolean ar) {
        this.validate();
        this.paint.firsttime = true;
        this.paint.repaint();
    }

    public static void main(String[] args) {
        Frame main = new Frame("Component paint test");
        main.setSize(400, 234);
        main.add(new ComponentUpdate2());
        main.setVisible(true);
    }

    static class UpdateComponent
    extends Canvas {
        private boolean type;
        boolean firsttime = true;

        public UpdateComponent(boolean type) {
            this.type = type;
            this.setBackground(type ? Color.green : Color.red);
            this.setForeground(Color.blue);
        }

        public void update(Graphics g) {
            if (this.type) {
                super.update(g);
            } else if (this.firsttime) {
                Dimension d = this.getSize();
                g.setColor(Color.green);
                g.fillRect(0, 0, d.width, d.height);
                this.firsttime = false;
            }
        }

        public void paint(Graphics g) {
            Dimension d = this.getSize();
            g.drawRect(0, 0, d.width - 1, d.height - 1);
            g.drawRect(1, 1, d.width - 3, d.height - 3);
            g.drawRect(2, 2, d.width - 5, d.height - 5);
        }

        public Dimension getPreferredSize() {
            return new Dimension(75, 75);
        }

        public Dimension getMinimumSize() {
            return new Dimension(75, 75);
        }
    }
}

