/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Component;

import com.acunia.wonka.test.awt.VisualTestImpl;
import com.acunia.wonka.test.awt.VisualTester;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class ComponentMouse
extends VisualTestImpl {
    static final Color LIGHTBLUE = new Color(160, 160, 255);
    static final Color INDIGO = new Color(0, 0, 192);
    static final Color VIOLET = new Color(128, 0, 128);
    private MouseTester tester;
    private TextField messenger;
    String logString;

    public ComponentMouse() {
        this.setLayout(new BorderLayout());
        this.tester = new MouseTester();
        this.messenger = new TextField();
        this.add((Component)this.tester, "Center");
        this.add((Component)this.messenger, "South");
        this.logString = "ComponentGraphics log:";
    }

    public void message(String text) {
        this.logString = this.logString + "\n" + text;
        this.messenger.setText(text);
    }

    public String getLogInfo(Panel p, boolean b) {
        String result = this.logString;
        this.logString = "    (Written to log)";
        return result;
    }

    public String getHelpText() {
        return "Tests the mouse implementations in Component classes:\nThe test displays an array of seven colors and a field of texts underneath.\nClicking on one of the colors makes the text appear in <that> colordragging the mouse over a color does the same and also changes the value of the four variables\n<left>, <right>, <up> and <down> displayed in the text.\nIn addition, every mouse movement is mirrorred to the textfield on the bottom of the page and also logged.\n(if the interfaces MouseListener and MouseMotionListener work correctly, this is)";
    }

    public Panel getPanel(VisualTester vt) {
        return this;
    }

    public void start(Panel p, boolean b) {
    }

    public void stop(Panel p) {
    }

    public static void main(String[] args) {
        new ComponentMouse();
    }

    class MouseTester
    extends Component
    implements MouseListener,
    MouseMotionListener {
        private Dimension canvas = new Dimension();
        private int seventh;
        private int half;
        private int paintBrush;
        private Font f1 = new Font("courR14", 0, 14);
        private Font f2 = new Font("helvR17", 0, 17);
        private Font f3 = new Font("courR25", 0, 25);
        private int left = -1;
        private int right = -1;
        private int up = -1;
        private int down = -1;
        private Point lastPosition;

        MouseTester() {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.lastPosition = new Point();
            this.paintBrush = -1;
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getY() < this.half && this.paintBrush != e.getX() / this.seventh) {
                this.paintBrush = e.getX() / this.seventh;
                ComponentMouse.this.message("mouse clicked (" + e.getX() + ", " + e.getY() + "), new color " + this.getColorName(this.paintBrush));
                this.repaint();
            } else {
                ComponentMouse.this.message("mouse clicked (" + e.getX() + ", " + e.getY() + ")");
            }
        }

        public void mousePressed(MouseEvent e) {
            ComponentMouse.this.message("mouse pressed (" + e.getX() + ", " + e.getY() + ")");
        }

        public void mouseReleased(MouseEvent e) {
            ComponentMouse.this.message("mouse released (" + e.getX() + ", " + e.getY() + ")");
        }

        public void mouseEntered(MouseEvent e) {
            ComponentMouse.this.message("mouse Entered (" + e.getX() + ", " + e.getY() + ")");
        }

        public void mouseExited(MouseEvent e) {
            ComponentMouse.this.message("mouse Exited (" + e.getX() + ", " + e.getY() + ")");
        }

        public void mouseDragged(MouseEvent e) {
            if (e.getY() < this.half && this.paintBrush != e.getX() / this.seventh) {
                this.paintBrush = e.getX() / this.seventh;
                ComponentMouse.this.message(this.getMouseMovement(e.getX(), e.getY()) + " new color " + this.getColorName(this.paintBrush));
            } else {
                ComponentMouse.this.message(this.getMouseMovement(e.getX(), e.getY()));
            }
            this.repaint();
        }

        public void mouseMoved(MouseEvent e) {
            ComponentMouse.this.message(this.getMouseMovement(e.getX(), e.getY()));
            this.repaint();
        }

        private String getMouseMovement(int x, int y) {
            int d;
            String move = "Mouse moved: ";
            if (x < this.lastPosition.x) {
                d = this.lastPosition.x - x;
                this.left += d;
                move = move + "<" + d + "> pixels Left";
                this.lastPosition.x = x;
            } else if (x > this.lastPosition.x) {
                d = x - this.lastPosition.x;
                this.right += d;
                move = move + "<" + d + "> pixels right";
                this.lastPosition.x = x;
            }
            if (y < this.lastPosition.y) {
                d = this.lastPosition.y - y;
                this.up += d;
                move = move + "<" + d + "> pixels up";
                this.lastPosition.y = y;
            } else if (y > this.lastPosition.y) {
                d = y - this.lastPosition.y;
                this.down += d;
                move = move + "<" + d + "> pixels down";
                this.lastPosition.y = y;
            }
            return move;
        }

        public void paint(Graphics g) {
            if (!this.canvas.equals(this.getSize())) {
                this.setSize(this.getSize());
            }
            int current = 5;
            for (int i = 0; i < 7; ++i) {
                g.setColor(this.getColor(i));
                g.fillRect(current, 5, this.seventh - 10, this.half - 10);
                g.setColor(Color.black);
                g.drawRect(current, 5, this.seventh - 10, this.half - 10);
                current += this.seventh;
            }
            g.setColor(this.getColor(this.paintBrush));
            g.fillRect(2, this.half, this.canvas.width - 4, this.half - 2);
            g.setColor(this.paintBrush < 5 && this.paintBrush >= 0 ? Color.black : Color.white);
            g.drawLine(5, this.half + 2, this.canvas.width - 5, this.half + 2);
            g.drawRect(5, this.canvas.height - 10, this.canvas.width - 10, 5);
            g.setFont(this.f2);
            g.drawString("selected color:", 20, this.half + 20);
            g.setFont(this.f1);
            g.drawString("(" + this.getColor(this.paintBrush) + ")", 50, this.half + 40);
            g.setFont(this.f3);
            g.drawString(this.getColorName(this.paintBrush), 150, this.half + 25);
            g.setFont(this.f1);
            g.drawString("Mouse moved left: " + this.left + " right: " + this.right, 15, this.half + 55);
            g.drawString("Mouse moved up: " + this.up + " down: " + this.down, 15, this.half + 70);
        }

        public void setSize(Dimension newsize) {
            this.seventh = newsize.width / 7;
            this.half = newsize.height / 2;
            this.canvas.setSize(newsize);
            ComponentMouse.this.message("Canvas set (" + this.canvas.width + "," + this.canvas.height + ")");
        }

        private Color getColor(int i) {
            if (i < 0) {
                return Color.black;
            }
            if ((i %= 7) < 1) {
                return Color.red;
            }
            if (i < 2) {
                return Color.orange;
            }
            if (i < 3) {
                return Color.yellow;
            }
            if (i < 4) {
                return Color.green;
            }
            if (i < 5) {
                return LIGHTBLUE;
            }
            if (i < 6) {
                return INDIGO;
            }
            return VIOLET;
        }

        private String getColorName(int i) {
            if (i < 0) {
                return "(black)";
            }
            if ((i %= 7) < 1) {
                return "<RED>";
            }
            if (i < 2) {
                return "<ORANGE>";
            }
            if (i < 3) {
                return "<YELLOW>";
            }
            if (i < 4) {
                return "<GREEN>";
            }
            if (i < 5) {
                return "<BLUE>";
            }
            if (i < 6) {
                return "<INDIGO>";
            }
            return "<VIOLET>";
        }
    }
}

