﻿using System;
using System.Collections.Generic;
using System.Text;

using System.IO;

namespace ConvertIMP
{
    class Program
    {
        static string impFile = @"C:\0.imp";
        static int EOF = -1;

        #region Class IMPHeader
        class IMPHeader
        {
            public int version = 0;
            public string constant = "";
            public string unknown = "";
            public int fileCount = 0;
            public int dictionaryLength = 0;
            public int bytesRemaining = 0;
            public string unknown2 = "";
            public string unknown3 = "";
            public bool compression = false;
            public bool encryption = false;
            public int zoomState = 0;
            public string unknown4 = "";

            #region ToString
            public override string ToString()
            {
                string _toString = "";

                _toString += "Version = " + version + "\n";
                _toString += "Constant = " + constant + "\n";
                _toString += "FileCount = " + fileCount.ToString() + "\n";
                _toString += "DictionaryLength = " + dictionaryLength.ToString() + "\n";
                _toString += "BytesRemainingInHeader = " + bytesRemaining.ToString() + "\n";
                _toString += "Compression = " + compression.ToString() + "\n";
                _toString += "Encryption = " + encryption.ToString() + "\n";
                _toString += "ZoomState = " + zoomState.ToString() + "\n";
                _toString += "Unknown = " + unknown.Trim() + "\n";
                _toString += "Unknown = " + unknown2.Trim() + "\n";
                _toString += "Unknown = " + unknown3.Trim() + "\n";
                _toString += "Unknown = " + unknown4.Trim() + "\n";

                return _toString;
            }
            #endregion
        }
        #endregion

        #region Class IMPBookProperties
        class IMPBookProperties
        {
            public string ID = "";
            public string Bookshelf_Category = "";
            public string Subcategory = "";
            public string Title = "";
            public string LastName = "";
            public string MiddleName = "";
            public string FirstName = "";
            public string ResFile = "";

            #region ToString
            public override string ToString()
            {
                string _toString = "";

                _toString += "ID = " + ID + "\n";
                _toString += "Bookshelf_Category = " + Bookshelf_Category + "\n";
                _toString += "Subcategory = " + Subcategory + "\n";
                _toString += "Title = " + Title + "\n";
                _toString += "LastName = " + LastName + "\n";
                _toString += "MiddleName = " + MiddleName + "\n";
                _toString += "FirstName = " + FirstName + "\n";
                _toString += "ResFile = " + ResFile + "\n";

                return _toString;
            }
            #endregion
        }
        #endregion

        #region Class IMPTableContents
        class IMPTableContents
        {
            public List<IMPTableContentsItem> table = new List<IMPTableContentsItem>();
        }
        #endregion

        #region Class IMPTableContentsItem
        class IMPTableContentsItem
        {
            public string fileName = "";
            public int fileSize = 0;
            public string fileType = "";

            #region ToString
            public override string ToString()
            {
                string _toString = "";

                _toString += "FileName = " + fileName + "\n";
                _toString += "FileSize = " + fileSize.ToString() + "\n";
                _toString += "FileType = " + fileType + "\n";

                return _toString;
            }
            #endregion
        }
        #endregion

        #region Class IMPFiles
        class IMPFiles
        {
            public List<IMPFile> list = new List<IMPFile>();
        }
        #endregion

        #region Class IMPFile
        class IMPFile
        {
            public string fileName = "";
            public int fileSize = 0;
            public string fileType = "";
            public int currentPosition = 0;
            public byte[] buffer = null;

            #region ToString
            public override string ToString()
            {
                string _toString = "";

                _toString += "FileName = " + fileName + "\n";
                _toString += "FileSize = " + fileSize.ToString() + "\n";
                _toString += "FileType = " + fileType + "\n";

                return _toString;
            }
            #endregion
        }
        #endregion

        #region Class SWIndex
        class SWIndex
        {
            public string fileType = "";
            public int indexConstant = 0;
            public int offsetToStartOfIndex = 0;
            public int lengthOfIndex = 0;
            public int sequenceNumber = 0;
            public int[] sequenceNumbers = null;
        }
        #endregion

        #region Class CMInfo
        class CMInfo
        {
            public int Index1 = 0;
            public int Index2 = 0;
            public int RecordLength1 = 0;
            public int RecordLength2 = 0;
            public int OffsetToStartOfRecord1 = 0;
            public int OffsetToStartOfRecord2 = 0;

            public int UncompressedDataPosition = 0;
            public int CompressedDataPosition = 0;
            public int bitPosPastBytePosInCompressedData = 0;
        }
        #endregion

        #region Class CMIndex
        class CMIndex
        {
            public int UncompressedDataPosition = 0;
            public int CompressedDataPosition = 0;
            public int bitPosPastBytePosInCompressedData = 0;
        }
        #endregion

        static List<SWIndex> swIndexes = new List<SWIndex>();
        static CMInfo cmInfo = new CMInfo();

        static void Main(string[] args)
        {
            if (args.Length == 0)
            {
                Console.WriteLine("usage: ConvertIMP <IMP File>");
                Console.ReadLine();
                return;
            }

            if (!File.Exists(args[0]))
            {
                Console.WriteLine("IMP File does not exist");
                Console.ReadLine();
                return;
            }

            impFile = args[0];

            byte[] buffer = null;

            BinaryReader br = new BinaryReader(File.OpenRead(impFile));

            IMPHeader header = new IMPHeader();

            #region Read Header
            buffer = new byte[48];

            header.version = ReadInt(ref br, 2);

            buffer = br.ReadBytes(8);
            header.constant = ASCIIEncoding.ASCII.GetString(buffer).Trim();

            buffer = br.ReadBytes(8);
            //header.unknown = ASCIIEncoding.ASCII.GetString(buffer).Trim();

            header.fileCount = ReadInt(ref br, 2);

            header.dictionaryLength = ReadInt(ref br, 2);

            header.bytesRemaining = ReadInt(ref br, 2);

            buffer = br.ReadBytes(4);
            //header.unknown2 = ASCIIEncoding.ASCII.GetString(buffer).Trim();

            buffer = br.ReadBytes(4);
            //header.unknown3 = ASCIIEncoding.ASCII.GetString(buffer).Trim();

            header.compression = (ReadInt(ref br, 4) == 1);

            header.encryption = (ReadInt(ref br, 4) == 1);

            buffer = br.ReadBytes(4);
            header.zoomState = ReadInt(ref br, 4);

            buffer = br.ReadBytes(4);
            //header.unknown4 = ASCIIEncoding.ASCII.GetString(buffer).Trim();
            #endregion

            System.Console.WriteLine(header.ToString());

            IMPBookProperties bookProperties = new IMPBookProperties();

            #region Read Book Properties
            bookProperties.ID = ReadString(ref br);
            bookProperties.Bookshelf_Category = ReadString(ref br);
            bookProperties.Subcategory = ReadString(ref br);
            bookProperties.Title = ReadString(ref br);
            bookProperties.LastName = ReadString(ref br);
            bookProperties.MiddleName = ReadString(ref br);
            bookProperties.FirstName = ReadString(ref br);
            bookProperties.ResFile = ASCIIEncoding.ASCII.GetString(br.ReadBytes(header.dictionaryLength));
            #endregion

            System.Console.WriteLine(bookProperties.ToString());

            IMPTableContents tableContents = new IMPTableContents();

            #region Read Table of Contents
            for (int i = 0; i < header.fileCount; i++)
            {
                IMPTableContentsItem item = new IMPTableContentsItem();

                buffer = new byte[4];
                buffer = br.ReadBytes(4);
                item.fileName = ASCIIEncoding.ASCII.GetString(buffer).Trim();

                if (item.fileName == "")
                    item.fileName = "DATA.FRK";

                buffer = br.ReadBytes(4);

                //buffer = br.ReadBytes(4);
                item.fileSize = ReadInt(ref br, 4); // (int)(buffer[0] | buffer[1] | buffer[2] | buffer[3]);

                buffer = br.ReadBytes(4);
                item.fileType = ASCIIEncoding.ASCII.GetString(buffer).Trim();
            
                buffer = br.ReadBytes(4);

                System.Diagnostics.Debug.WriteLine(item.ToString());

                tableContents.table.Add(item);
            }
            #endregion

            IMPFiles files = new IMPFiles();

            #region Read Files
            for (int i = 0; i < header.fileCount; i++)
            {
                IMPFile file = new IMPFile();
                buffer = new byte[4];

                buffer = br.ReadBytes(4);
                file.fileName = ASCIIEncoding.ASCII.GetString(buffer).Trim();

                if (file.fileName == "")
                    file.fileName = "DATA.FRK";

                buffer = br.ReadBytes(4);

                file.fileSize = ReadInt(ref br, 4);

                buffer = br.ReadBytes(4);
                file.fileType = ASCIIEncoding.ASCII.GetString(buffer).Trim();

                if (file.fileType == "")
                    file.fileType = "DATA.FRK";
       
                buffer = br.ReadBytes(4);

                file.buffer = br.ReadBytes(file.fileSize);

                file.currentPosition = (int)br.BaseStream.Position;

                files.list.Add(file);
            }
            #endregion

            br.Close();

            string IMPResourceFile = "";

            foreach (IMPFile file in files.list)
            {
                int indexOffset = ReadOffset(file.buffer);
                
                switch (file.fileType)
                {
                    case "!!sw":
                        ReadSW(indexOffset, file.buffer);
                        break;
                    case "PNG":
                        ReadPNG(file.fileName, indexOffset, file.buffer);
                        break;
                    case "DATA.FRK":
                        IMPResourceFile = ReadDATA_FRK(file.fileName, indexOffset, file.buffer);
                        StreamWriter sr = new StreamWriter(bookProperties.FirstName + " - " + bookProperties.Title + ".txt");
                        sr.WriteLine(IMPResourceFile);
                        sr.Close();
                        break;
                    case "!!cm":
                        //ReadCM(indexOffset, file.buffer);
                        break;
                }
            }
        }

        #region ReadInt
        static int ReadInt(ref BinaryReader br, int count)
        {
            int nResult = 0;
            byte[] buffer = br.ReadBytes(count);

            for (int i = 0; i < count; i++)
                nResult = (nResult << 8) + buffer[i];

            return nResult;
        }
        #endregion

        #region ReadString
        static string ReadString(ref BinaryReader br)
        {
            string strResult = "";

            char ch = ' ';

            while (ch != '\0')
            {
                strResult += ch;
                ch = br.ReadChar();
            }

            return strResult.Trim();
        }
        #endregion

        #region ReadResName
        static string ReadResName(ref BinaryReader br)
        {
            string strResult = "";

            char ch = ' ';

            while (!strResult.EndsWith("RES"))
            {
                ch = br.ReadChar();
                strResult += ch;
            }

            return strResult.Trim();
        }
        #endregion

        #region GetInt
        static int GetInt(byte[] buffer, int start, int count)
        {
            int nResult = 0;

            for (int i = start; i < start + count; i++)
                nResult = (nResult << 8) + buffer[i];

            return nResult;
        }
        #endregion

        #region GetString
        static string GetString(byte[] buffer, int start, int count)
        {
            string strResult = "";

            for (int i = start; i < start + count; i++)
                strResult += "" + (char)buffer[i];

            return strResult.Trim();
        }
        #endregion

        #region ReadOffset
        static int ReadOffset(byte[] buffer)
        {
            return GetInt(buffer, 10, 4);
        }
        #endregion

        #region ReadSW
        static void ReadSW(int offsetToIndex, byte[] buffer)
        {
            int offset = offsetToIndex;

            while (true)
            {
                SWIndex swIndex = new SWIndex();
                swIndex.sequenceNumber = GetInt(buffer, offset, 1);
                offset += 1;
                swIndex.lengthOfIndex = GetInt(buffer, offset, 4);
                offset += 4;
                swIndex.offsetToStartOfIndex = GetInt(buffer, offset, 4);
                offset += 4;
                int empty = GetInt(buffer, offset, 4);
                offset += 5;
                swIndex.fileType = GetString(buffer, offset, 4);
                offset += 4;

                swIndex.sequenceNumbers = new int[swIndex.lengthOfIndex];

                int sOffset = swIndex.offsetToStartOfIndex;
                for (int i = 0; i < swIndex.lengthOfIndex; i++)
                {
                    swIndex.sequenceNumbers[i] = GetInt(buffer, sOffset, 2);
                    sOffset += 2;
                }

                swIndexes.Add(swIndex);
                if (offset >= buffer.Length)
                    break;
            }
        }
        #endregion

        #region ReadCM
        static void ReadCM(int offsetToIndex, byte[] buffer)
        {
            int offset = 32;

            while (offset < buffer.Length)
            {
                int i5 = GetInt(buffer, offset, 4);
                offset += 4;
                int i6 = GetInt(buffer, offset, 4);
                offset += 4;
                int i7 = GetInt(buffer, offset, 2);
                offset += 2;

                CMIndex index = new CMIndex();
                index.UncompressedDataPosition = i5;
                index.CompressedDataPosition = i6;
            }
        }
        #endregion

        #region ReadPNG
        static void ReadPNG(string fileName, int offsetToIndex, byte[] buffer)
        {
            BinaryWriter bw = new BinaryWriter(File.Create(@"C:\Temp\eBook\" + fileName + ".PNG"));

            bw.Write(buffer, 32, offsetToIndex - 32);

            bw.Close();
        }
        #endregion

        #region Class encoded_string_t
        class encoded_string_t
        {
            public int offset;
            public int length;
        }
        #endregion

        #region Class bitStream
        class bitStream
        {
            public int bitCount = 0;
            public int bitBuffer = 0;
        }
        #endregion

        #region Wrap
        static int Wrap(int value, int limit)
        {
            return (((value) < (limit)) ? (value) : ((value) - (limit)));
        }
        #endregion

        #region BitFileGetBitsInt
        static int BitFileGetBitsInt(ref bitStream stream, byte[] buffer, ref int bufferOffset, ref int bits, int count)
        {
            return BitFileGetBitsLE(ref stream, buffer, ref bufferOffset, ref bits, count);
        }
        #endregion

        #region BitFileGetBitsLE
        static int BitFileGetBitsLE(ref bitStream stream, byte[] buffer, ref int bufferOffset, ref int bits, int count)
        {
            UInt16 bytes = 0;
            byte shifts = 0;
            int offset = 0;
            int remaining = count;
            int returnValue = 0;

            while (remaining >= 8)
            {
                returnValue = BitFileGetChar(ref stream, buffer, ref bufferOffset);

                bytes = (byte)returnValue;
                remaining -= 8;
                offset++;
            }

            if (remaining != 0)
            {
                shifts = (byte)(8 - remaining);

                while (remaining > 0)
                {
                    returnValue = BitFileGetBit(ref stream, buffer, ref bufferOffset);

                    if (returnValue == EOF)
                        return EOF;

                    bytes <<= 1;
                    bytes |= (byte)(returnValue & 0x01);
                    remaining--;
                }
            }

            byte byte2 = 0;
            if (bytes >= 0xFF)
            {
                bits = bytes;
            }
            else
            {
                shifts = (byte)bytes;
                bytes = byte2;
                byte2 = shifts;
                string s = string.Format("0x{0:X}{1:X}", bytes, byte2);
                bits = Convert.ToUInt16(s, 16);
            }

            return count;
        }
        #endregion

        #region BitFileGetBit
        static int BitFileGetBit(ref bitStream stream, byte[] buffer, ref int offset)
        {
            if (offset == buffer.Length)
                return EOF;

            int returnValue = 0;

            if (stream.bitCount == 0)
            {
                returnValue = (int)buffer[offset++];

                stream.bitCount = 8;
                stream.bitBuffer = returnValue;
            }

            stream.bitCount--;

            returnValue = (stream.bitBuffer >> stream.bitCount);
            return (returnValue & 0x01);
        }
        #endregion

        #region BitFileGetChar
        static int BitFileGetChar(ref bitStream stream, byte[] buffer, ref int offset)
        {
            if (offset == buffer.Length)
                return EOF;

            int returnValue = (int)buffer[offset++];

            if (stream.bitCount == 0)
            {
                return returnValue;
            }

            byte tmp = (byte)((byte)returnValue >> stream.bitCount);
            tmp |= (byte)((stream.bitBuffer) << (8 - (stream.bitCount)));
            stream.bitBuffer = returnValue;

            returnValue = tmp;

            return returnValue;
        }
        #endregion

        #region ReadDATA_FRK
        static string ReadDATA_FRK(string fileName, int offsetToIndex, byte[] buffer)
        {
            int offset = 0;

            int OFFSET_BITS = 14;
            int LENGTH_BITS = 3;
            int WINDOW_SIZE = (1 << OFFSET_BITS);
            byte c = 0;
            int i = 0, nextChar = 1;
            encoded_string_t code = new encoded_string_t();
            int uncoded = 1;
            int MAX_UNCODED = 2;
            int MAX_CODED = ((1 << LENGTH_BITS) + MAX_UNCODED);
            string strFile = "";
            bitStream fIn = new bitStream();

            byte[] slidingWindow = new byte[WINDOW_SIZE];
            byte[] uncodedLookahead = new byte[WINDOW_SIZE];

            for (int x = 0; x < WINDOW_SIZE; x++)
                slidingWindow[x] = (byte)' ';

            for (int x = 0; x < WINDOW_SIZE; x++)
                uncodedLookahead[x] = (byte)' ';

            while (true)
            {
                if (offset == buffer.Length)
                    break;

                c = (byte)BitFileGetBit(ref fIn, buffer, ref offset);

                if (c == uncoded)
                {
                    if (offset == buffer.Length)
                        break;

                    c = (byte)BitFileGetChar(ref fIn, buffer, ref offset);

                    if (c == 0x0e || c == 0x0f || c == 0x15 || c == 0x16 || c == 0xA5)
                    {
                        strFile += "" + (char)0x0D;
                        strFile += "" + (char)0x0A;
                        strFile += "" + (char)0x7C;

                        if (c == 0x0F)
                        {
                            strFile += "" + (char)0x5E;
                            strFile += "" + (char)0x7C;
                        }
                    }
                    else
                    {
                        if (c == 0x14 || c == 0x0A || c == 0x0B)
                        {
                            strFile += "" + (char)0x0D;
                            strFile += "" + (char)0x0A;

                            if (c == 0x14)
                            {
                                strFile += "___";
                                strFile += "___";
                                strFile += "___";
                                strFile += "___";
                            }
                            else
                            {
                                if (c == 0x0B)
                                {
                                    strFile += "" + (char)0x0D;
                                    strFile += "" + (char)0x0A;
                                }
                            }
                        }
                        else
                        {
                            if (c == 0x13)
                            {
                                strFile += "_";
                            }
                            else if (c == 0xD5)
                            {
                                strFile += "'";
                            }
                            else
                            {
                                strFile += "" + (char)c;
                            }
                        }
                    }

                    if (c == 0x0D)
                    {
                        strFile += "" + (char)0x0A;
                    }
                    
                    slidingWindow[nextChar] = c;
                    nextChar = Wrap(((int)nextChar + 1), WINDOW_SIZE);
                }
                else
                {
                    code.offset = 0;
                    code.length = 0;

                    int coffset = 0;
                    int clength = 0;

                    if (BitFileGetBitsInt(ref fIn, buffer, ref offset, ref coffset, OFFSET_BITS) == EOF)
                        break;

                    if (BitFileGetBitsInt(ref fIn, buffer, ref offset, ref clength, LENGTH_BITS) == EOF)
                        break;

                    if (coffset == 0 && clength == 0)
                        break;

                    code.offset = coffset;
                    code.length = clength;
                    code.length += MAX_UNCODED + 1;

                    for (i = 0; i < code.length; i++)
                    {
                        c = slidingWindow[Wrap((code.offset + i), WINDOW_SIZE)];
                        if (code.offset + code.length > nextChar)
                        {
                            if (i >= nextChar - code.offset)
                            {
                                c = uncodedLookahead[i - nextChar + code.offset];
                            }
                        }
                        if (c == 0x0e || c == 0x0f || c == 0x15 || c == 0x16 || c == 0xA5)
                        {
                            strFile += "" + (char)0x0D;
                            strFile += "" + (char)0x0A;
                            strFile += "" + (char)0x7C;
                            if (c == 0x0f) 
                            {
                                strFile += "" + (char)0x5E;
                                strFile += "" + (char)0x7C;
                            }
                        }
                        else
                        {
                            if (c == 0x14 || c == 0x0A || c == 0x0B)
                            {
                                strFile += "" + (char)0x0D;
                                strFile += "" + (char)0x0A;
                                if (c == 0x14)
                                {
                                    strFile += "___";
                                    strFile += "___";
                                    strFile += "___";
                                    strFile += "___";
                                }
                                else
                                {
                                    if (c == 0x0B)
                                    {
                                        strFile += "" + (char)0x0D;
                                        strFile += "" + (char)0x0A;
                                    }
                                }
                            }
                            else
                            {
                                if (c == 0x13)
                                {
                                    strFile += "_";
                                }
                                else
                                {
                                    strFile += "" + (char)c;
                                }
                            }
                        }
                        if (c == 0x0d)
                        {
                            strFile += "" + (char)0x0A;
                        }
                        uncodedLookahead[i] = c;
                    }

                    /* write out decoded string to sliding window */
                    for (i = 0; i < code.length; i++)
                    {
                        slidingWindow[(nextChar + i) % WINDOW_SIZE] =
                            uncodedLookahead[i];
                    }

                    nextChar = Wrap((nextChar + code.length), WINDOW_SIZE);
                }
            }

            return strFile;
        }
        #endregion
    }
}
