#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
ShowMainWindow() is called by the main function.
This version counts the number of different types of quotes in the selected files
Any other code that iterates through html files should form part of this loop for setting up the program.
"""
import os, inspect	#needed to get Sigil plugin path
import sys
import re
import tkinter.ttk as ttk	#Essential for ttk. commands
from tkinter import *				#Essential for root = Tk()
import tkinter as tk				#Essential for custom dialog box using tk. commands
from tkinter import messagebox		#Essential for messagebox
from tkinter import filedialog		#Essential for file dialog box

import SpanTagProcessor
import GenUtils						#Need centerWindow()
import HTMLProcessor
from Quotations import cDetermineQuotes	#used for determining type of quote marks to use
from Chapter import Chapters
import ImageMod
from ProcessHeaderTags import cProcessHeaderTags
from ManualWordChecker import cManualWordCheck
from GetFilesDlg import cSelectFiles
#import checkVersion
from UpdateChecker import CheckForUpdates, SetUpdateTimes
from HyphenationClass import dlgHyphenation #NEW JUL 2020

text_type = str
characterize = chr

def ProcessHyphens(root,  bk,  prefs):
	# root = Tk()
	# root.withdraw()	 #Hide main window
	# root.title("Hyphenated words")
	# 
	# print('Python Laucher Version:', bk.launcher_version())
	# if bk.launcher_version() < 20151024:	#Check Sigil version is greater than 0.9.0....
	# 	print("You need to use Sigil 0.9.1 or greater for this plugin")
	# 	print('\n\nPlease click OK to close the Plugin Runner window.')
	# 	return 0		#....and return if Sigil  is not greater than 0.9.0)

	HyphenDlg = dlgHyphenation(prefs)   #Create an instance of the dlgHyphenation class
	if HyphenDlg.OpenHyphenExceptionFile() == True: #Open file that contains allowed hyphenated words

		for (id, href) in bk.text_iter():  # For each html file in the 'text' section of the epub
			html = bk.readfile(id)  # Read the section into html
			if not isinstance(html, str):  # If the section is not type str
				html = text_type(html, 'utf-8')  # then sets its type to 'utf-8'
				
			HyphenDlg.FindHyphens(html) #Check for hyphenated words

		HyphenDlg.ShowCheckBoxes(root)   #Show the dialog
		root.wait_window(dlgHyphenation.dlgTop)		 #Wait until the dialog box has been destroyed

def GetDictPath():
	# get plugin directory path
	plugin_path = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
	# get rid of the last two directories
	tmp_path = os.path.dirname(os.path.dirname(plugin_path))
	# add the dictionary path
	dictionary_path = os.path.join(tmp_path, 'user_dictionaries', 'WordDictionary.txt')
	return(dictionary_path)

def showImageDialog(root,  bk):
	if ImageMod.importPILFlag:
		imageDialog = ImageMod.dlgImage()
		imageDialog.ShowAmendImgDlg(root,bk)
		root.wait_window(dlgImage.dlgTop)
	else:
		print("PIL not found - cannot process images")

def GetHeaderTagOptions(root,  bk):
	processHeaderTagsDlg = cProcessHeaderTags()
	processHeaderTagsDlg.showHeadtagsDlg(root)
	GenUtils.centerWindow(processHeaderTagsDlg.top)		#Centre dialog 
	root.wait_window(processHeaderTagsDlg.top)

def GetChapterOptions(root):
	chapDialog = Chapters()
	chapDialog.ShowChapDlg(root)
	GenUtils.centerWindow(Chapters.dlgTop)		#Centre dialog
	root.wait_window(Chapters.dlgTop)

def processHTMLFiles(root, lbox, bk, prefs):
	SelectedHtmlList=[]
	IDlist = []

	quoteDeterminator=cDetermineQuotes()

	SelectedHtmlList = [lbox.get(idx) for idx in lbox.curselection()]
	if not SelectedHtmlList:
		messagebox.showwarning('WARNING','You must select the files to process from the listbox')
		return

	for (id, href) in bk.text_iter():			#For each html file in the 'text' section of the epbub
		if (href) in SelectedHtmlList:
			IDlist.append(id)

			#Process other items for all selected html files here eg type of quotes used
	
			html = bk.readfile(id)					#Read the section into html
			if not isinstance(html, text_type):		#If the section is not str
				html = text_type(html, 'utf-8')		#then sets its type to 'utf-8'
			html_orig = html						#Copy the result to html_orig	
	
			quoteDeterminator.countQuotes(html)	#Determine the number of each type of quote in the HTML file

	quoteDeterminator.determineQuotesToUse()	#Determine the total number of each type of quote in all HTML files

	if prefs['ProcessSpanTags'] == 'Yes':
		SpanTagProcessor.ProcessTags(root, SelectedHtmlList, bk, prefs, IDlist)
	HTMLProcessor.processHTML(bk, prefs, IDlist)
	
	if prefs['DoManualCheck'] =='Yes':
		iManualWordCheckDlg=cManualWordCheck(root)
		iManualWordCheckDlg.checkWords(bk, IDlist)	#Remove html from the parameters passed

	if prefs['UseCSSFile'] =='Yes':
		LoadCSSFile(root, lbox, bk, prefs)

	root.quit()
	return(0)

def LoadCSSFile(root, lbox, bk, prefs):
##___________Remove this section when Sigil 0.9.0.1 is published
	# messagebox.showinfo('INFORMATION', 'Sigil 0.9.0.0 has a bug that causes the ePub file to become corrupted when the contents of the ePub changes and when a CSS file is loaded.\n\nConsequently, the facility for incorporating a CSS file has been suspended until the next version of Sigil is published')
	# return
##_________________________________________________	
	if prefs['cssFileName']  == '':	#Get name of css file if not previously selected
		root.withdraw()	#Hide the main window
		print("Could not load a CSS style sheet. You should select a valid css file to install or untick the box 'Select CSS file'.")
		messagebox.showwarning('WARNING',"Could not load a CSS style sheet.\n\nYou need to install a valid css file\nor untick the box 'Select CSS file'.\n\nFor instructions on how to set up a file for this please see the manual.")
		return	
		
	filename=prefs['cssFileName'].rpartition('/') 	#Break path into three tuples at the slash
	basename=filename[2]							#Get filename and extension
	uid=basename									#Set uid to basename
	mime = "text/css"
	
	CSSFileAbsent=True
	for (idCSS, href) in bk.css_iter():		#Check whether the css file or its ID is already present
		href=href.rpartition('/') 			#Break href into three tuples at the slash
		href=href[2]						#Get the *.css part only
		if idCSS==uid or href==basename:	#If uid or the css style name is in use then clear flag 
			CSSFileAbsent=False				#If so, clear flag 
	
	if CSSFileAbsent:	#If css file is not present in the ePub

		try:
			f=open(prefs['cssFileName'], 'r', encoding="utf-8")
		except IOError:
			print("Error opening the file for the style sheet")
		else: 
			try:
				cssString = f.read()
			except IOError:
				print("Error reading the file for the style sheet")
			else:
				bk.addfile(uid, basename, cssString, mime)

def ShowMainWindow(root, bk, prefs):
	"""
	This function is called automatically by the main function
	This function displays the main window showing a listbox containing the html files in the ePub file.
	Files selected in Sigil are highlighted in this listbox.
	It contains buttons to enable the user to run required processes.
	After building the window with its widgets, centerWindow() is called to centre this window
	"""
	def chkUseHunspellChanged(chkUseHunspellDict, cbLanguages):
		"""
		This function is called when the tick box marked 'Use in-built dictionary' changes state.
		It will enable/disable the combobox for selecting a language for the Hunspell dictionary
		"""
		if chkUseHunspellDict.get() == "No":
			cbLanguages.configure(state='disabled')
		else:
			cbLanguages.configure(state='readonly')
	
	def getFileNames(root, prefs):
		"""
		This function is called when the button marked "Select files" is clicked.
		It displays a dialog that allows the user to select the data files for manually
		correcting spelling, automatically correctng spelling and the CSS file.
		It stores the filenames, including their paths, in prefs.
		It useses my class cSelectFiles in GetFileDlg.py
		"""
		GetFilesDlg = cSelectFiles()	
		cSelectFiles.CssPath = prefs['cssFileName']
		cSelectFiles.ManualCheckPath = prefs['ManualFileName']
		cSelectFiles.AutoCheckPath = prefs['WordListDirectory']
		cSelectFiles.HyphenatedWordPath = prefs['HyphenatedWordFileName'] 	###UPDATED OCT2018
		
		GetFilesDlg.showFileDialog(root)  #In class cSelectFiles
		GenUtils.centerWindow(cSelectFiles.top)		
		root.wait_window(cSelectFiles.top)
		
		prefs['cssFileName'] = cSelectFiles.CssPath
		prefs['ManualFileName']  = cSelectFiles.ManualCheckPath
		prefs['WordListDirectory']  = cSelectFiles.AutoCheckPath
		prefs['HyphenatedWordFileName'] = cSelectFiles.HyphenatedWordPath 	###UPDATED OCT2018
		
		cManualWordCheck.ManualFileName=prefs['ManualFileName']
		return 0
		
	def Go(root, lbox, bk, prefs):
		"""
		This function is called when the button marked "Process text" is clicked.
		It gets the state of the widgets in the ePub Tidy dialog,
		stores them in the prefs list and then calls processHTMLFiles()
		"""
		prefs['JoinParagraphs'] = chkJoinParagraphs.get()
		prefs['ReplaceHTMLCode'] = chkReplaceHTMLCode.get()
		prefs['ProcessItalics'] = chkProcessItalics.get()
		prefs['ProcessSpanTags'] = chkProcessSpanTags.get()
		prefs['DoManualCheck'] = chkDoManualCheck.get()
		prefs['UseCSSFile'] = chkUseCSSFile.get()
		prefs['GreekLetters'] = chkGreek.get()
		prefs['useHunspellDict'] = chkUseHunspellDict.get()
		prefs['HunspellLanguage']  =  cbLanguages.get()
		prefs['FormatHTML'] = chkFormatHTML.get()	###UPDATED MAY2018

		processHTMLFiles(root, lbox, bk, prefs)
		return 0

	prefs['DictFile']=GetDictPath()

	mainframe = ttk.Frame(root, padding="15 15 12 12")
	mainframe.grid(column=0, row=0, sticky=(N, W, E, S))
	mainframe.columnconfigure(0, weight=1)
	mainframe.rowconfigure(0, weight=1)

	ttk.Label(mainframe, text="Select parts to process").grid(column=0, row=0, sticky=W)
	ttk.Label(mainframe, text="Options").grid(column=3, row=1, sticky=W)
	
	optionFrame=ttk.Frame(mainframe,padding="5 5 5 5")
	optionFrame.grid(column=3, row=1, sticky=(N, W, E, S))

	lbox = Listbox(mainframe, height=15, width=50, selectmode=EXTENDED, exportselection=0)
	lbox.grid(column=0, row=1, sticky=(N,S,E,W))
	scroller = ttk.Scrollbar(mainframe, orient=VERTICAL, command=lbox.yview)
	scroller.grid(column=1, row=1, sticky=(N,S,W))
	lbox.configure(yscrollcommand=scroller.set)

	for (id, href) in bk.text_iter():				#For each html file in the 'text' section of the ePub
		lbox.insert(END, href)						#Append the HTML file name to the list box

	for (id_type, id) in bk.selected_iter():		#Get files selected in Sigil
		if id_type == "manifest":
			href = bk.id_to_href(id, ow=None)
			mime = bk.id_to_mime(id, ow=None)
			if mime == "application/xhtml+xml":		#and if they are of type application/xhtml+xml
				i = lbox.get(0, END).index(href)	#get their index in the listbox
				lbox.selection_set(i)				#and highlight the name in the listbox

	chkJoinParagraphs = StringVar()
	chkReplaceHTMLCode = StringVar()
	chkProcessItalics = StringVar()
	chkProcessSpanTags = StringVar()
	chkDoManualCheck =  StringVar() 
	chkGreek = StringVar() 
	chkUseCSSFile =  StringVar()
	chkUseCSSFile =  StringVar()
	chkUseHunspellDict =  StringVar()
	chkFormatHTML =  StringVar()	###UPDATED MAY2018
	
	chkJoinParagraphs.set(prefs['JoinParagraphs'])
	chkReplaceHTMLCode.set(prefs['ReplaceHTMLCode'])
	chkProcessItalics.set(prefs['ProcessItalics'])
	chkProcessSpanTags.set(prefs['ProcessSpanTags'])
	chkDoManualCheck.set(prefs['DoManualCheck']) 
	chkGreek.set(prefs['GreekLetters']) 
	chkUseCSSFile.set(prefs['UseCSSFile'])
	chkUseHunspellDict.set(prefs['useHunspellDict'])
	chkFormatHTML.set(prefs['FormatHTML'])	###UPDATED MAY2018

	check = ttk.Checkbutton(optionFrame, text='Fix ALL broken line endings', 
		variable=chkJoinParagraphs,
		onvalue='Yes', offvalue='No').grid(column=3, row=1, sticky=W)

	check = ttk.Checkbutton(optionFrame, text='Replace HTML code eg &mdash;',
		variable=chkReplaceHTMLCode,
		onvalue='Yes', offvalue='No').grid(column=3, row=2, sticky=W)

	check = ttk.Checkbutton(optionFrame, text='Process italics', 
		variable=chkProcessItalics,
		onvalue='Yes', offvalue='No').grid(column=3, row=3, sticky=W)

	check = ttk.Checkbutton(optionFrame, text='Process span tags', 
		variable=chkProcessSpanTags,
		onvalue='Yes', offvalue='No').grid(column=3, row=4, sticky=W)

	check = ttk.Checkbutton(optionFrame, text='Do manual word check',  
		variable=chkDoManualCheck,
		onvalue='Yes', offvalue='No').grid(column=3, row=5, sticky=W)


	check = ttk.Checkbutton(optionFrame, text='Insert CSS file',  
		variable=chkUseCSSFile,
		onvalue='Yes', offvalue='No').grid(column=3, row=6, sticky=W)


	check = ttk.Checkbutton(optionFrame, text='Process Greek characters', 
		variable=chkGreek,
		onvalue='Yes', offvalue='No').grid(column=3, row=7, sticky=W)

	check = ttk.Checkbutton(optionFrame, text='Format HTML',	###UPDATED MAY2018
		variable=chkFormatHTML,
		onvalue='Yes', offvalue='No').grid(column=3, row=8, sticky=W)

	ttk.Label(optionFrame, text="").grid(column=3, row=8, sticky=W,) #Blank row	
	
	check = ttk.Checkbutton(optionFrame, text='Use in-built dictionary', 
		variable=chkUseHunspellDict, command=lambda: chkUseHunspellChanged(chkUseHunspellDict,cbLanguages),
		onvalue='Yes', offvalue='No').grid(column=3, row=9, sticky=W)
		
	cbDictChoices=("English (UK)", "English (USA)", "French", "German", "Greek*", "Spanish")
	cbLanguages=ttk.Combobox(optionFrame, state="readonly", values=cbDictChoices,exportselection=0, width=35)
	cbLanguages.grid(column=3, row=10, sticky=W)
	cbLanguages.set(prefs['HunspellLanguage'])					#Set language dictionary to use
	chkUseHunspellChanged(chkUseHunspellDict,cbLanguages)		#Set initial text in language combobox
		
	ttk.Label(optionFrame, text="").grid(column=3, row=20, sticky=W,) #Blank row	

	ttk.Button(optionFrame, text='Process header tags', command=lambda: GetHeaderTagOptions(root,  bk), width=30).grid(column=3, row=30, sticky=W)
	ttk.Button(optionFrame, text="Options for chapter titles", command=lambda: GetChapterOptions(root), width=30).grid(column=3, row=40, sticky=W)
	ttk.Button(optionFrame, text='Select files', command=lambda: getFileNames(root, prefs), width=30).grid(column=3, row=50, sticky=W)
	ttk.Button(optionFrame, text='Hyphenated words', command=lambda: ProcessHyphens(root,  bk,  prefs), width=30).grid(column=3, row=60, sticky=W)
	
	ttk.Button(mainframe, text='Resize image', command=lambda: showImageDialog(root,  bk)).grid(column=4, row=30, sticky=W)
	ttk.Button(mainframe, text="Process text", command=lambda: Go(root, lbox, bk, prefs)).grid(column=3, row=30, sticky=W)
	ttk.Button(mainframe, text="Close", command=root.quit).grid(column=0, row=30, sticky=W)
	for child in mainframe.winfo_children(): child.grid_configure(padx=5, pady=5) 
	GenUtils.centerWindow(root)		#Centre main window and show it
	root.mainloop()
	return ()

def run(bk):
	print('Python Laucher Version:', bk.launcher_version())
	if bk.launcher_version() < 20151024:	#Check Sigil version is greater than 0.9.0....
		print("You need to use Sigil 0.9.1 or greater for this plugin")
		print('\n\nPlease click OK to close the Plugin Runner window.')
		return 0		#....and return if Sigil  is not greater than 0.9.0
			
	root = Tk()
	root.title("Epub tidy")
	root.withdraw()	#Hide window to avoid flashing when it is moved to the correct position		

	prefs = bk.getPrefs()	    # Get preferences from json file

	if not 'JoinParagraphs' in prefs: prefs['JoinParagraphs']  = 'No'
	if not 'ReplaceHTMLCode' in prefs: prefs['ReplaceHTMLCode']  = 'No'
	if not 'ProcessItalics' in prefs: prefs['ProcessItalics']  = 'No'
	if not 'ProcessSpanTags' in prefs: prefs['ProcessSpanTags']  = 'No'
	if not 'DoManualCheck' in prefs: prefs['DoManualCheck']  = 'No'
	if not 'WordListDirectory' in prefs: prefs['WordListDirectory']  = ''
	if not 'ManualFileName' in prefs: prefs['ManualFileName']  = '' 
	if not 'GreekLetters' in prefs: prefs['GreekLetters']  = 'No' 
	if not 'UseCSSFile' in prefs: prefs['UseCSSFile']  = 'No'
	if not 'cssFileName' in prefs: prefs['cssFileName']  = '' 
	if not 'HyphenatedWordFileName' in prefs: prefs['HyphenatedWordFileName'] = '' 	###UPDATED OCT2018
	if not 'useHunspellDict' in prefs: prefs['useHunspellDict']  = 'Yes'
	if not 'HunspellLanguage' in prefs: prefs['HunspellLanguage']  = 'English (UK)'
	if not 'FormatHTML' in prefs: prefs['FormatHTML']  = 'Yes'	###UPDATED MAY2017

	cManualWordCheck.ManualFileName=prefs['ManualFileName']

	
	#Specify the url for the web page that contains the plugin eg:
	url = "https://www.mobileread.com/forums/showthread.php?t=264378"
	CheckForUpdates(root, prefs, url)

	ShowMainWindow(root, bk, prefs)			#show the main window

	bk.savePrefs(prefs)				#Save user preferences to a json file

	print('\n\nPlease click OK to close the Plugin Runner window.')

	return 0		#0 - means success, anything else means failure

def main():
	print ("This module should not be run as a stand-alone module")
	return -1

if __name__ == "__main__":
	sys.exit(main())