#!/usr/bin/env python
# -*- coding: utf-8 -*-

import re
import tkinter as tk
import tkinter.ttk as ttk	#Essential for ttk. commands
from tkinter import *				#Essential for root = Tk()

"""
This class searches through a html file for a specified tag, tagOriginal which
may be <h1>...<h6> and replaces it with the tag specified in tagNew.
All other tags are stripped from the <h..> expression

The class static variables includes a flag, processHeadersFlag, that is set to False if no changes are
required and True if changes are required.
The class static variables also inlcude a dictionary of the tags and each item in the
dictionary is initialised to "No change"
If a tag is to be changed, then this dictionary will contain the value of the tag that it is to be changed to.
The class has two main methods that can be called by an external module:

1. showHeadtagsDlg(self, parent)
This displays a dialog box that allows the user to decide which tags to change.
It sets the values in the (static) dictionary according to values chosen by the user.
When called, parent is the parent window of the calling routine.

The onClick() method shows how to call this method.

2. simplifyParaTags(html)
This reads the static data in the dictionary to determine which tags are to be changed and
their new values.
It processes the tags, stripping out all other tags within the heading and replacing the
original header tags required tags.

The processClick(html) method shows how to call this method.

Each of these two main functions can be called from different modules; one module
can set up the dictioanry and the other module can process the tags.

"""

class cProcessHeaderTags:
    top=""
    processHeadersFlag=False
    headerTags={
    "<h1>": "No change",
    "<h2>": "No change",
    "<h3>": "No change",
    "<h4>": "No change",
    "<h5>": "No change",
    "<h6>": "No change"
    }
    def __init__(self):
        pass    #Dummy - does nothing

    def showHeadtagsDlg(self, parent):
        cProcessHeaderTags.top = top = tk.Toplevel(parent)
        top.grab_set() #Make dialog box modal
        top.title("Header tags") #Title for dialog box
        
        mainframe = ttk.Frame(top, padding="15 15 12 12", relief=SUNKEN)
        mainframe.grid(column=0, row=0, sticky=(N, W, E, S))
        mainframe.columnconfigure(0, weight=1)
        mainframe.rowconfigure(0, weight=1)
        tk.Label(mainframe, text = "Select tags to change/simplify", fg="blue").grid(column = 0, row=0, sticky = N)
        
        self.comboBox=[]			#Clear list that holds contents of each combobox. 
        cbChoices=("No change", "<h1>", "<h2>", "<h3>", "<h4>", "<h5>", "<h6>")        
        for count in range(1,7):  
            tk.Label(mainframe, text = "Change header tag <h"+str(count)+">").grid(column = 0, row=count+1, sticky = N)
            self.comboBox.append(ttk.Combobox(mainframe, state="readonly", values=cbChoices,exportselection=0))	
            self.comboBox[count-1].grid(column=1, row=count+1, sticky=W)	#Needs to be on a separate line, unlike checkboxes????
            self.comboBox[count-1].set("No change")						#Set default value
            
        tk.Button(mainframe, text="OK", command=self.OK, width = 20).grid(column=0, row=13, sticky=W)
        tk.Button(mainframe, text="Cancel", command=self.Cancel, width = 20).grid(column=1, row=13, sticky=W)
        
        top.bind('<Return>', self.OKPressed)
        top.bind('<Escape>', self.EscapePressed)  
                  
    def processTag(self, match, tagNew):
        """
        This method is called by re.sub() in the methods implifyParaTags().
        tagNew is the tag used to replace the current tag eg <h1>
        """
        tempStr=match.group(2)
        while tempStr.find(">") !=-1:      #strip tags - will not work for tags inside tags
            tempStr=re.sub(r'<[^>]+>',  "", tempStr)  
            
        tempStr=""+tagNew+""+tempStr
        tagNew=tagNew.replace("<", "</")
        tempStr=tempStr+tagNew
        return(tempStr)

    def simplifyParaTags(self, html):
        """
        This method is called by an external module. It iterates through each key in the 
        dictionary to identify the replacement tag that is required for each <hx> tag in
        html.
        The items in the dictionary must have been set earlier by a call to showHeadtagsDlg().
        re.sub uses processTag() to strip unwanted tags and insert the new one
        """
        for count in range(1,7):
            hNum=str(count)
            tagNew1= "<h"+ hNum+">"
            tagNew = cProcessHeaderTags.headerTags[tagNew1]
            if tagNew != "No change":
                seekRegex= re.compile ("<h"+hNum+"(.*?)>(.*?)</h"+hNum+">")
                html=re.sub(seekRegex, lambda m: self.processTag(m, tagNew), html)
        return (html)

    def OKPressed(self, event):
        self.OK()

    def EscapePressed(self, event):
        self.Cancel()

    def Cancel(self):
        """
        Called by a button click in the method showHeadtagsDlg() via EscapePressed()
        Sets processHeadersFlag to False and resets all the items in the dictionary to 
        "No change" before destroying the dialog
        """
        cProcessHeaderTags.headerTags["<h1>"] = "No change"
        cProcessHeaderTags.headerTags["<h2>"] = "No change"
        cProcessHeaderTags.headerTags["<h3>"] = "No change"
        cProcessHeaderTags.headerTags["<h4>"] = "No change"
        cProcessHeaderTags.headerTags["<h5>"] = "No change"
        cProcessHeaderTags.headerTags["<h6>"] = "No change"
        cProcessHeaderTags.processHeadersFlag = False
        self.top.destroy()
    
    def OK(self):
        """
        Called by a button click in the method showHeadtagsDlg() via OKPressed
        Sets processHeadersFlag to True and sets all the items in the dictionary to 
        the options selected by the user  before destroying the dialog
        """
        cProcessHeaderTags.headerTags["<h1>"] = self.comboBox[0].get()
        cProcessHeaderTags.headerTags["<h2>"] = self.comboBox[1].get()
        cProcessHeaderTags.headerTags["<h3>"] = self.comboBox[2].get()
        cProcessHeaderTags.headerTags["<h4>"] = self.comboBox[3].get()
        cProcessHeaderTags.headerTags["<h5>"] = self.comboBox[4].get()
        cProcessHeaderTags.headerTags["<h6>"] = self.comboBox[5].get()
        cProcessHeaderTags.processHeadersFlag = True
        self.top.destroy()