#!/usr/bin/env python
# -*- coding: utf-8 -*-

import tkinter.ttk as ttk    #Essential for ttk. commands eg frame
from tkinter import *                #Essential for root = Tk()
import tkinter as tk                 #Essential for custom dialog box using tk. commands
from tkinter import filedialog       #Essential for file dialog box

#This class is used by the function getFileNames in plugin.py

class cSelectFiles:
    top=""
    #The following variables hold paths and filenames selected by the user
    #when functions in this class are called.
    AutoCheckPath=""
    ManualCheckPath=""
    CssPath=""
    HyphenatedWordPath=""   	###UPDATED OCT2018

    def __init__(self):
        pass    #Dummy - does nothing

    def getCSSFile(self):
        fileOptions = dict(defaultextension='.css', filetypes=[('CSS file','*.css')], title='Open CSS file')
        filePath = filedialog.askopenfilename(**fileOptions)
        if filePath == "": return
        cSelectFiles.CssPath = filePath
        self.entryCSS.delete(0,END)
        self.entryCSS.insert(0,cSelectFiles.CssPath)
    
    def getManualWordCheckList(self):
        fileOptions = dict(defaultextension='.txt', filetypes=[('TXT file','*.txt')], title='Select the file containing words for manually checking the spelling of words')
        filePath = filedialog.askopenfilename(**fileOptions)
        if filePath == "": return
        cSelectFiles.ManualCheckPath  = filePath
        self.entryManualCheck.delete(0,END)
        self.entryManualCheck.insert(0,cSelectFiles.ManualCheckPath)
    
    def getAutoWordCheckList(self):
        fileOptions = dict(defaultextension='.txt', filetypes=[('TXT file','*.txt')], title='Select the file containing words for the automatic correction of spelling')
        filePath = filedialog.askopenfilename(**fileOptions)
        if filePath == "": return
        cSelectFiles.AutoCheckPath  = filePath
        self.entryAutoCheck.delete(0,END)
        self.entryAutoCheck.insert(0,cSelectFiles.AutoCheckPath)
        
    def getHyphenatedWordList(self):    ###ADDED OCT2018
        fileOptions = dict(defaultextension='.txt', filetypes=[('TXT file','*.txt')], title='Select the file containing allowed hyphenated words')
        filePath = filedialog.askopenfilename(**fileOptions)
        if filePath == "": return
        cSelectFiles.HyphenatedWordPath  = filePath
        self.entryHyphenatedCheck.delete(0,END)
        self.entryHyphenatedCheck.insert(0,cSelectFiles.HyphenatedWordPath)
    
    
    def showFileDialog(self, parent):
        cSelectFiles.top = top = tk.Toplevel(parent)
        top.grab_set() #Make dialog box modal
        top.title("Files") #Title for dialog box
        
        mainframe = ttk.Frame(top, padding="15 15 12 12", relief=SUNKEN)
        mainframe.grid(column=0, row=0, sticky=(N, W, E, S))
        mainframe.columnconfigure(0, weight=1)
        mainframe.rowconfigure(0, weight=1)
        tk.Label(mainframe, text = "Files for:", fg="blue").grid(column = 0, row=0, sticky = W)
        
        tk.Label(mainframe, text = "Automated spelling check").grid(column = 0, row=10, sticky = E)
        self.entryAutoCheck = ttk.Entry(mainframe, exportselection=0, width=70)
        self.entryAutoCheck.grid(row=10, column=1, sticky="W")
        self.entryAutoCheck.delete(0,END)
        self.entryAutoCheck.insert(0,cSelectFiles.AutoCheckPath)
        tk.Button(mainframe, text="...", command=self.getAutoWordCheckList, width = 5).grid(column=3, row=10, sticky=W)
        

        tk.Label(mainframe, text = "Manual spelling check").grid(column = 0, row=20, sticky = E)
        self.entryManualCheck = tk.Entry(mainframe, exportselection=0, width=70)
        self.entryManualCheck.grid(row=20, column=1, sticky="W")
        self.entryManualCheck.delete(0,END)
        self.entryManualCheck.insert(0,cSelectFiles.ManualCheckPath)
        tk.Button(mainframe, text="...", command=self.getManualWordCheckList, width = 5).grid(column=3, row=20, sticky=W)
        
        
        tk.Label(mainframe, text = "CSS file:").grid(column = 0, row=30, sticky = E)
        self.entryCSS = tk.Entry(mainframe, exportselection=0, width=70)
        self.entryCSS.grid(row=30, column=1, sticky="W")
        self.entryCSS.delete(0,END)
        self.entryCSS.insert(0,cSelectFiles.CssPath)
        tk.Button(mainframe, text="...", command=self.getCSSFile, width = 5).grid(column=3, row=30, sticky=W)

        #=========== This section Added OCT2018 ===================
        tk.Label(mainframe, text = "Hyphen file:").grid(column = 0, row=40, sticky = E)
        self.entryHyphenatedCheck = tk.Entry(mainframe, exportselection=0, width=70)
        self.entryHyphenatedCheck.grid(row=40, column=1, sticky="W")
        self.entryHyphenatedCheck.delete(0,END)
        self.entryHyphenatedCheck.insert(0,cSelectFiles.HyphenatedWordPath)
        tk.Button(mainframe, text="...", command=self.getHyphenatedWordList, width = 5).grid(column=3, row=40, sticky=W)

        tk.Label(mainframe, text = "").grid(column = 0, row=80, sticky = E) #Blank line
        
        tk.Button(mainframe, text="Close", command=self.Close, width = 20).grid(column=0, row=90, sticky=W)
        
        top.bind('<Return>', self.ClosePressed)
        
    def ClosePressed(self, event):
        self.Close()

    def Close(self):
        """
        Called by a button click in the method showHeadtagsDlg() via OKPressed
        Sets processHeadersFlag to True and sets all the items in the dictionary to 
        the options selected by the user  before destroying the dialog
        """
        self.top.destroy()
        