#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
This unit determines the quote marks to use in replacement text
"""


from sigil_bs4 import BeautifulSoup

class cDetermineQuotes:
    #Static class variables    #Used to hold the most common type of quote marks in the text
    OpenQ=""
    CloseQ=""
    Apostrophe=""
    
    def __init__(self):
        self.quoteDict={}    #Clears dictionary that holds a count of each type of quote mark

    def countQuotes(self, html_doc):
        """
        This  is called by an external module.
        html_doc is the html text to check.
        """
        soup = BeautifulSoup(html_doc, 'html.parser')
        text = soup.get_text()  #Get text only
        self.doCount(html_doc)   

    def doCount(self, html):
       self.quoteDict["SingleCurlyQuoteCount"]=self.quoteDict.get("SingleCurlyQuoteCount",0)+html.count("‘")        
       self.quoteDict["SingleCurlyQuoteCount"]=self.quoteDict.get("SingleCurlyQuoteCount",0)+html.count("&#8216;")
       self.quoteDict["SingleCurlyQuoteCount"]=self.quoteDict.get("SingleCurlyQuoteCount",0)+html.count("&lsquo;")
       self.quoteDict["DoubleCurlyQuoteCount"]=self.quoteDict.get("DoubleCurlyQuoteCount",0)+html.count('“')
       self.quoteDict["DoubleCurlyQuoteCount"]=self.quoteDict.get("DoubleCurlyQuoteCount",0)+html.count('&#8220;')
       self.quoteDict["DoubleCurlyQuoteCount"]=self.quoteDict.get("DoubleCurlyQuoteCount",0)+html.count('&ldquo;')
       self.quoteDict["SingleStraightQuoteCount"]=self.quoteDict.get("SingleStraightQuoteCount",0)+html.count("'")
       self.quoteDict["SingleStraightQuoteCount"]=self.quoteDict.get("SingleStraightQuoteCount",0)+html.count("&#39;")
       self.quoteDict["SingleStraightQuoteCount"]=self.quoteDict.get("SingleStraightQuoteCount",0)+html.count("&apos;")  
       self.quoteDict["DoubleStraightQuoteCount"]=self.quoteDict.get("DoubleStraightQuoteCount",0)+html.count('"')

    def determineQuotesToUse(self):
        """
        Then function checks to see whether there are significant numbers of quotes other than "; if not the
        quotes used for open/closing speeches is set to "
        """
        #Opening and closing straight quotes are counted twice, so divide by 2
        self.quoteDict["SingleStraightQuoteCount"]=self.quoteDict["SingleStraightQuoteCount"]//2 #Need integer result only
        self.quoteDict["DoubleStraightQuoteCount"]=self.quoteDict["DoubleStraightQuoteCount"]//2 #Need integer result only
        
        if self.quoteDict["SingleCurlyQuoteCount"] > self.quoteDict["DoubleCurlyQuoteCount"]:
            qType="SingleCurlyQuoteCount"
        else:
            qType="DoubleCurlyQuoteCount"
        if self.quoteDict["SingleStraightQuoteCount"] > self.quoteDict[qType]:
            qType="SingleStraightQuoteCount"
        if self.quoteDict["DoubleStraightQuoteCount"] >  self.quoteDict[qType]:
            qType="DoubleStraightQuoteCount"

        cDetermineQuotes.Apostrophe = "'"    #Straight apostrophe
        if qType=="DoubleStraightQuoteCount":
            cDetermineQuotes.OpenQ = '"'
            cDetermineQuotes.CloseQ = '"'
        elif qType=="SingleStraightQuoteCount":
            cDetermineQuotes.OpenQ = "'"
            cDetermineQuotes.CloseQ = "'"
        elif qType=="DoubleCurlyQuoteCount":
            cDetermineQuotes.OpenQ = '“'
            cDetermineQuotes.CloseQ = '”'
            cDetermineQuotes.Apostrophe = "’"    #Curled apostrophe                
        else: 
            cDetermineQuotes.OpenQ = "‘"
            cDetermineQuotes.CloseQ = "’"
            cDetermineQuotes.Apostrophe = "’"    #Curled apostrophe        

